/*
 * JRParameterDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 9 maggio 2003, 17.25
 */
package it.businesslogic.ireport.crosstab.gui;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.crosstab.CrosstabColumnGroup;
import it.businesslogic.ireport.crosstab.CrosstabGroup;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.Misc;


/**
 * @author Administrator
 */
public class CrosstabGroupDialog
    extends javax.swing.JDialog
{
    public static final int ROWGROUP = 0;
    public static final int COLUMNGROUP = 1;
    
    private CrosstabGroup tmpGroup = null;
    private int groupType = 1;

    /**
     * Creates a new CrosstabGroupDialog object.
     * 
     * @param subDataset DOCUMENT ME!
     * @param parent DOCUMENT ME!
     * @param modal DOCUMENT ME!
     */
    public CrosstabGroupDialog(int groupType, java.awt.Frame parent, 
                            boolean modal)
    {
        super(parent, modal);
        initAll(groupType);
    }
    
    public CrosstabGroupDialog(int groupType, java.awt.Dialog parent, 
                            boolean modal)
    {
        super(parent, modal);
        initAll(groupType);
    }

    public void initAll(int groupType)
    {
        initComponents();
        
        jComboBoxBucketClass.addItem("java.lang.String");
        jComboBoxBucketClass.addItem("java.lang.Double");
        jComboBoxBucketClass.addItem("java.lang.Float");
        jComboBoxBucketClass.addItem("java.lang.Integer");
        jComboBoxBucketClass.addItem("java.lang.Long");
        jComboBoxBucketClass.addItem("java.lang.Short");
        jComboBoxBucketClass.addItem("java.math.BigDecimal");
        
        jComboBoxBucketClass.addItem("java.util.Date");
        jComboBoxBucketClass.addItem("java.sql.Timestamp");
        jComboBoxBucketClass.addItem("java.sql.Time");
        
        setGroupType(groupType);
        
        //this.setSize(400, 400);
        Misc.centerFrame(this);
        pack();
    }



    /**
     * This method is called from within the constructor to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */


    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jTextFieldName = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jLabelSize = new javax.swing.JLabel();
        jNumberFieldSize = new it.businesslogic.ireport.gui.JNumberField();
        jPanel2 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jRTextExpressionAreaExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabel4 = new javax.swing.JLabel();
        jComboBoxOrder = new javax.swing.JComboBox();
        jLabel5 = new javax.swing.JLabel();
        jPanel5 = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        jComboBoxBucketClass = new javax.swing.JComboBox();
        jRTextExpressionAreaComparatorExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jPanel3 = new javax.swing.JPanel();
        jComboBoxTotalPosition = new javax.swing.JComboBox();
        jComboBoxHeaderPosition = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Add/modify crosstab group");
        setModal(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jLabel1.setText("Group name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        getContentPane().add(jLabel1, gridBagConstraints);

        jTextFieldName.setPreferredSize(new java.awt.Dimension(360, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        getContentPane().add(jTextFieldName, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jPanel1.setMinimumSize(new java.awt.Dimension(126, 40));
        jPanel1.setPreferredSize(new java.awt.Dimension(126, 40));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add(jPanel4, gridBagConstraints);

        jButtonOK.setMnemonic('o');
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        jPanel1.add(jButtonOK, gridBagConstraints);

        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        jPanel1.add(jButtonCancel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 99;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jPanel1, gridBagConstraints);

        jLabelSize.setText("Group width / height");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabelSize, gridBagConstraints);

        jNumberFieldSize.setColumns(4);
        jNumberFieldSize.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        try {
            jNumberFieldSize.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldSize.setMinimumSize(new java.awt.Dimension(40, 21));
        jNumberFieldSize.setPreferredSize(new java.awt.Dimension(38, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jNumberFieldSize, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Bucket", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
        jLabel3.setText("Bucket expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        jPanel2.add(jLabel3, gridBagConstraints);

        jRTextExpressionAreaExpression.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionAreaExpression.setCaretVisible(false);
        jRTextExpressionAreaExpression.setElectricScroll(0);
        jRTextExpressionAreaExpression.setMinimumSize(new java.awt.Dimension(657, 90));
        jRTextExpressionAreaExpression.setPreferredSize(new java.awt.Dimension(325, 100));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        jPanel2.add(jRTextExpressionAreaExpression, gridBagConstraints);

        jLabel4.setText("Order");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        jPanel2.add(jLabel4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel2.add(jComboBoxOrder, gridBagConstraints);

        jLabel5.setText("Custom comparator expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        jPanel2.add(jLabel5, gridBagConstraints);

        jPanel5.setLayout(new java.awt.GridBagLayout());

        jLabel6.setText("Class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        jPanel5.add(jLabel6, gridBagConstraints);

        jComboBoxBucketClass.setEditable(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel5.add(jComboBoxBucketClass, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add(jPanel5, gridBagConstraints);

        jRTextExpressionAreaComparatorExpression.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jRTextExpressionAreaComparatorExpression.setCaretVisible(false);
        jRTextExpressionAreaComparatorExpression.setElectricScroll(0);
        jRTextExpressionAreaComparatorExpression.setMinimumSize(new java.awt.Dimension(657, 45));
        jRTextExpressionAreaComparatorExpression.setPreferredSize(new java.awt.Dimension(325, 45));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        jPanel2.add(jRTextExpressionAreaComparatorExpression, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jPanel2, gridBagConstraints);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel3.add(jComboBoxTotalPosition, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel3.add(jComboBoxHeaderPosition, gridBagConstraints);

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel2.setText("Print the group header on this position: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanel3.add(jLabel2, gridBagConstraints);

        jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel7.setText("Print the group total on this position: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        jPanel3.add(jLabel7, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jPanel3, gridBagConstraints);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        java.awt.Dimension dialogSize = getSize();
        setLocation((screenSize.width-dialogSize.width)/2,(screenSize.height-dialogSize.height)/2);
    }// </editor-fold>//GEN-END:initComponents
    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonCancelActionPerformed
    {
        setVisible(false);
        this.setDialogResult(javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonOKActionPerformed
    {

        if (this.jTextFieldName.getText().trim().length() <= 0)
        {
            javax.swing.JOptionPane.showMessageDialog(this, 
                                                      "Please insert a valid group name!", 
                                                      "Invalid group!", 
                                                      javax.swing.JOptionPane.WARNING_MESSAGE);

            return;
        }
        
        if ((""+this.jComboBoxBucketClass.getSelectedItem()).trim().length() <= 0)
        {
            javax.swing.JOptionPane.showMessageDialog(this, 
                                                      "Please insert a valid class name for the bucket!", 
                                                      "Invalid class!", 
                                                      javax.swing.JOptionPane.WARNING_MESSAGE);

            return;
        }

        tmpGroup = new CrosstabGroup();
        
        tmpGroup.setName(jTextFieldName.getText().trim());
        
        
        tmpGroup.setBucketExpressionClass(
                this.jComboBoxBucketClass.getSelectedItem() + "");
        
        tmpGroup.setSize((int)jNumberFieldSize.getValue());
        
        tmpGroup.setBucketExpression( jRTextExpressionAreaExpression.getText());
        tmpGroup.setBucketComparatorExpression( jRTextExpressionAreaComparatorExpression.getText());
        tmpGroup.setBucketOrder(""+((Tag)jComboBoxOrder.getSelectedItem()).getValue());

        
        tmpGroup.setTotalPosition(""+((Tag)jComboBoxTotalPosition.getSelectedItem()).getValue());
        tmpGroup.setHasTotal( !tmpGroup.getTotalPosition().equals("None") );
        tmpGroup.setHasHeader(true );
        tmpGroup.setHeaderPosition(""+((Tag)jComboBoxHeaderPosition.getSelectedItem()).getValue());
        
        setVisible(false);
        this.setDialogResult(javax.swing.JOptionPane.OK_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed

    /**
     * Closes the dialog
     * @param evt DOCUMENT ME!
     */
    private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
    {
        setVisible(false);
        this.setDialogResult(javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    }//GEN-LAST:event_closeDialog


    /**
     * Getter for property dialogResult.
     * 
     * @return Value of property dialogResult.
     */
    public int getDialogResult()
    {

        return dialogResult;
    }

    /**
     * Setter for property dialogResult.
     * 
     * @param dialogResult New value of property dialogResult.
     */
    public void setDialogResult(int dialogResult)
    {
        this.dialogResult = dialogResult;
    }
    
    public void setExpressionContext(SubDataset sds)
    {
        if (sds == null)
        {
            sds = MainFrame.getMainInstance().getActiveReportFrame().getReport();
        }
        this.jRTextExpressionAreaComparatorExpression.setSubDataset( sds);
        this.jRTextExpressionAreaComparatorExpression.getCrosstabElements().removeAllElements();
        this.jRTextExpressionAreaExpression.setSubDataset( sds );
        this.jRTextExpressionAreaExpression.getCrosstabElements().removeAllElements();
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JComboBox jComboBoxBucketClass;
    private javax.swing.JComboBox jComboBoxHeaderPosition;
    private javax.swing.JComboBox jComboBoxOrder;
    private javax.swing.JComboBox jComboBoxTotalPosition;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabelSize;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldSize;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaComparatorExpression;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaExpression;
    private javax.swing.JTextField jTextFieldName;
    // End of variables declaration//GEN-END:variables
    private int dialogResult;


    public CrosstabGroup getGroup() {
        return tmpGroup;
    }

    public void setGroup(CrosstabGroup group) {

        if (group instanceof CrosstabColumnGroup)
        {
            setGroupType(COLUMNGROUP);
        }
        else
        {
            setGroupType(ROWGROUP);
        }
        
        jTextFieldName.setText(group.getName());
        try {
            
            jNumberFieldSize.setValue( group.getSize());
        } 
        catch (Exception ex) 
        {
        }
        
        Misc.setComboboxSelectedTagValue(jComboBoxTotalPosition, group.getTotalPosition());
        
        Misc.setComboboxSelectedTagValue(jComboBoxHeaderPosition, group.getHeaderPosition());
        
        jRTextExpressionAreaExpression.setText( group.getBucketExpression());
        Misc.setComboboxSelectedTagValue(jComboBoxOrder, group.getBucketOrder());
        jRTextExpressionAreaComparatorExpression.setText( group.getBucketComparatorExpression() );       
        jComboBoxBucketClass.setSelectedItem(group.getBucketExpressionClass());
       
    }

    public int getGroupType() {
        return groupType;
    }

    public void setGroupType(int groupType) {
        this.groupType = groupType;
            
        this.jComboBoxOrder.removeAllItems();
        this.jComboBoxOrder.addItem(new Tag("Ascending","Ascending"));
        this.jComboBoxOrder.addItem(new Tag("Descending","Descending"));
        Misc.setComboboxSelectedTagValue(jComboBoxTotalPosition, "Ascending");
        
        
        this.jComboBoxTotalPosition.removeAllItems();
         this.jComboBoxTotalPosition.addItem(new Tag("None","None"));
        this.jComboBoxTotalPosition.addItem(new Tag("Start","Start"));
        this.jComboBoxTotalPosition.addItem(new Tag("End","End"));
        Misc.setComboboxSelectedTagValue(jComboBoxTotalPosition, "None");
            
        if (groupType == this.COLUMNGROUP)
        {
            
            try { this.jNumberFieldSize.setValue(30); } catch (Exception ex) {}
            
            this.jLabelSize.setText("Group height");
            this.jComboBoxHeaderPosition.removeAllItems();
            this.jComboBoxHeaderPosition.addItem(new Tag("Left","Left"));
            this.jComboBoxHeaderPosition.addItem(new Tag("Center","Center"));
            this.jComboBoxHeaderPosition.addItem(new Tag("Right","Right"));
            this.jComboBoxHeaderPosition.addItem(new Tag("Stretch","Stretch"));
            
            Misc.setComboboxSelectedTagValue(jComboBoxHeaderPosition, "Left");
            
        }
        else
        {
            try { this.jNumberFieldSize.setValue(100); } catch (Exception ex) {}
            
            this.jLabelSize.setText("Group width"); 
            this.jComboBoxHeaderPosition.removeAllItems();
            this.jComboBoxHeaderPosition.addItem(new Tag("Top","Top"));
            this.jComboBoxHeaderPosition.addItem(new Tag("Middle","Middle"));
            this.jComboBoxHeaderPosition.addItem(new Tag("Bottom","Bottom"));
            this.jComboBoxHeaderPosition.addItem(new Tag("Stretch","Stretch"));
            
            Misc.setComboboxSelectedTagValue(jComboBoxHeaderPosition, "Top");
        }
        
    }
}
