/*
 * CompatibilityDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 2 giugno 2003, 22.30
 * Updated August 9, Robert Lamping
 * - Activated Ok and Cancel button
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.Misc;
import it.businesslogic.ireport.*;
/**
 *
 * @author  Administrator
 */
public class CompatibilityDialog extends javax.swing.JDialog {

    MainFrame mf = null;


    public CompatibilityDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        this.mf = (MainFrame)parent;
        initComponents();
        this.setSize(330, 150);

        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR060, "JasperReports 0.6.0"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR061, "JasperReports 0.6.1"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR062, "JasperReports 0.6.2"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR063, "JasperReports 0.6.3"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR064, "JasperReports 0.6.4 - 0.6.5"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR066, "JasperReports 0.6.6"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR067, "JasperReports 0.6.7 - 0.6.8"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR069, "JasperReports 0.6.9"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR100, "JasperReports 1.0.0"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR103, "JasperReports 1.0.3"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR110, "JasperReports 1.1.0"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR111, "JasperReports 1.1.1"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR120, "JasperReports 1.2.0"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.JR125, "JasperReports 1.2.5"));
        jComboBox1.addItem(new JRVersionItem( CompatibilitySupport.LAST_AVAILABLE_VERSION, it.businesslogic.ireport.util.I18n.getString("lastAvailableVersion")));

        load();
        Misc.centerFrame(this);


    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jPanel9 = new javax.swing.JPanel();
        jComboBox1 = new javax.swing.JComboBox();
        jPanel2 = new javax.swing.JPanel();
        jButtonOk = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();

        setTitle("Compatibility options");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel9.setLayout(new java.awt.GridBagLayout());

        jPanel9.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "JasperReports Version Compatibility", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
        jPanel9.setMinimumSize(new java.awt.Dimension(250, 150));
        jPanel9.setPreferredSize(new java.awt.Dimension(250, 150));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel9.add(jComboBox1, gridBagConstraints);

        jPanel1.add(jPanel9, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        jPanel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        jButtonOk.setMnemonic('o');
        jButtonOk.setText("Ok");
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        jPanel2.add(jButtonOk);

        jButtonCancel.setText("Cancel");
        jButtonCancel.setMnemonic('c');
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        jPanel2.add(jButtonCancel);

        getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        close();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed
        save();
        close();
    }//GEN-LAST:event_jButtonOkActionPerformed

    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        // Add your handling code here:
    }//GEN-LAST:event_closeDialog

    private void load(){
        if (mf == null || mf.getProperties() == null) {
            return;
        }
        java.util.Properties prop = mf.getProperties();

        try {

            for (int i=0; i<jComboBox1.getItemCount(); ++i)
            {

                JRVersionItem jvi = (JRVersionItem)jComboBox1.getItemAt(i);
                if (jvi.getVersion() == CompatibilitySupport.version)
                {
                    jComboBox1.setSelectedIndex(i);
                    break;
                }
            }


        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void save(){
        if (mf == null || mf.getProperties() == null) {
            return;
        }
        java.util.Properties prop = mf.getProperties();

        try {
            int compatibility = CompatibilitySupport.LAST_AVAILABLE_VERSION;

            if (jComboBox1.getSelectedItem() != null)
            {
                compatibility = ((JRVersionItem)jComboBox1.getSelectedItem()).getVersion();
            }

           CompatibilitySupport.version = compatibility;
            prop.put("Compatibility", ""+compatibility);

        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    private void close(){
        setVisible(false);
        dispose();
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new CompatibilityDialog(new javax.swing.JFrame(), true).setVisible(true);
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel9;
    // End of variables declaration//GEN-END:variables

}


class JRVersionItem
{
    private int version = 0;
    private String desc = "";

    public JRVersionItem(int version, String desc)
    {
        this.version = version;
        this.desc = desc;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String toString()
    {
        return desc;
    }
}
