/*
 * StyleChangedEvent.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 10 febbraio 2003, 2.04
 */

package it.businesslogic.ireport.gui.event;

import java.awt.Component;

/**
 * This event is fired when a group is added or when a cell is resized or when the crosstab element changes
 * his dimension...
 * @author  Administrator
 */
public class TabPaneChangedEvent {
       
    public static final int MINIMIZED = 0;
    public static final int CLOSED = 1;
    
    private int tabIndex = -1;
    private Component tabComponent = null;
    private int operation = -1;
    
    /** Creates a new instance of ValueChangedEvent */
    public TabPaneChangedEvent(int  operation, Component tabComponent, int tabIndex) {
        this.setOperation(operation);
        this.setTabComponent(tabComponent);
        this.setTabIndex(tabIndex);
    }

    public int getTabIndex() {
        return tabIndex;
    }

    public void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }

    public Component getTabComponent() {
        return tabComponent;
    }

    public void setTabComponent(Component tabComponent) {
        this.tabComponent = tabComponent;
    }

    public int getOperation() {
        return operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }
    
}
