/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import mondrian.olap.Connection;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnection;

public class DriverManager {
    public static Connection getConnection(String connectString, ServletContext servletContext, boolean fresh) {
        Util.PropertyList properties = Util.parseConnectString(connectString);
        return DriverManager.getConnection(properties, servletContext, fresh);
    }

    private static void fixup(Util.PropertyList connectionProperties, ServletContext servletContext) {
        String catalog = connectionProperties.get("catalog");
        if (catalog != null && catalog.startsWith("/")) {
            try {
                URL url = servletContext.getResource(catalog);
                if (url == null) {
                    url = servletContext.getResource("/");
                    url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile() + catalog.substring(1));
                }
                if (url != null) {
                    catalog = url.toString();
                    connectionProperties.put("catalog", catalog);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private static Connection getAdomdConnection(String connectString, boolean fresh) {
        try {
            Class<?> clazz = Class.forName("Broadbase.mdx.adomd.AdomdConnection");
            try {
                Object sCatalog = null;
                Constructor<?> constructor = clazz.getConstructor(String.class, String.class, Boolean.TYPE);
                return (Connection)constructor.newInstance(connectString, sCatalog, fresh ? Boolean.TRUE : Boolean.FALSE);
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "while creating " + clazz);
            }
            catch (NoSuchMethodException e) {
                throw Util.newInternal(e, "while creating " + clazz);
            }
            catch (InstantiationException e) {
                throw Util.newInternal(e, "while creating " + clazz);
            }
            catch (InvocationTargetException e) {
                throw Util.newInternal(e, "while creating " + clazz);
            }
        }
        catch (ClassNotFoundException e) {
            throw Util.newInternal(e, "while connecting to " + connectString);
        }
    }

    public static Connection getConnection(Util.PropertyList properties, boolean fresh) {
        return DriverManager.getConnection(properties, null, fresh);
    }

    public static Connection getConnection(Util.PropertyList properties, ServletContext servletContext, boolean fresh) {
        return DriverManager.getConnection(properties, servletContext, null, fresh);
    }

    public static Connection getConnection(Util.PropertyList properties, ServletContext servletContext, DataSource dataSource, boolean fresh) {
        String provider = properties.get("PROVIDER");
        if (!provider.equalsIgnoreCase("mondrian")) {
            String connectString = properties.toString();
            return DriverManager.getAdomdConnection(connectString, fresh);
        }
        if (servletContext != null) {
            MondrianProperties.instance().populate(servletContext);
            DriverManager.fixup(properties, servletContext);
        }
        return new RolapConnection(properties, dataSource);
    }
}

