/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Arrays;
import java.util.List;
import mondrian.olap.CellFormatter;
import mondrian.olap.MondrianDef;
import mondrian.olap.Property;
import mondrian.olap.Util;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapMember;

class RolapStoredMeasure
extends RolapMeasure {
    private static final List datatypeList = Arrays.asList("Integer", "Numeric", "String");
    private final MondrianDef.Expression expression;
    private final RolapAggregator aggregator;
    private final RolapCube cube;
    private CellFormatter formatter;

    RolapStoredMeasure(RolapCube cube, RolapMember parentMember, RolapLevel level, String name, String formatString, MondrianDef.Expression expression, String aggregatorName, String datatype) {
        super(parentMember, level, name, formatString);
        this.cube = cube;
        this.expression = expression;
        this.aggregator = (RolapAggregator)RolapAggregator.enumeration.getValue(aggregatorName, true);
        if (this.aggregator == null) {
            throw Util.newError("Unknown aggregator '" + aggregatorName + "'");
        }
        this.setProperty(Property.AGGREGATION_TYPE.name, this.aggregator);
        if (datatype == null) {
            datatype = this.aggregator == RolapAggregator.Count || this.aggregator == RolapAggregator.DistinctCount ? "Integer" : "Numeric";
        }
        Util.assertTrue(datatypeList.contains(datatype), "invalid datatype " + datatype);
        this.setProperty(Property.DATATYPE.name, datatype);
    }

    MondrianDef.Expression getMondrianDefExpression() {
        return this.expression;
    }

    RolapAggregator getAggregator() {
        return this.aggregator;
    }

    RolapCube getCube() {
        return this.cube;
    }

    CellReader getCellReader() {
        return this.cube.getCellReader();
    }

    public CellFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(CellFormatter formatter) {
        this.formatter = formatter;
    }
}

