/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.adapter;

import java.awt.Component;
import java.util.Hashtable;
import org.flexdock.docking.adapter.AdapterMapping;
import org.flexdock.docking.adapter.DockingAdapter;
import org.flexdock.docking.adapter.MappingReader;
import org.flexdock.util.ResourceManager;
import org.w3c.dom.Document;

public class AdapterFactory {
    public static final String ADAPTER_RESOURCE_KEY = "flexdock.adapters";
    public static final String DEFAULT_ADAPTER_RESOURCE = "flexdock-adapters.xml";
    private static final Hashtable MAPPINGS_BY_CLASS = new Hashtable();

    public static void prime() {
        AdapterFactory.loadMappings();
    }

    public static DockingAdapter getAdapter(Component comp) {
        if (comp == null) {
            return null;
        }
        AdapterMapping mapping = AdapterFactory.getMapping(comp);
        if (mapping == null) {
            return null;
        }
        DockingAdapter adapter = new DockingAdapter(comp, mapping);
        if (adapter.getComponent() == null || adapter.getPersistentId() == null) {
            return null;
        }
        return adapter;
    }

    private static AdapterMapping getMapping(Object obj) {
        String className = obj.getClass().getName();
        return (AdapterMapping)MAPPINGS_BY_CLASS.get(className);
    }

    private static void loadMappings() {
        Document document;
        String uri = System.getProperty(ADAPTER_RESOURCE_KEY);
        if (uri == null) {
            uri = DEFAULT_ADAPTER_RESOURCE;
        }
        if ((document = ResourceManager.getDocument(uri)) == null && !DEFAULT_ADAPTER_RESOURCE.equals(uri)) {
            document = ResourceManager.getDocument(DEFAULT_ADAPTER_RESOURCE);
        }
        if (document == null) {
            return;
        }
        MappingReader reader = new MappingReader();
        AdapterMapping[] mappings = reader.readMappings(document);
        for (int i = 0; i < mappings.length; ++i) {
            MAPPINGS_BY_CLASS.put(mappings[i].getClassName(), mappings[i]);
        }
    }
}

