/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.util.Collection;
import java.util.List;
import jcmdline.CmdLineHandler;
import jcmdline.CmdLineParser;
import jcmdline.Parameter;

public abstract class AbstractHandlerDecorator
implements CmdLineHandler {
    private CmdLineHandler handler;
    private Parameter[] customOptions;

    protected AbstractHandlerDecorator(CmdLineHandler handler) {
        this.handler = handler;
    }

    protected void setCustomOptions(Parameter[] customOptions) {
        if (customOptions == null) {
            customOptions = new Parameter[]{};
        }
        this.customOptions = customOptions;
        for (int i = 0; i < customOptions.length; ++i) {
            this.handler.addOption(customOptions[i]);
        }
    }

    protected Parameter[] getCustomOptions() {
        return this.customOptions;
    }

    protected abstract boolean processParsedOptions(boolean var1);

    public void setDieOnParseError(boolean val) {
        this.handler.setDieOnParseError(val);
    }

    public boolean getDieOnParseError() {
        return this.handler.getDieOnParseError();
    }

    public boolean parse(String[] clargs) {
        boolean parseStatus = this.handler.parse(clargs);
        return this.processParsedOptions(parseStatus);
    }

    public void setParser(CmdLineParser parser) {
        this.handler.setParser(parser);
    }

    public CmdLineParser getParser() {
        return this.handler.getParser();
    }

    public void setArgs(Parameter[] args) {
        this.handler.setArgs(args);
    }

    public void addArg(Parameter arg) {
        this.handler.addArg(arg);
    }

    public List getArgs() {
        return this.handler.getArgs();
    }

    public Parameter getArg(String tag) {
        return this.handler.getArg(tag);
    }

    public void setOptions(Parameter[] options) {
        this.handler.setOptions(options);
        for (int i = 0; i < this.customOptions.length; ++i) {
            this.handler.addOption(this.customOptions[i]);
        }
    }

    public void addOption(Parameter opt) {
        this.handler.addOption(opt);
    }

    public Collection getOptions() {
        return this.handler.getOptions();
    }

    public Parameter getOption(String tag) {
        return this.handler.getOption(tag);
    }

    public void setCmdDesc(String cmdDesc) {
        this.handler.setCmdDesc(cmdDesc);
    }

    public String getCmdDesc() {
        return this.handler.getCmdDesc();
    }

    public void setCmdName(String cmdName) {
        this.handler.setCmdName(cmdName);
    }

    public String getCmdName() {
        return this.handler.getCmdName();
    }

    public String getUsage(boolean hidden) {
        return this.handler.getUsage(hidden);
    }

    public void setParseError(String parseError) {
        this.handler.setParseError(parseError);
    }

    public String getParseError() {
        return this.handler.getParseError();
    }

    public void exitUsageError(String errMsg) {
        this.handler.exitUsageError(errMsg);
    }
}

