/*
 * Copyright (C) 2005 - 2006 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * TreeTransfertHandler.java
 * 
 * Created on 15 settembre 2004, 2.19
 *
 */

package it.businesslogic.ireport.gui.library;
import java.awt.datatransfer.Transferable;
import javax.swing.*;
import javax.swing.tree.*;
/**
 *
 * @author  Administrator
 */
public class TreeTransfertHandler extends javax.swing.TransferHandler {
    
    /** Creates a new instance of TreeTransfertHandler */
    public TreeTransfertHandler() {
        super();
    }
    
    public int getSourceActions(JComponent c) 
    {
        return COPY_OR_MOVE;
        
    }
    
    protected Transferable createTransferable(JComponent c) 
    {
        if (c instanceof JTree)
        {
            JTree tree = (JTree)c;
            TreePath path = tree.getLeadSelectionPath();
	    DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
            return new it.businesslogic.ireport.gui.dnd.TransferableObject(dmtn.getUserObject());           
        }
        
        return new it.businesslogic.ireport.gui.dnd.TransferableObject(c);
    }
}
