/*
 * Copyright (C) 2005 - 2006 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * LogPane.java
 * 
 * Created on 22 agosto 2005, 15.02
 *
 */

package it.businesslogic.ireport.gui.logpane;
import java.util.*;
import it.businesslogic.ireport.util.LanguageChangedEvent;

/**
 *
 * @author  Administrator
 */
public class LogPane extends javax.swing.JPanel implements java.awt.event.ActionListener {

    private LogTextArea mainLogTextArea;
    private Vector logsComponents = new Vector();
    private LogTextArea pointedLogTextArea = null;
    private Properties properties;

    /** Creates new form LogPane */
    public LogPane() {
        initComponents();
        mainLogTextArea = new LogTextArea("Main console");
        mainLogTextArea.setLogPane( this );
        mainLogTextArea.addActionListener( this );

        updateLogTabs();
    }

    protected void updateLogTabs()
    {
        if (logsComponents.size() > 0)
        {

                jTabbedPaneLogs.removeAll();
                jTabbedPaneLogs.add(mainLogTextArea.getTitle(), mainLogTextArea);

                for (int i=0; i<logsComponents.size(); ++i)
                {
                    jTabbedPaneLogs.add(((LogTextArea)logsComponents.elementAt(i)).getTitle(),
                                         (LogTextArea)logsComponents.elementAt(i));
                }

                if (getComponentCount()==0  || getComponent(0) != jTabbedPaneLogs)
                {
                    remove(mainLogTextArea);
                    add(jTabbedPaneLogs, java.awt.BorderLayout.CENTER);
                }
        }
        else
        {
            if (getComponentCount()==0  || getComponent(0) == jTabbedPaneLogs)
            {
                if (getComponentCount() > 0) remove(jTabbedPaneLogs);
                add(mainLogTextArea, java.awt.BorderLayout.CENTER);
            }
        }

        this.updateUI();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPopupMenuLog = new javax.swing.JPopupMenu();
        jMenuItemClearLog = new javax.swing.JMenuItem();
        jMenuItemCloseLog = new javax.swing.JMenuItem();
        jMenuItemKeepLog = new javax.swing.JMenuItem();
        jTabbedPaneLogs = new javax.swing.JTabbedPane();

        jMenuItemClearLog.setText("Clear log");
        jMenuItemClearLog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemClearLogActionPerformed(evt);
            }
        });

        jPopupMenuLog.add(jMenuItemClearLog);

        jMenuItemCloseLog.setText("Close log");
        jMenuItemCloseLog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCloseLogActionPerformed(evt);
            }
        });

        jPopupMenuLog.add(jMenuItemCloseLog);

        jMenuItemKeepLog.setText("Keep log");
        jMenuItemKeepLog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemKeepLogActionPerformed(evt);
            }
        });

        jPopupMenuLog.add(jMenuItemKeepLog);

        setLayout(new java.awt.BorderLayout());

        jTabbedPaneLogs.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTabbedPaneLogsMouseClicked(evt);
            }
        });

        add(jTabbedPaneLogs, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents

    private void jMenuItemKeepLogActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemKeepLogActionPerformed
        this.pointedLogTextArea.setRemovable(false);
    }//GEN-LAST:event_jMenuItemKeepLogActionPerformed

    private void jMenuItemCloseLogActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCloseLogActionPerformed
        if (this.pointedLogTextArea != getMainLogTextArea())
        {
            this.removeLog(pointedLogTextArea);
        }
    }//GEN-LAST:event_jMenuItemCloseLogActionPerformed

    private void jTabbedPaneLogsMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTabbedPaneLogsMouseClicked


        if (evt.getButton() == evt.BUTTON3 && evt.getClickCount() == 1) {
            this.jPopupMenuLog.show(this, evt.getPoint().x, evt.getPoint().y);
            this.pointedLogTextArea = (LogTextArea)jTabbedPaneLogs.getSelectedComponent();
        }
    }//GEN-LAST:event_jTabbedPaneLogsMouseClicked

    private void jMenuItemClearLogActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemClearLogActionPerformed

           this.pointedLogTextArea.clearConsole();

    }//GEN-LAST:event_jMenuItemClearLogActionPerformed


    public LogTextArea createNewLog()
    {
        LogTextArea lta = new LogTextArea("Log");
        lta.setLogPane( this );
        lta.addActionListener( this );
        logsComponents.addElement(lta);
        for (int i=0; i<logsComponents.size(); ++i)
        {
            if ( ((LogTextArea)logsComponents.elementAt(i)).isRemovable())
            {
                logsComponents.removeElementAt(i);
                i--;
            }
        }
        updateLogTabs();
        return lta;
    }

    public void removeLog(int logIndex)
    {
        logsComponents.removeElementAt(logIndex);
        updateLogTabs();
    }

    public void removeLog(LogTextArea logTextArea)
    {
        logsComponents.removeElement(logTextArea);
        updateLogTabs();
    }

    public void actionPerformed(java.awt.event.ActionEvent actionEvent) {

        if (actionEvent.getSource() == null) return;
        for (int i=0; i<jTabbedPaneLogs.getComponentCount(); ++i)
        {
            LogTextArea lta = (LogTextArea)jTabbedPaneLogs.getComponent(i);
            if (lta == actionEvent.getSource())
            {
                jTabbedPaneLogs.setTitleAt(i, lta.getTitle());
                break;
            }
        }
    }

    public LogTextArea getMainLogTextArea() {
        return mainLogTextArea;
    }

    public void setMainLogTextArea(LogTextArea mainLogTextArea) {
        this.mainLogTextArea = mainLogTextArea;
    }

    public void setActiveLog( LogTextArea logTextArea) {
        try {
        jTabbedPaneLogs.setSelectedComponent(logTextArea);
        } catch (Exception ex) {}
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem jMenuItemClearLog;
    private javax.swing.JMenuItem jMenuItemCloseLog;
    private javax.swing.JMenuItem jMenuItemKeepLog;
    private javax.swing.JPopupMenu jPopupMenuLog;
    private javax.swing.JTabbedPane jTabbedPaneLogs;
    // End of variables declaration//GEN-END:variables

    //Added by Felix Firgau for I18n on Feb 10th 2006
    public void applyI18n() {
      jMenuItemClearLog.setText(it.businesslogic.ireport.util.I18n.getString("clearLog", "Clear log"));

    }
    public void languageChanged(LanguageChangedEvent evt) {
      this.applyI18n();
    }//End
}
