/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.chart.ChartDatasetPanel;
import it.businesslogic.ireport.chart.XYDataset;
import it.businesslogic.ireport.chart.XYSeries;
import it.businesslogic.ireport.chart.XYSeriesDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class XYDatasetPanel
extends JPanel
implements ChartDatasetPanel {
    private XYDataset xyDataset = null;
    private SubDataset subDataset = null;
    private ButtonGroup buttonGroup1;
    private JButton jButtonAdd;
    private JButton jButtonModify;
    private JButton jButtonRemove;
    private JLabel jLabel1;
    private JList jList1;
    private JMenuItem jMenuItemCopy;
    private JMenuItem jMenuItemPaste;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPopupMenu jPopupMenuSeries;
    private JScrollPane jScrollPane1;

    public XYDatasetPanel() {
        this.initComponents();
        this.applyI18n();
        this.jList1.setModel(new DefaultListModel());
    }

    public void setXYDataset(XYDataset xyDataset) {
        this.xyDataset = xyDataset;
        this.jButtonModify.setEnabled(false);
        this.jButtonModify.setEnabled(false);
        DefaultListModel lm = (DefaultListModel)this.jList1.getModel();
        lm.removeAllElements();
        Vector v = xyDataset.getXYSeries();
        for (int i = 0; i < v.size(); ++i) {
            lm.addElement(v.elementAt(i));
        }
    }

    public XYDataset getXYDataset() {
        return this.xyDataset;
    }

    private void updateSeriesType() {
        for (int i = 0; i < this.xyDataset.getXYSeries().size(); ++i) {
            Object series = this.xyDataset.getXYSeries().elementAt(i);
            ((DefaultListModel)this.jList1.getModel()).removeElement(series);
            this.xyDataset.getXYSeries().removeElementAt(i);
            --i;
        }
        this.jList1.updateUI();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPopupMenuSeries = new JPopupMenu();
        this.jMenuItemCopy = new JMenuItem();
        this.jMenuItemPaste = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonRemove = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jMenuItemCopy.setText("Copy series");
        this.jMenuItemCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XYDatasetPanel.this.jMenuItemCopyActionPerformed(evt);
            }
        });
        this.jPopupMenuSeries.add(this.jMenuItemCopy);
        this.jMenuItemPaste.setText("Paste series");
        this.jMenuItemPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XYDatasetPanel.this.jMenuItemPasteActionPerformed(evt);
            }
        });
        this.jPopupMenuSeries.add(this.jMenuItemPaste);
        this.setLayout(new GridBagLayout());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                XYDatasetPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                XYDatasetPanel.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setMinimumSize(new Dimension(100, 0));
        this.jPanel1.setPreferredSize(new Dimension(100, 0));
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XYDatasetPanel.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonModify.setText("Modify");
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XYDatasetPanel.this.jButtonModifyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonModify, gridBagConstraints);
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XYDatasetPanel.this.jButtonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 99;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setText("XY series");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            if (evt.getButton() == 3) {
                this.jMenuItemCopy.setEnabled(this.jList1.getSelectedIndex() >= 0);
                this.jMenuItemPaste.setEnabled(MainFrame.getMainInstance().getChartSeriesClipBoard() != null && MainFrame.getMainInstance().getChartSeriesClipBoard().size() > 0);
                this.jPopupMenuSeries.show(this.jList1, evt.getPoint().x, evt.getPoint().y);
                return;
            }
        }
        if (evt.getClickCount() != 2) return;
        if (evt.getButton() != 1) return;
        this.jButtonModifyActionPerformed(null);
    }

    private void jMenuItemPasteActionPerformed(ActionEvent evt) {
        Vector v = MainFrame.getMainInstance().getChartSeriesClipBoard();
        if (v != null && v.size() > 0) {
            for (int i = 0; i < v.size(); ++i) {
                XYSeries cs = (XYSeries)v.elementAt(i);
                cs = cs.cloneMe();
                this.getXYDataset().getXYSeries().addElement(cs);
                ((DefaultListModel)this.jList1.getModel()).addElement(cs);
            }
            this.jList1.updateUI();
        }
    }

    private void jMenuItemCopyActionPerformed(ActionEvent evt) {
        Object[] values = this.jList1.getSelectedValues();
        Vector<XYSeries> copy_c = new Vector<XYSeries>();
        for (int i = 0; i < values.length; ++i) {
            copy_c.add(((XYSeries)values[i]).cloneMe());
        }
        MainFrame.getMainInstance().setChartSeriesClipBoard(copy_c);
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            XYSeries cs = (XYSeries)this.jList1.getSelectedValue();
            XYSeriesDialog csd = new XYSeriesDialog((Frame)MainFrame.getMainInstance(), true);
            csd.setSeriesExpression(cs.getSeriesExpression());
            csd.setXValueExpression(cs.getXValueExpression());
            csd.setYValueExpression(cs.getYValueExpression());
            csd.setLabelExpression(cs.getLabelExpression());
            csd.setSectionItemHyperlink(cs.getSectionItemHyperlink());
            csd.setSubDataset(this.getSubDataset());
            csd.setVisible(true);
            if (csd.getDialogResult() == 0) {
                cs.setSeriesExpression(csd.getSeriesExpression());
                cs.setXValueExpression(csd.getXValueExpression());
                cs.setYValueExpression(csd.getYValueExpression());
                cs.setLabelExpression(csd.getLabelExpression());
                cs.setSectionItemHyperlink(csd.getSectionItemHyperlink());
                this.jList1.updateUI();
            }
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        XYSeriesDialog csd = new XYSeriesDialog((Frame)MainFrame.getMainInstance(), true);
        csd.setSubDataset(this.getSubDataset());
        csd.setVisible(true);
        if (csd.getDialogResult() == 0) {
            XYSeries cs = new XYSeries();
            cs.setSeriesExpression(csd.getSeriesExpression());
            cs.setXValueExpression(csd.getXValueExpression());
            cs.setYValueExpression(csd.getYValueExpression());
            cs.setLabelExpression(csd.getLabelExpression());
            cs.setSectionItemHyperlink(csd.getSectionItemHyperlink());
            this.xyDataset.getXYSeries().addElement(cs);
            ((DefaultListModel)this.jList1.getModel()).addElement(cs);
            this.jList1.updateUI();
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        while (this.jList1.getSelectedIndex() >= 0) {
            this.xyDataset.getXYSeries().remove(this.jList1.getSelectedValue());
            ((DefaultListModel)this.jList1.getModel()).removeElementAt(this.jList1.getSelectedIndex());
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            this.jButtonModify.setEnabled(true);
            this.jButtonModify.setEnabled(true);
        } else {
            this.jButtonModify.setEnabled(false);
            this.jButtonModify.setEnabled(false);
        }
    }

    public void applyI18n() {
        this.jButtonAdd.setText(I18n.getString("charts.newseries", "Add series"));
        this.jButtonModify.setText(I18n.getString("charts.modifyseries", "Modify series"));
        this.jButtonRemove.setText(I18n.getString("charts.removeseries", "Remove series"));
        this.updateUI();
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
    }
}

