/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.util.Misc;
import java.io.File;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.w3c.dom.Document;

public class JRXMLDataSourceConnection
extends IReportConnection {
    private String name;
    private String filename;
    private String selectExpression;
    private boolean useConnection = false;

    public Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public boolean isJRDataSource() {
        return !this.isUseConnection();
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Filename", Misc.nvl(this.getFilename(), ""));
        map.put("SelectExpression", Misc.nvl(this.getSelectExpression(), ""));
        map.put("UseConnection", Misc.nvl("" + this.isUseConnection(), "false"));
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setFilename((String)map.get("Filename"));
        this.setSelectExpression((String)map.get("SelectExpression"));
        this.setUseConnection(Boolean.valueOf(Misc.nvl(map.get("UseConnection"), "false")));
    }

    public String getDescription() {
        return "JasperReports XML Datasource";
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JRDataSource getJRDataSource() {
        try {
            return new JRXmlDataSource(this.filename, this.getSelectExpression());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getSelectExpression() {
        return this.selectExpression;
    }

    public void setSelectExpression(String selectExpression) {
        this.selectExpression = selectExpression;
    }

    public boolean isUseConnection() {
        return this.useConnection;
    }

    public void setUseConnection(boolean useConnection) {
        this.useConnection = useConnection;
    }

    public Map getSpecialParameters(Map map) throws JRException {
        if (this.isUseConnection()) {
            Document document = JRXmlUtils.parse((File)new File(this.getFilename()));
            map.put("XML_DATA_DOCUMENT", document);
        }
        return map;
    }
}

