/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRSubreportRunResult;
import net.sf.jasperreports.engine.fill.JRSubreportRunnable;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;

public class JRThreadSubreportRunner
extends JRSubreportRunnable
implements JRSubreportRunner {
    private final JRBaseFiller subreportFiller;
    private Thread fillThread;

    public JRThreadSubreportRunner(JRFillSubreport fillSubreport, JRBaseFiller subreportFiller) {
        super(fillSubreport);
        this.subreportFiller = subreportFiller;
    }

    public boolean isFilling() {
        return this.fillThread != null;
    }

    public JRSubreportRunResult start() {
        this.fillThread = new Thread((Runnable)this, this.subreportFiller.getJasperReport().getName() + " subreport filler");
        this.fillThread.start();
        return this.waitResult();
    }

    public JRSubreportRunResult resume() {
        this.subreportFiller.notifyAll();
        return this.waitResult();
    }

    protected JRSubreportRunResult waitResult() {
        try {
            this.subreportFiller.wait();
        }
        catch (InterruptedException e) {
            throw new JRRuntimeException("Error encountered while waiting on the report filling thread.", e);
        }
        return this.runResult();
    }

    public void reset() {
        this.fillThread = null;
    }

    public void cancel() throws JRException {
        this.subreportFiller.notifyAll();
        if (this.isRunning()) {
            try {
                this.subreportFiller.wait();
            }
            catch (InterruptedException e) {
                throw new JRException("Error encountered while waiting on the subreport filling thread.", e);
            }
        }
    }

    public void suspend() throws JRException {
        this.subreportFiller.notifyAll();
        try {
            this.subreportFiller.wait();
        }
        catch (InterruptedException e) {
            throw new JRException("Error encountered while waiting on the subreport filling thread.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        super.run();
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            this.subreportFiller.notifyAll();
        }
    }
}

