/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import nickyb.sqleonardo.Preferences;
import nickyb.sqleonardo._Constants;
import nickyb.sqleonardo._Version;
import nickyb.sqleonardo.api.util.Appearance;
import nickyb.sqleonardo.api.util.Resources;
import nickyb.sqleonardo.api.util.Store;
import nickyb.sqleonardo.mdi.MDIWindow;

public class Application
extends Appearance
implements _Constants,
_Version {
    public static final ClipboardOwner defaultClipboardOwner = new ClipboardOwner(){

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    };
    public static final MDIWindow window = new MDIWindow();
    public static final Store session = new Store();
    public static final Resources resources = new Resources();

    private static void loadIcons() {
        resources.loadIcon("icon.005", "/images/stock_open-16.png");
        resources.loadIcon("icon.007", "/images/stock_preferences-16.png");
        resources.loadIcon("icon.009", "/images/stock_save-16.png");
        resources.loadIcon("icon.010", "/images/stock_save_as-16.png");
        resources.loadIcon("icon.011", "/images/stock_stop-16.png");
        resources.loadIcon("icon.012", "/images/stock_connect-16.png");
        resources.loadIcon("icon.013", "/images/stock_disconnect-16.png");
        resources.loadIcon("icon.051", "/images/stock_data-explorer-16.png");
        resources.loadIcon("icon.050", "/images/stock_data-edit-sql-query-16.png");
        resources.loadIcon("icon.100", "/images/stock_exec-16.png");
        resources.loadIcon("icon.101", "/images/stock_data-sources-hand-16.png");
        resources.loadIcon("icon.102", "/images/stock_data-sources-delete-16.png");
        resources.loadIcon("icon.103", "/images/stock_navigator-database-ranges-16.png");
        resources.loadIcon("icon.104", "/images/stock_data-tables-16.png");
        resources.loadIcon("icon.150", "/images/stock_link-16.png");
        resources.loadIcon("icon.151", "/images/stock_slide-show-16.png");
        resources.loadIcon("icon.110", "/images/stock_run-macro-16.png");
        resources.loadIcon("icon.162", "/images/stock_update-data-16.png");
        resources.loadIcon("icon.161", "/images/stock_delete-row-16.png");
        resources.loadIcon("icon.160", "/images/stock_insert-rows-16.png");
    }

    private static void loadLabels() {
    }

    private static void loadMessages() {
    }

    private static void loadSession() {
        try {
            if (new File(Application.sessionFilename()).exists()) {
                session.load(Application.sessionFilename());
                if (session.canMount("$INFO")) {
                    session.mount("$INFO");
                    Application.println("\tversion: " + session.jump("version").get(0));
                }
            }
            Preferences.loadDefaults();
        }
        catch (Exception e) {
            Application.println(e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        window.dispose();
        try {
            session.mount("$INFO");
            session.home();
            session.jump("version");
            if (session.jump().size() == 0) {
                session.jump().add(Application.getVersion());
            } else {
                session.jump().set(0, Application.getVersion());
            }
            session.save(Application.sessionFilename());
        }
        catch (IOException e) {
            Application.println(e, false);
        }
        finally {
            System.exit(0);
        }
    }

    private static String sessionFilename() {
        return System.getProperty("user.home") + File.separator + ".sqleonardo";
    }

    public static String getVersion() {
        return "2006.10";
    }

    public static String getVersion2() {
        return "SQLeonardo." + Application.getVersion();
    }

    public static String getVersion3() {
        return Application.getVersion2() + " [ " + "http://sqleonardo.altervista.org" + " ]";
    }

    public static void alert(String title, String message) {
        JOptionPane.showMessageDialog(window, message, title, 2);
    }

    public static boolean confirm(String title, String message) {
        return JOptionPane.showConfirmDialog(window, message, title, 0) == 0;
    }

    public static String input(String title, String message) {
        return JOptionPane.showInputDialog(window, message, title, -1);
    }

    public static void println(Exception e, boolean alert) {
        if (alert) {
            String message = e.toString();
            StringBuffer buffer = new StringBuffer();
            while (message.length() > 100) {
                buffer.append(message.substring(0, 100) + "\n");
                message = message.substring(100);
            }
            buffer.append(message);
            Application.alert(e.getClass().getName(), buffer.toString());
        } else {
            System.out.println(e);
        }
    }

    public static void println(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        Application.println("loading resources...");
        Application.loadIcons();
        Application.loadLabels();
        Application.loadMessages();
        Application.println("loading session...");
        Application.loadSession();
        Application.println("loading window...");
        window.show();
    }
}

