/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.cmd;

import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import nickyb.sqleonardo.api.gui.CustomLineBorder;
import nickyb.sqleonardo.ctrl.cmd.BuildBaseEntity;
import nickyb.sqleonardo.ctrl.cmd.BuildBasePane;
import nickyb.sqleonardo.ctrl.cmd.ClauseCondition;
import nickyb.sqleonardo.ctrl.cmd._BuildOwner;
import nickyb.sqleonardo.ctrl.cmd._ClauseOwner;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.SQLFormatter;

public class BuildUpdate
extends BuildBasePane
implements _ClauseOwner {
    private BuildBaseEntity entity;
    private ClauseCondition where;

    public BuildUpdate(_BuildOwner owner) {
        super(owner);
    }

    void initComponents() {
        this.entity = new BuildBaseEntity(this);
        this.entity.setBorder(new CustomLineBorder(true, true, false, false));
        this.where = new ClauseCondition(this);
        this.where.setBorder(new CustomLineBorder(true, true, false, false));
        JScrollPane scroll1 = new JScrollPane(this.entity);
        scroll1.setBorder(new TitledBorder(" set "));
        JScrollPane scroll2 = new JScrollPane(this.where);
        scroll2.setBorder(new TitledBorder(" where "));
        JPanel clauses = new JPanel(new GridLayout(2, 1, 5, 5));
        clauses.add(scroll1);
        clauses.add(scroll2);
        this.setComponentCenter(clauses);
    }

    void add(QueryTokens.Column column) {
        String name = SQLFormatter.ensureQuotes(column.getName(), this.owner.getIdentifierQuoteString(), false);
        this.entity.addField(name);
        this.where.addColumn(name);
    }

    void clear() {
        this.entity.removeRows();
        this.where.removeRows();
    }

    public JComponent getComponent() {
        return this;
    }

    private String getWhere() {
        StringBuffer buffer = new StringBuffer();
        if (this.where != null) {
            String append = null;
            for (int i = 0; i < this.where.getModel().getRowCount() - 1; ++i) {
                Object[] rowdata = new Object[4];
                for (int j = 0; j < 4; ++j) {
                    rowdata[j] = this.where.getModel().getValueAt(i, j + 1);
                }
                QueryTokens.DefaultExpression exprL = new QueryTokens.DefaultExpression(rowdata[0] == null ? null : rowdata[0].toString());
                QueryTokens.DefaultExpression exprR = new QueryTokens.DefaultExpression(rowdata[2] == null ? null : rowdata[2].toString());
                buffer.append(new QueryTokens.Condition(append, exprL, rowdata[1].toString(), exprR));
                append = rowdata[3] != null ? " " + rowdata[3].toString() : null;
            }
        }
        if (buffer.length() > 0) {
            buffer.insert(0, " WHERE ");
        }
        return buffer.toString();
    }

    public String getSyntax() {
        StringBuffer set = new StringBuffer();
        if (this.entity != null && this.where != null) {
            for (int i = 0; i < this.entity.getRowCount(); ++i) {
                if (!this.entity.isCellEditable(i, 2)) continue;
                set.append(this.entity.getValueAt(i, 1).toString() + " = ");
                set.append((this.entity.getValueAt(i, 2) != null ? this.entity.getValueAt(i, 2).toString() : null) + ", ");
            }
            if (set.length() > 0) {
                set.deleteCharAt(set.length() - 2);
            }
            return "UPDATE " + this.owner.getTable() + " SET " + set.toString().trim() + this.getWhere();
        }
        return "UPDATE";
    }
}

