/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import nickyb.sqleonardo.api.util.Appearance;
import nickyb.sqleonardo.ctrl.DataGridControl;
import nickyb.sqleonardo.ctrl.grid.DataGridModel;
import nickyb.sqleonardo.ctrl.grid.LogManager;

public class DataGridView
extends JPanel {
    private JTable data;
    private DataGridModel model;
    private DataGridControl control;

    public DataGridView(DataGridControl control) {
        super(new GridLayout(1, 1));
        this.control = control;
        this.data = new JTable();
        this.model = new DataGridModel();
        this.data.setModel(this.model);
        this.data.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent key) {
                if (key.getKeyCode() == 40) {
                    if (DataGridView.this.data.getSelectedRow() == DataGridView.this.data.getRowCount() - 1 && DataGridView.this.getBlock() < DataGridView.this.getBlockCount()) {
                        int col = DataGridView.this.data.getSelectedColumn();
                        DataGridView.this.control.getSlider().setValue(DataGridView.this.getBlock());
                        DataGridView.this.data.setRowSelectionInterval(0, 0);
                        DataGridView.this.data.scrollRectToVisible(DataGridView.this.data.getCellRect(0, col, true));
                        key.consume();
                    }
                } else if (key.getKeyCode() == 38 && DataGridView.this.data.getSelectedRow() == 0 && DataGridView.this.getBlock() > 1) {
                    int col = DataGridView.this.data.getSelectedColumn();
                    DataGridView.this.control.getSlider().setValue(DataGridView.this.getBlock() - 2);
                    int row = DataGridView.this.data.getRowCount() - 1;
                    DataGridView.this.data.setRowSelectionInterval(row, row);
                    DataGridView.this.data.scrollRectToVisible(DataGridView.this.data.getCellRect(row, col, true));
                    key.consume();
                }
            }
        });
        this.data.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
                super.setOpaque(true);
                if (col == 0) {
                    super.setBackground(UIManager.getDefaults().getColor("TableHeader.background"));
                    super.setFont(DataGridView.this.data.getSelectedRow() == row ? Appearance.fontBOLD : Appearance.fontPLAIN);
                } else {
                    super.setFont(Appearance.fontPLAIN);
                    if (isSelected && !hasFocus) {
                        super.setBackground(DataGridView.this.data.getSelectionBackground());
                    } else {
                        super.setBackground(UIManager.getDefaults().getColor("Table.background"));
                    }
                }
                if (value == null) {
                    super.setText("<null>");
                    if (DataGridView.this.model.isCellChanged(row, col)) {
                        super.setForeground(Color.red);
                    } else {
                        super.setForeground(Color.lightGray);
                    }
                } else if (DataGridView.this.model.isCellChanged(row, col)) {
                    super.setForeground(Color.blue);
                } else {
                    super.setForeground(UIManager.getDefaults().getColor("Table.foreground"));
                }
                return this;
            }
        });
        this.data.setSelectionMode(0);
        this.data.getTableHeader().setReorderingAllowed(false);
        this.data.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                int col = DataGridView.this.data.getColumnModel().getColumnIndexAtX(me.getX());
                if (col < 1) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(me)) {
                    DataGridView.this.control.setCursor(new Cursor(3));
                    DataGridView.this.model.sort(col);
                    DataGridView.this.tableDataChanged();
                    DataGridView.this.control.setCursor(new Cursor(0));
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.data);
        scroll.getViewport().setBackground(Color.white);
        this.add(scroll);
        this.data.setAutoResizeMode(0);
        this.data.getActionMap().put("copy", control.getActionMap().get("copy-cell"));
        this.data.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copy");
    }

    public void addMouseListener(MouseListener l) {
        this.data.addMouseListener(l);
    }

    public void addRow(Object[] rowdata, boolean newrow) {
        this.model.addRow(rowdata, newrow);
    }

    public void addColumn(String text) {
        this.addColumn(text, 1);
    }

    public void addColumn(String text, int type) {
        this.model.addColumn(text, type);
    }

    public void deleteRow(int row) {
        this.model.deleteRow(row);
        this.data.tableChanged(new TableModelEvent(this.model));
    }

    public void insertRow(int row) {
        this.model.insertRow(row);
        this.data.tableChanged(new TableModelEvent(this.model));
    }

    public int getCurrentRow() {
        return this.data.getSelectedRow();
    }

    public int getCurrentColumn() {
        return this.data.getSelectedColumn();
    }

    public void setColumnWidth(String text, int size) {
        TableColumn tableColumn = this.data.getColumn(text);
        tableColumn.setPreferredWidth(size);
        tableColumn.setWidth(size);
    }

    public int getBlockCount() {
        return this.model.getBlockCount();
    }

    public int getBlock() {
        return this.model.getBlock();
    }

    public void setBlock(int idx) {
        this.model.setBlock(idx);
        this.data.tableChanged(new TableModelEvent(this.model));
    }

    public LogManager getLogManager() {
        return this.model.getLogManager();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public String getColumnName(int idx) {
        return this.model.getColumnName(idx);
    }

    public int getColumnType(int idx) {
        return this.model.getColumnType(idx);
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public Object getValueAt(int row, int col) {
        return this.model.getValueAt(row, col);
    }

    public int getFlatRowCount() {
        return this.model.getFlatRowCount();
    }

    public Object[] getFlatValueAt(int row) {
        return this.model.getFlatValueAt(row);
    }

    public void reset() {
        this.model = new DataGridModel();
        this.data.setModel(this.model);
    }

    public void resetCellValue() {
        this.model.resetValueAt(this.data.getSelectedRow(), this.data.getSelectedColumn());
        this.data.editingCanceled(null);
    }

    public void setCellValue(Object value) {
        this.data.setValueAt(value, this.data.getSelectedRow(), this.data.getSelectedColumn());
        this.data.editingCanceled(null);
    }

    public void setSelectedCell(int row, int col) {
        this.data.setRowSelectionInterval(row, row);
        this.data.setColumnSelectionInterval(col, col);
        this.data.scrollRectToVisible(this.data.getCellRect(row, col, true));
    }

    public void tableChanged() {
        this.data.tableChanged(null);
    }

    public void tableDataChanged() {
        this.data.tableChanged(new TableModelEvent(this.model));
        this.control.refreshStatus();
    }
}

