/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.grid;

import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.gui.AbstractDialogModal;
import nickyb.sqleonardo.api.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.api.jdbc.ConnectionHandler;
import nickyb.sqleonardo.api.util.Text;
import nickyb.sqleonardo.ctrl.grid.DataGridModel;
import nickyb.sqleonardo.ctrl.grid.TableMetaData;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.SQLFormatter;

public class LogManager {
    static final Integer DELETE = new Integer(0);
    static final Integer INSERT = new Integer(1);
    static final Integer UPDATE = new Integer(2);
    private DataGridModel owner;
    private Vector store = new Vector();

    LogManager(DataGridModel model) {
        this.owner = model;
    }

    void aborted(Long rid) {
        this.store.removeElement(new LogElement(INSERT, rid));
        this.store.removeElement(new LogElement(UPDATE, rid));
    }

    boolean exists(Integer type, Long rid) {
        return this.store.contains(new LogElement(type, rid));
    }

    public int count() {
        return this.store.size();
    }

    void setDeleted(Long rid) {
        boolean need = !this.store.contains(new LogElement(INSERT, rid));
        this.aborted(rid);
        if (need) {
            this.store.addElement(new LogElement(DELETE, rid));
        }
    }

    void setInserted(Long rid) {
        this.store.addElement(new LogElement(INSERT, rid));
    }

    void setUpdated(Long rid) {
        if (!this.store.contains(new LogElement(INSERT, rid)) && !this.store.contains(new LogElement(UPDATE, rid))) {
            this.store.addElement(new LogElement(UPDATE, rid));
        }
    }

    public void preview(TableMetaData tmd) {
        if (tmd.getPrimaryKeys().size() > 0) {
            new DialogPreview(tmd).show();
        } else {
            Application.alert("SQLeonardo", "no primary keys founded!");
        }
    }

    public void perform(TableMetaData tmd) {
        if (tmd.getPrimaryKeys().size() > 0) {
            new DialogPerform(tmd).show();
        } else {
            Application.alert("SQLeonardo", "no primary keys founded!");
        }
    }

    private ArrayList getSyntaxes(TableMetaData tmd) {
        int i;
        int whereCols = tmd.getPrimaryKeys().size();
        String preparedWhere = new String(" WHERE ");
        ArrayList<String> syntaxes = new ArrayList<String>();
        ArrayList<Integer> whereColsIDX = new ArrayList<Integer>();
        for (i = 0; i < whereCols; ++i) {
            String colName = tmd.getPrimaryKeyProperty(i, 3);
            int idx = this.owner.getColumnIndex(colName) - 1;
            if (idx >= 0) {
                preparedWhere = preparedWhere + colName + " = ? AND ";
                whereColsIDX.add(new Integer(idx));
                continue;
            }
            --whereCols;
        }
        preparedWhere = preparedWhere.substring(0, preparedWhere.length() - 5);
        if (whereCols == 0) {
            return syntaxes;
        }
        for (i = 0; i < this.store.size(); ++i) {
            LogElement elem = (LogElement)this.store.elementAt(i);
            Object[] rowdata = this.owner.getValueAt(elem.rid);
            String sql = null;
            if (elem.type.equals(INSERT)) {
                String columns = new String();
                String values = new String();
                for (int j = 0; j < rowdata.length; ++j) {
                    Object cell = rowdata[j];
                    if (rowdata[j] instanceof Object[]) {
                        cell = ((Object[])rowdata[j])[0];
                    }
                    columns = columns + this.owner.getColumnName(j + 1) + ",";
                    values = values + this.toJdbcValue(cell, j) + ",";
                }
                columns = columns.substring(0, columns.length() - 1);
                values = values.substring(0, values.length() - 1);
                sql = "INSERT INTO " + tmd.getIdentifier() + " (" + columns + ") VALUES (" + values + ")";
            } else {
                int j;
                String where = preparedWhere;
                for (j = 0; j < whereCols; ++j) {
                    int pos = where.indexOf("?");
                    int col = (Integer)whereColsIDX.get(j);
                    Object cell = rowdata[col];
                    if (cell instanceof Object[]) {
                        cell = ((Object[])cell)[1];
                    }
                    where = Text.replaceText(where, this.toJdbcValue(cell, col), pos, 1);
                }
                if (elem.type.equals(DELETE)) {
                    sql = "DELETE FROM " + tmd.getIdentifier() + where;
                } else if (elem.type.equals(UPDATE)) {
                    sql = "UPDATE " + tmd.getIdentifier() + " SET ";
                    for (j = 0; j < rowdata.length; ++j) {
                        if (!(rowdata[j] instanceof Object[])) continue;
                        Object cell = ((Object[])rowdata[j])[0];
                        sql = sql + this.owner.getColumnName(j + 1) + " = " + this.toJdbcValue(cell, j) + ",";
                    }
                    sql = sql.substring(0, sql.length() - 1) + where;
                }
            }
            syntaxes.add(sql.trim());
        }
        return syntaxes;
    }

    private String toJdbcValue(Object value, int col) {
        return SQLFormatter.toJdbcValue(value, this.owner.getColumnType(col + 1));
    }

    private class DialogPreview
    extends AbstractDialogModal {
        private JTextArea syntaxes;
        private TableMetaData tmd;

        DialogPreview(TableMetaData tmd) {
            super((Component)Application.window, "Log changes");
            this.tmd = tmd;
            this.syntaxes = new JTextArea();
            this.getContentPane().add(new JScrollPane(this.syntaxes));
            this.syntaxes.setEditable(false);
        }

        protected void onOpen() {
            Iterator i = LogManager.this.getSyntaxes(this.tmd).iterator();
            while (i.hasNext()) {
                this.syntaxes.append(i.next() + ";\n");
            }
        }
    }

    private class DialogPerform
    extends JDialog
    implements Runnable {
        private TableMetaData tmd;
        private JLabel message;

        DialogPerform(TableMetaData tmd) {
            super(Application.window);
            this.tmd = tmd;
            this.setModal(true);
            this.setSize(275, 55);
            this.setTitle("wait, saving changes...");
            this.setLocationRelativeTo(Application.window);
            this.setDefaultCloseOperation(0);
            this.message = new JLabel("", 0);
            this.getContentPane().add(this.message);
        }

        public void show() {
            new Thread(this).start();
            super.show();
        }

        public void run() {
            int exceptions = 0;
            Iterator i = LogManager.this.getSyntaxes(this.tmd).iterator();
            while (i.hasNext()) {
                String sql = i.next().toString();
                this.message.setText(sql);
                try {
                    ConnectionHandler ch = ConnectionAssistant.getHandler(this.tmd.getHandlerKey());
                    ch.get().createStatement().execute(sql);
                    LogElement elem = (LogElement)LogManager.this.store.elementAt(exceptions);
                    Object[] rowdata = LogManager.this.owner.getValueAt(elem.rid);
                    for (int j = 0; j < rowdata.length; ++j) {
                        Object cell;
                        if (!(rowdata[j] instanceof Object[])) continue;
                        rowdata[j] = cell = ((Object[])rowdata[j])[0];
                    }
                    LogManager.this.store.removeElementAt(exceptions);
                }
                catch (SQLException e) {
                    if (!Application.confirm("SQLeonardo", e.toString() + "\ndo you want to continue?")) break;
                    ++exceptions;
                }
            }
            this.dispose();
        }
    }

    private class LogElement {
        Integer type;
        Long rid;

        LogElement(Integer type, Long rid) {
            this.type = type;
            this.rid = rid;
        }

        public boolean equals(Object o) {
            return this.type.equals(((LogElement)o).type) && this.rid.equals(((LogElement)o).rid);
        }

        public String toString() {
            if (this.type.equals(DELETE)) {
                return "DELETEed :" + this.rid;
            }
            if (this.type.equals(INSERT)) {
                return "INSERTed :" + this.rid;
            }
            if (this.type.equals(UPDATE)) {
                return "UPDATEed :" + this.rid;
            }
            return null;
        }
    }
}

