/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.querybuilder;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import nickyb.sqleonardo.ctrl.querybuilder.BrowserItems;

public class BrowserDnD
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private JTree tree;
    private TreePath pathSource;
    private TreePath pathLine;
    private Rectangle2D line = new Rectangle2D.Float();

    private BrowserDnD(JTree tree) {
        this.tree = tree;
    }

    static void init(JTree tree) {
        BrowserDnD dnd = new BrowserDnD(tree);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(tree, 3, dnd);
        DropTarget dropTarget = new DropTarget(tree, dnd);
        dropTarget.setDefaultActions(3);
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.tree.paintImmediately(this.line.getBounds());
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        TreePath path = this.tree.getClosestPathForLocation(dtde.getLocation().x, dtde.getLocation().y);
        if (this.pathLine != null && this.pathLine.equals(path)) {
            return;
        }
        this.pathLine = path;
        this.tree.paintImmediately(this.line.getBounds());
        Rectangle area = this.tree.getPathBounds(this.pathLine);
        int y = area.y + (int)area.getHeight();
        this.line.setRect(0.0, y, this.tree.getWidth(), 2.0);
        this.tree.getGraphics().setColor(Color.gray);
        this.tree.getGraphics().drawLine(0, y, this.tree.getWidth(), y);
    }

    public void drop(DropTargetDropEvent dtde) {
        BrowserItems.DefaultTreeItem itemAfter;
        boolean performDrop = false;
        TreePath pathAfter = this.tree.getClosestPathForLocation(dtde.getLocation().x, dtde.getLocation().y);
        BrowserItems.DefaultTreeItem itemSource = (BrowserItems.DefaultTreeItem)this.pathSource.getLastPathComponent();
        BrowserItems.DefaultTreeItem itemParent = itemAfter = (BrowserItems.DefaultTreeItem)pathAfter.getLastPathComponent();
        int idxNew = 0;
        if (itemAfter.isNodeSibling(itemSource)) {
            itemParent = (BrowserItems.DefaultTreeItem)itemSource.getParent();
            int idxOld = itemParent.getIndex(itemSource);
            boolean bl = performDrop = idxOld != (idxNew = itemParent.getIndex(itemAfter));
            if (idxOld > idxNew) {
                ++idxNew;
            }
        } else {
            performDrop = itemParent.isNodeChild(itemSource);
        }
        if (performDrop) {
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            model.insertNodeInto(itemSource, itemParent, idxNew);
        }
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Point origin = dge.getDragOrigin();
        TreePath path = this.tree.getPathForLocation(origin.x, origin.y);
        if (path == null || path.getParentPath().getLastPathComponent() instanceof BrowserItems.FromTreeItem || path.getLastPathComponent() instanceof BrowserItems.FromTreeItem || path.getLastPathComponent() instanceof BrowserItems.ClauseTreeItem || path.getLastPathComponent() instanceof BrowserItems.AbstractQueryTreeItem) {
            return;
        }
        Rectangle area = this.tree.getPathBounds(path);
        boolean bExpanded = this.tree.isExpanded(path);
        boolean bLeaf = this.tree.getModel().isLeaf(path.getLastPathComponent());
        JLabel lbl = (JLabel)this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), false, bExpanded, bLeaf, 0, false);
        lbl.setSize((int)area.getWidth(), (int)area.getHeight());
        BufferedImage imgGhost = new BufferedImage((int)area.getWidth(), (int)area.getHeight(), 3);
        Graphics2D g2 = imgGhost.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
        lbl.paint(g2);
        Icon icon = lbl.getIcon();
        int nStartOfText = icon == null ? 0 : icon.getIconWidth() + lbl.getIconTextGap();
        g2.setComposite(AlphaComposite.getInstance(4, 0.5f));
        g2.setPaint(new GradientPaint(nStartOfText, 0.0f, SystemColor.controlShadow, this.tree.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
        g2.fillRect(nStartOfText, 0, this.tree.getWidth(), imgGhost.getHeight());
        g2.dispose();
        this.tree.setSelectionPath(path);
        this.pathSource = path;
        TransferableTreePath transferable = new TransferableTreePath(this.pathSource);
        dge.startDrag(null, imgGhost, new Point(5, 5), transferable, this);
    }

    private static class TransferableTreePath
    implements Transferable {
        public static final DataFlavor TREEPATH_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "TreePath");
        private DataFlavor[] flavors = new DataFlavor[]{TREEPATH_FLAVOR};
        private TreePath path;

        public TransferableTreePath(TreePath path) {
            this.path = path;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return Arrays.asList(this.flavors).contains(flavor);
        }

        public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor.isMimeTypeEqual(TREEPATH_FLAVOR.getMimeType())) {
                return this.path;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

