/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.api.gui;

import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import nickyb.sqleonardo.api.gui.BorderLayoutPanel;

public class TreeView
extends BorderLayoutPanel {
    private JTree tree;

    public TreeView() {
        this("<empty>", false);
    }

    public TreeView(String root, boolean visible) {
        this.tree = new JTree(new DefaultMutableTreeNode(root, true), true);
        this.setComponentCenter(new JScrollPane(this.tree));
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(visible);
    }

    protected JTree getJavaComponent() {
        return this.tree;
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.tree.addTreeSelectionListener(l);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener l) {
        this.tree.addTreeWillExpandListener(l);
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.tree.getModel().getRoot();
    }

    public TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    public void setSelectionPath(TreePath path) {
        this.tree.setSelectionPath(path);
    }

    public DefaultMutableTreeNode getSelectionNode() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }

    public void clearSelection() {
        this.tree.clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.tree.isSelectionEmpty();
    }

    public void setSelectionNode(DefaultMutableTreeNode node) {
        this.tree.setSelectionPath(new TreePath(node.getPath()));
    }

    public void reloadRoot() {
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }

    public void reloadSelection() {
        if (this.tree.isSelectionEmpty()) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent();
        this.reload(node);
    }

    public void reload(DefaultMutableTreeNode node) {
        ((DefaultTreeModel)this.tree.getModel()).reload(node);
    }

    public void removeNode(DefaultMutableTreeNode node) {
        ((DefaultTreeModel)this.tree.getModel()).removeNodeFromParent(node);
    }
}

