/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.gui.BorderLayoutPanel;
import nickyb.sqleonardo.api.jdbc.Task;
import nickyb.sqleonardo.api.jdbc._TaskSource;
import nickyb.sqleonardo.api.jdbc._TaskTarget;
import nickyb.sqleonardo.mdi._OneConnectionListener;

public class CommandEditor
extends BorderLayoutPanel
implements _TaskTarget,
_OneConnectionListener {
    private boolean stopped;
    private Thread queryThread;
    private JTextArea request;
    private JTextArea response;
    private String keycah;

    public CommandEditor() {
        JSplitPane split = new JSplitPane(0);
        this.request = new JTextArea();
        split.setTopComponent(new JScrollPane(this.request));
        this.response = new JTextArea();
        split.setBottomComponent(new JScrollPane(this.response));
        split.setOneTouchExpandable(true);
        this.request.setTabSize(4);
        this.response.setTabSize(4);
        this.response.setEditable(false);
        this.setComponentCenter(split);
        this.request.getActionMap().put("stop-task", new ActionStopTask());
        this.request.getActionMap().put("start-task", new ActionStartTask());
        this.request.getInputMap().put(KeyStroke.getKeyStroke(10, 2), "start-task");
        this.request.getInputMap().put(KeyStroke.getKeyStroke(155, 1), "paste-from-clipboard");
        this.request.getInputMap().put(KeyStroke.getKeyStroke(155, 2), "copy-to-clipboard");
        this.request.getInputMap().put(KeyStroke.getKeyStroke(127, 1), "cut-to-clipboard");
        this.getActionMap().setParent(this.request.getActionMap());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                JSplitPane split = (JSplitPane)CommandEditor.this.getComponent(0);
                split.setDividerLocation(0.5);
                split.validate();
            }
        });
    }

    public void onConnectionActivated(String keycah) {
        this.keycah = keycah;
    }

    public void append(String text) {
        this.request.append(text);
    }

    public void clearResponse() {
        this.response.setText(null);
        this.request.requestFocus();
    }

    public String getSelectedText() {
        return this.request.getSelectedText();
    }

    public Document getDocument() {
        return this.request.getDocument();
    }

    public void setDocument(Document doc) {
        this.request.setDocument(doc);
        this.request.setCaretPosition(0);
        this.request.setTabSize(4);
        this.request.requestFocus();
    }

    public boolean continueRun() {
        return this.queryThread != null;
    }

    public void onTaskFinished() {
        this.response.append("\n");
    }

    public void onTaskStarting() {
    }

    public void message(String text) {
    }

    public void write(String text) {
        this.response.append(text);
        try {
            int line = this.response.getLineCount();
            int off = this.response.getLineStartOffset(line - 1);
            this.response.setCaretPosition(off);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private class TaskSource
    implements _TaskSource {
        private String query;

        private TaskSource(String query) {
            this.query = query;
        }

        public String getHandlerKey() {
            return CommandEditor.this.keycah;
        }

        public String getSyntax() {
            return this.query;
        }
    }

    private class ActionStopTask
    extends AbstractAction {
        ActionStopTask() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.011"));
            this.putValue("ShortDescription", "stop");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ae) {
            this.setEnabled(false);
            CommandEditor.this.queryThread = null;
        }
    }

    private class ActionStartTask
    extends AbstractAction
    implements Runnable {
        ActionStartTask() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.110"));
            this.putValue("ShortDescription", "launch");
        }

        public void actionPerformed(ActionEvent ae) {
            CommandEditor.this.setCursor(new Cursor(3));
            CommandEditor.this.getActionMap().get("stop-task").setEnabled(true);
            this.setEnabled(false);
            CommandEditor.this.stopped = false;
            CommandEditor.this.queryThread = new Thread(this);
            CommandEditor.this.queryThread.start();
        }

        public void run() {
            String requestString = CommandEditor.this.request.getSelectedText();
            if (requestString == null || requestString.trim().length() == 0) {
                try {
                    int line = CommandEditor.this.request.getLineOfOffset(CommandEditor.this.request.getCaretPosition());
                    CommandEditor.this.request.setSelectionStart(CommandEditor.this.request.getLineStartOffset(line));
                    CommandEditor.this.request.setSelectionEnd(CommandEditor.this.request.getLineEndOffset(line));
                    requestString = CommandEditor.this.request.getSelectedText();
                }
                catch (BadLocationException e) {
                    Application.println(e, false);
                }
            }
            if (requestString == null || requestString.trim().length() == 0) {
                CommandEditor.this.request.setSelectionStart(0);
                CommandEditor.this.request.setSelectionEnd(CommandEditor.this.request.getText().length());
                requestString = CommandEditor.this.request.getSelectedText();
            }
            if (requestString != null && requestString.trim().length() > 0) {
                CommandEditor.this.request.requestFocus();
                StringTokenizer st = new StringTokenizer(requestString.trim(), ";");
                while (!CommandEditor.this.stopped && st.hasMoreTokens()) {
                    TaskSource source = new TaskSource(st.nextToken());
                    CommandEditor.this.response.append("\n" + source.getSyntax() + "\n");
                    new Task(source, CommandEditor.this).run();
                }
            }
            this.setEnabled(true);
            CommandEditor.this.getActionMap().get("stop-task").setEnabled(false);
            CommandEditor.this.setCursor(new Cursor(0));
        }
    }
}

