/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl;

import java.awt.CardLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.gui.BorderLayoutPanel;
import nickyb.sqleonardo.api.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.api.util.Classpath;
import nickyb.sqleonardo.api.util.Text;
import nickyb.sqleonardo.ctrl.mde.DialogChooseColumns;
import nickyb.sqleonardo.ctrl.mde.DialogDatasource;
import nickyb.sqleonardo.ctrl.mde.DialogDriver;
import nickyb.sqleonardo.ctrl.mde.SideNavigator;
import nickyb.sqleonardo.ctrl.mde.SideSearchCriteria;
import nickyb.sqleonardo.ctrl.mde.UoDatasource;
import nickyb.sqleonardo.ctrl.mde.UoDriver;
import nickyb.sqleonardo.mdi.ClientMetadataExplorer;

public class MetadataExplorer
extends BorderLayoutPanel
implements ChangeListener,
TreeSelectionListener {
    private CardLayout cardViews;
    private SideNavigator navigator;
    private SideSearchCriteria search;

    public MetadataExplorer() {
        super(2, 2);
        this.getActionMap().put("choose-columns", new ActionChooseColumns());
        this.getActionMap().put("new-driver", new ActionNewDriver());
        this.getActionMap().put("new-datasorce", new ActionNewDatasource());
        this.getActionMap().put("delete", new ActionDelete());
        this.getActionMap().put("properties", new ActionProperties());
        this.initComponents();
        this.loadNavigator();
    }

    private void initComponents() {
        this.navigator = new SideNavigator();
        this.search = new SideSearchCriteria();
        JSplitPane split = new JSplitPane();
        split.setDividerLocation(250);
        split.setOneTouchExpandable(true);
        this.setComponentCenter(split);
        Container container = new Container();
        this.cardViews = new CardLayout();
        container.setLayout(this.cardViews);
        container.add("first", this.navigator.getRightView());
        container.add("last", this.search.getRightView());
        split.setRightComponent(container);
        JTabbedPane tp = new JTabbedPane(3);
        tp.addTab("browse", this.navigator);
        tp.addTab("search", this.search);
        tp.addChangeListener(this);
        split.setLeftComponent(tp);
    }

    private void loadNavigator() {
        Application.session.mount("$JDBC");
        Application.session.home();
        Enumeration eDv = Application.session.jumps();
        while (eDv.hasMoreElements()) {
            UoDriver uoDv = new UoDriver();
            uoDv.name = eDv.nextElement().toString();
            Application.session.jump(uoDv.name);
            Object[] dvInfo = (Object[])Application.session.jump().get(0);
            uoDv.library = dvInfo[0] == null ? "" : dvInfo[0].toString();
            uoDv.classname = dvInfo[1] == null ? "" : dvInfo[1].toString();
            uoDv.example = dvInfo[2] == null ? "" : dvInfo[2].toString();
            this.navigator.add(uoDv);
            try {
                ConnectionAssistant.declare(uoDv.library, uoDv.classname, !Classpath.isRuntime(uoDv.library));
            }
            catch (Exception e) {
                Application.println(e, false);
            }
            Enumeration eDs = Application.session.jumps();
            while (eDs.hasMoreElements()) {
                UoDatasource uoDs = new UoDatasource(uoDv);
                uoDs.name = eDs.nextElement().toString();
                Application.session.home();
                Application.session.jump(uoDv.name);
                Application.session.jump(uoDs.name);
                Object[] dsInfo = (Object[])Application.session.jump().get(0);
                uoDs.url = dsInfo[0] == null ? "" : dsInfo[0].toString();
                String string = uoDs.uid = dsInfo[1] == null ? "" : dsInfo[1].toString();
                uoDs.pwd = dsInfo.length == 3 && (uoDs.remember = dsInfo[2] != null) ? dsInfo[2].toString() : "";
                this.navigator.add(uoDs);
            }
            Application.session.home();
        }
        this.navigator.clearSelection();
        this.navigator.addTreeSelectionListener(this);
    }

    public void unloadNavigator() {
        Application.session.umount("$JDBC");
        Application.session.mount("$JDBC");
        DefaultMutableTreeNode root = this.navigator.getRootNode();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            UoDriver uoDv = (UoDriver)node.getUserObject();
            Application.session.jump(uoDv.name).add(new String[]{uoDv.library, uoDv.classname, uoDv.example});
            for (int j = 0; j < node.getChildCount(); ++j) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(j);
                UoDatasource uoDs = (UoDatasource)child.getUserObject();
                Application.session.home();
                Application.session.jump(uoDv.name);
                Application.session.jump(uoDs.name).add(new String[]{uoDs.url, uoDs.uid, uoDs.remember ? uoDs.pwd : null});
                if (!uoDs.isConnected()) continue;
                try {
                    uoDs.disconnect();
                    continue;
                }
                catch (Exception e) {
                    Application.println(e, false);
                }
            }
            Application.session.home();
        }
    }

    private ClientMetadataExplorer getClient() {
        return (ClientMetadataExplorer)Application.window.getClient("metadata explorer");
    }

    public void setPreferences() {
        this.navigator.setPreferences();
        this.search.setPreferences();
    }

    private void showFirst() {
        this.cardViews.first((Container)((JSplitPane)this.getComponent(0)).getRightComponent());
        if (!this.navigator.isSelectionEmpty()) {
            String path = this.navigator.getSelectionPath().toString();
            this.getClient().setText(Text.replaceText(path, ", ", " > "));
        }
    }

    private void showLast() {
        this.cardViews.last((Container)((JSplitPane)this.getComponent(0)).getRightComponent());
        this.getClient().setText(null);
    }

    public void stateChanged(ChangeEvent ce) {
        JTabbedPane tabs = (JTabbedPane)ce.getSource();
        if (tabs.getSelectedIndex() == 0) {
            this.showFirst();
        } else {
            this.showLast();
        }
    }

    public void valueChanged(TreeSelectionEvent tse) {
        String path = tse.getPath().toString();
        this.getClient().setText(Text.replaceText(path, ", ", " > "));
        this.getActionMap().get("delete").setEnabled(tse.getPath().getPathCount() < 4);
        this.getActionMap().get("properties").setEnabled(tse.getPath().getPathCount() < 4);
        if (this.navigator.isSelectionEmpty()) {
            this.getActionMap().get("choose-columns").setEnabled(false);
        } else {
            this.getActionMap().get("choose-columns").setEnabled(!this.navigator.getSelectionNode().getAllowsChildren());
        }
    }

    private class ActionChooseColumns
    extends AbstractAction {
        private ActionChooseColumns() {
            this.putValue("Name", "choose columns...");
        }

        public void actionPerformed(ActionEvent ae) {
            String dvname = MetadataExplorer.this.navigator.getSelectionNode().getPath()[1].toString();
            new DialogChooseColumns(dvname, "table types").show();
        }
    }

    private class ActionProperties
    extends AbstractAction {
        private ActionProperties() {
            this.putValue("Name", "properties...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (MetadataExplorer.this.navigator.isSelectionEmpty()) {
                return;
            }
            DefaultMutableTreeNode node = MetadataExplorer.this.navigator.getSelectionNode();
            if (node.getUserObject() instanceof UoDriver) {
                DialogDriver dlg = new DialogDriver(MetadataExplorer.this.navigator, true);
                dlg.show();
            } else if (node.getUserObject() instanceof UoDatasource) {
                DialogDatasource dlg = new DialogDatasource(MetadataExplorer.this.navigator, true);
                dlg.show();
            }
        }
    }

    private class ActionDelete
    extends AbstractAction {
        private ActionDelete() {
            this.putValue("Name", "delete");
        }

        public void actionPerformed(ActionEvent ae) {
            MetadataExplorer.this.navigator.remove();
        }
    }

    private class ActionNewDatasource
    extends AbstractAction {
        private ActionNewDatasource() {
            this.putValue("Name", "new datasource...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (MetadataExplorer.this.navigator.isSelectionEmpty()) {
                Application.alert("SQLeonardo", "select one driver!");
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)MetadataExplorer.this.navigator.getSelectionPath().getPathComponent(1);
            MetadataExplorer.this.navigator.setSelectionNode(node);
            DialogDatasource dlg = new DialogDatasource(MetadataExplorer.this.navigator, false);
            dlg.show();
        }
    }

    private class ActionNewDriver
    extends AbstractAction {
        private ActionNewDriver() {
            this.putValue("Name", "new driver...");
        }

        public void actionPerformed(ActionEvent ae) {
            DialogDriver dlg = new DialogDriver(MetadataExplorer.this.navigator, false);
            dlg.show();
        }
    }
}

