/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.cmd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import nickyb.sqleonardo.api.jdbc.ConnectionHandler;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;

public class MaskBrowser
extends JPanel
implements ItemListener {
    private JList objects;
    private JComboBox schemas;
    private JComboBox types;
    private ConnectionHandler ch;

    MaskBrowser() {
        super(new BorderLayout());
        this.initComponents();
    }

    private void initComponents() {
        JPanel pnlNorth = new JPanel(new GridLayout(0, 2));
        this.schemas = new JComboBox();
        pnlNorth.add(this.schemas);
        this.types = new JComboBox();
        pnlNorth.add(this.types);
        this.add((Component)pnlNorth, "North");
        this.objects = new JList();
        this.add((Component)new JScrollPane(this.objects), "Center");
    }

    void setConnection(ConnectionHandler ch) throws SQLException {
        if (this.ch != null) {
            return;
        }
        this.setCursor(new Cursor(3));
        this.ch = ch;
        this.objects.setListData(new Vector());
        this.schemas.removeItemListener(this);
        this.types.removeItemListener(this);
        this.schemas.removeAllItems();
        this.types.removeAllItems();
        this.schemas.setEnabled(false);
        this.types.setEnabled(false);
        if (ch.get() != null) {
            DatabaseMetaData dbmd = ch.get().getMetaData();
            ResultSet rsTypes = dbmd.getTableTypes();
            while (rsTypes.next()) {
                String type = rsTypes.getString(1).trim();
                boolean added = false;
                for (int i = 0; !added && i < this.types.getItemCount(); ++i) {
                    added = type.equals(this.types.getItemAt(i).toString());
                }
                if (added) continue;
                this.types.addItem(type);
            }
            rsTypes.close();
            this.types.addItem("ALL");
            if (((Boolean)ch.getObject("$supportsSchema")).booleanValue()) {
                ResultSet rsSchemas = dbmd.getSchemas();
                while (rsSchemas.next()) {
                    this.schemas.addItem(rsSchemas.getString(1).trim());
                }
                rsSchemas.close();
            }
            this.schemas.setSelectedItem(null);
            this.types.setSelectedItem(null);
        }
        this.schemas.setEnabled(this.schemas.getItemCount() > 0);
        this.types.setEnabled(this.types.getItemCount() > 0);
        this.schemas.addItemListener(this);
        this.types.addItemListener(this);
        this.setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemStateChanged(ItemEvent ie) {
        Object schema = this.schemas.getSelectedItem();
        Object type = this.types.getSelectedItem();
        if (!(type == null || schema == null && this.schemas.isEnabled())) {
            this.setCursor(new Cursor(3));
            Vector<String> vObjects = new Vector<String>();
            String[] tableType = type.toString().equals("ALL") ? null : new String[]{type.toString()};
            try {
                DatabaseMetaData dbmd = this.ch.get().getMetaData();
                String catalog = schema == null ? null : dbmd.getConnection().getCatalog();
                ResultSet rsTables = dbmd.getTables(catalog, schema == null ? null : schema.toString(), "%", tableType);
                if (rsTables != null) {
                    while (rsTables.next()) {
                        vObjects.addElement(rsTables.getString(3).trim());
                    }
                    rsTables.close();
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            finally {
                this.objects.setListData(vObjects);
                this.setCursor(new Cursor(0));
            }
        }
    }

    QueryTokens.Table getSelectedItem() {
        if (this.objects.getSelectedIndex() == -1) {
            return null;
        }
        Object schema = this.schemas.getSelectedItem();
        String table = this.objects.getSelectedValue().toString();
        return new QueryTokens.Table(schema == null ? null : schema.toString(), table);
    }
}

