/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.grid;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.ctrl.grid.AbstractMaskPerform;
import nickyb.sqleonardo.ctrl.grid.DataGridView;

public class MaskImport
extends AbstractMaskPerform {
    private AbstractImport importer;

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (int i = 0; i < this.importer.getComponentCount(); ++i) {
            this.importer.getComponent(i).setEnabled(b);
        }
    }

    void setType(short type, String content, String filename) {
        if (this.importer != null) {
            this.remove(this.importer);
        }
        this.progress.setValue(0);
        this.progress.setMaximum(0);
        if (type == 1) {
            if (!filename.endsWith(".txt")) {
                filename = filename + ".txt";
            }
            this.importer = new TxtImporter();
            this.setComponentCenter(this.importer);
        }
        this.lblFile.setText("file: " + filename);
    }

    void init(DataGridView gbv) {
        super.init(gbv);
        this.progress.setValue(0);
        this.progress.setMaximum(this.importer.open());
    }

    void next() {
        String line = this.importer.nextln();
        Object[] rowdata = new Object[this.gbv.getColumnCount() - 1];
        this.importer.flush(line, rowdata);
        this.gbv.addRow(rowdata, true);
        this.progress.setValue(this.progress.getValue() + line.length() + 1);
    }

    boolean finished() {
        if (this.progress.getValue() == this.progress.getMaximum()) {
            this.importer.close();
            this.gbv.tableDataChanged();
            this.btnStop.setEnabled(false);
            this.lblMsg.setText("ready!");
            return true;
        }
        return false;
    }

    private class TxtImporter
    extends AbstractImport {
        JCheckBox cbxHeader;
        JCheckBox cbxTab;
        JTextField txtDelimiter;

        TxtImporter() {
            super("options");
            GridBagLayout gbl = new GridBagLayout();
            this.setLayout(gbl);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            this.cbxHeader = new JCheckBox("with header");
            gbl.setConstraints(this.cbxHeader, gbc);
            this.add(this.cbxHeader);
            this.cbxTab = new JCheckBox("tab delimited");
            this.cbxTab.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    TxtImporter.this.txtDelimiter.setEditable(!TxtImporter.this.cbxTab.isSelected());
                    TxtImporter.this.txtDelimiter.setEnabled(!TxtImporter.this.cbxTab.isSelected());
                }
            });
            gbl.setConstraints(this.cbxTab, gbc);
            this.add(this.cbxTab);
            gbc.gridwidth = -1;
            gbc.anchor = 18;
            gbc.insets = new Insets(5, 3, 0, 0);
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            JLabel lbl = new JLabel("other delimiter:");
            gbl.setConstraints(lbl, gbc);
            this.add(lbl);
            this.txtDelimiter = new JTextField(";", 5);
            gbl.setConstraints(this.txtDelimiter, gbc);
            this.add(this.txtDelimiter);
        }

        private String getDelimiter() {
            if (this.cbxTab.isSelected()) {
                return "\t";
            }
            return this.txtDelimiter.getText();
        }

        int open() {
            int bytes = super.open();
            if (this.cbxHeader.isSelected()) {
                String line = this.nextln();
                bytes -= line.length() + 1;
            }
            return bytes;
        }

        void flush(String line, Object[] rowdata) {
            Vector<String> vRow = new Vector<String>();
            StringTokenizer st = new StringTokenizer(line, this.getDelimiter());
            while (st.hasMoreTokens()) {
                vRow.addElement(st.nextToken());
            }
            vRow.toArray(rowdata);
        }
    }

    private abstract class AbstractImport
    extends JPanel {
        private FileInputStream stream;

        AbstractImport(String title) {
            this.setBorder(new TitledBorder(title));
        }

        int open() {
            try {
                this.stream = new FileInputStream(MaskImport.this.lblFile.getText().substring(6));
                return this.stream.available();
            }
            catch (FileNotFoundException e) {
                Application.println(e, true);
            }
            catch (IOException e) {
                Application.println(e, true);
            }
            return 0;
        }

        void close() {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                Application.println(e, true);
            }
        }

        abstract void flush(String var1, Object[] var2);

        String nextln() {
            try {
                int nChar;
                String line = new String("");
                while ((nChar = this.stream.read()) != -1 && (char)nChar != '\n') {
                    line = line + (char)nChar;
                }
                return line;
            }
            catch (IOException e) {
                Application.println(e, true);
                return null;
            }
        }
    }
}

