/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.mde;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.Preferences;
import nickyb.sqleonardo.api.gui.ListView;
import nickyb.sqleonardo.api.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.ctrl.cmd.DialogCommand;
import nickyb.sqleonardo.ctrl.grid.AbstractActionShowContent;
import nickyb.sqleonardo.ctrl.grid.TableMetaData;
import nickyb.sqleonardo.ctrl.querybuilder.QueryModel;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.mdi.ClientDefinition;
import nickyb.sqleonardo.mdi.ClientQueryBuilder;

public abstract class AbstractListTaskSource
extends ListView
implements MouseListener {
    private JLabel status;

    protected AbstractListTaskSource() {
        this.addMouseListener(this);
        this.status = new JLabel("...");
        this.setComponentSouth(this.status);
        this.status.setBorder(new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(2, 4, 2, 4)));
    }

    public void addRow(Object[] rowdata) {
        super.addRow(rowdata);
        this.status.setText("objects : " + this.getRowCount());
    }

    public void reset() {
        super.reset();
        if (this.status != null) {
            this.status.setText("objects : 0");
        }
    }

    protected abstract String getHandlerKey();

    protected Connection getConnection() {
        return ConnectionAssistant.getHandler(this.getHandlerKey()).get();
    }

    private int findColumn(String name) {
        for (int i = 0; i < this.getJavaComponent().getColumnModel().getColumnCount(); ++i) {
            if (!this.getJavaComponent().getColumnModel().getColumn(i).getHeaderValue().equals(name)) continue;
            return i;
        }
        return -1;
    }

    protected String getTableSchema() {
        int idx = this.findColumn("TABLE_SCHEM");
        if (idx == -1) {
            return null;
        }
        Object schema = this.getValueAt(this.getSelectedRow(), idx);
        return schema == null ? null : schema.toString();
    }

    protected String getTableName() {
        int idx = this.findColumn("TABLE_NAME");
        if (idx == -1) {
            return null;
        }
        Object name = this.getValueAt(this.getSelectedRow(), idx);
        return name == null ? null : name.toString();
    }

    protected String getTableType() {
        int idx = this.findColumn("TABLE_TYPE");
        if (idx == -1) {
            return null;
        }
        Object type = this.getValueAt(this.getSelectedRow(), idx);
        return type == null ? null : type.toString();
    }

    public void mouseClicked(MouseEvent me) {
        if (me.getClickCount() == 2) {
            if (this.getSelectedRow() == -1 || this.getConnection() == null) {
                return;
            }
            new ActionContent().actionPerformed(null);
        }
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
        if (SwingUtilities.isRightMouseButton(me)) {
            int row = this.getJavaComponent().rowAtPoint(me.getPoint());
            this.getJavaComponent().setRowSelectionInterval(row, row);
            JPopupMenu popup = new JPopupMenu();
            popup.add(new ActionQuery());
            popup.addSeparator();
            popup.add(new ActionCommand());
            popup.addSeparator();
            popup.add(new ActionContent());
            popup.add(new ActionDefinition());
            popup.show(this.getJavaComponent(), me.getX(), me.getY());
        }
    }

    private class ActionCommand
    extends AbstractAction {
        ActionCommand() {
            super("command...");
        }

        public void actionPerformed(ActionEvent e) {
            String schema = AbstractListTaskSource.this.getTableSchema();
            String name = AbstractListTaskSource.this.getTableName();
            new DialogCommand(AbstractListTaskSource.this.getHandlerKey(), new QueryTokens.Table(schema, name)).show();
        }
    }

    private class ActionDefinition
    extends AbstractAction {
        ActionDefinition() {
            super("show definition");
        }

        public void actionPerformed(ActionEvent e) {
            String type = AbstractListTaskSource.this.getTableType();
            String schema = AbstractListTaskSource.this.getTableSchema();
            String name = AbstractListTaskSource.this.getTableName();
            Application.window.add(new ClientDefinition(AbstractListTaskSource.this.getHandlerKey(), new QueryTokens.Table(schema, name), type));
        }
    }

    private class ActionContent
    extends AbstractActionShowContent {
        private ActionContent() {
        }

        protected TableMetaData getTableMetaData() {
            return new TableMetaData(AbstractListTaskSource.this.getHandlerKey(), AbstractListTaskSource.this.getTableSchema(), AbstractListTaskSource.this.getTableName(), AbstractListTaskSource.this.getTableType());
        }
    }

    private class ActionQuery
    extends AbstractAction
    implements Runnable {
        ActionQuery() {
            super("new query");
        }

        public void run() {
            AbstractListTaskSource.this.setCursor(new Cursor(3));
            String schema = AbstractListTaskSource.this.getTableSchema();
            String name = AbstractListTaskSource.this.getTableName();
            QueryModel model = new QueryModel(Preferences.getBoolean("querybuilder.use-schema") ? null : schema);
            QueryTokens.Table table = new QueryTokens.Table(Preferences.getBoolean("querybuilder.use-schema") ? schema : null, name);
            model.getQueryExpression().getQuerySpecification().addFromClause(table);
            ClientQueryBuilder client = new ClientQueryBuilder(AbstractListTaskSource.this.getHandlerKey());
            Application.window.add(client);
            client.setModel(model);
            AbstractListTaskSource.this.setCursor(new Cursor(0));
        }

        public void actionPerformed(ActionEvent e) {
            new Thread(this).start();
        }
    }
}

