/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.querybuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import nickyb.sqleonardo.ctrl.querybuilder.BasePanel;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramEntity;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramField;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramRelation;
import nickyb.sqleonardo.ctrl.querybuilder.QueryBuilder;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;

public class ViewDiagram
extends BasePanel {
    static Color BGCOLOR_DEFAULT = Color.white;
    static Color BGCOLOR_JOINED = new Color(225, 235, 224);
    static Color BGCOLOR_START_JOIN = new Color(255, 230, 230);
    private static int FRAME_OFFSET = 50;
    private Point nextGoodPoint = new Point(10, 10);
    private Point maxCorner = new Point(0, 0);
    private DiagramRelation highlight;
    private DiagramRelation temporany;
    private InternalDiagramManager manager;
    private JScrollPane scroll;
    private JDesktopPane desktop;
    private QueryBuilder builder;

    ViewDiagram(QueryBuilder builder) {
        this.builder = builder;
        this.desktop = new JDesktopPane();
        this.manager = new InternalDiagramManager();
        this.desktop.setDesktopManager(this.manager);
        this.desktop.setDragMode(1);
        this.scroll = new JScrollPane(this.desktop);
        this.scroll.getVerticalScrollBar().setUnitIncrement(25);
        this.setComponentCenter(this.scroll);
    }

    public Component add(Component c) {
        if (c instanceof DiagramEntity) {
            ((DiagramEntity)c).doFlush();
            return this.desktop.add(c);
        }
        if (c instanceof DiagramRelation) {
            this.desktop.add(((DiagramRelation)c).anchor);
            return this.desktop.add(c);
        }
        return super.add(c);
    }

    public void remove(Component c) {
        if (c instanceof DiagramEntity) {
            DiagramEntity entity = (DiagramEntity)c;
            this.desktop.remove(c);
            if (this.temporany != null && entity == this.temporany.primaryEntity) {
                this.temporany = null;
            }
        } else if (c instanceof DiagramRelation) {
            this.desktop.remove(((DiagramRelation)c).anchor);
            this.desktop.remove(c);
        } else {
            super.remove(c);
        }
    }

    void addEntity(DiagramEntity item) {
        if ((double)(item.getWidth() + this.nextGoodPoint.x) > this.getBounds().getWidth()) {
            this.nextGoodPoint.setLocation(10, this.maxCorner.y + FRAME_OFFSET);
        }
        item.setLocation(this.nextGoodPoint);
        item.setVisible(true);
        this.manager.openFrame(item);
    }

    DiagramEntity getEntity(QueryTokens.Table table) {
        return this.getEntity(table, true);
    }

    DiagramEntity getEntity(String schema, String table) {
        QueryTokens.Table token = new QueryTokens.Table(schema, table);
        return this.getEntity(token, false);
    }

    private DiagramEntity getEntity(QueryTokens.Table token, boolean ref) {
        DiagramEntity[] entities = this.getEntities();
        for (int i = 0; i < entities.length; ++i) {
            if (!(ref ? token.getReference().equalsIgnoreCase(entities[i].querytoken.getReference()) : token.getIdentifier().equalsIgnoreCase(entities[i].querytoken.getIdentifier()))) continue;
            return entities[i];
        }
        return null;
    }

    DiagramEntity[] getEntities() {
        JInternalFrame[] internalframes = this.desktop.getAllFramesInLayer(JDesktopPane.PALETTE_LAYER);
        DiagramEntity[] entities = new DiagramEntity[internalframes.length];
        System.arraycopy(internalframes, 0, entities, 0, internalframes.length);
        return entities;
    }

    int getEntityCount() {
        return this.desktop.getAllFramesInLayer(JDesktopPane.PALETTE_LAYER).length;
    }

    void addRelation(DiagramRelation relation) {
        relation.onCreate(this.builder);
        relation.doResize();
        int idx = this.getRelationCount();
        this.desktop.add((Component)relation.anchor, 0);
        this.desktop.add((Component)relation, idx * 2 + 1);
    }

    DiagramRelation getRelation(QueryTokens.Join token) {
        DiagramRelation[] relations = this.getRelations();
        for (int i = 0; i < relations.length; ++i) {
            if (!token.getPrimary().getIdentifier().equalsIgnoreCase(relations[i].querytoken.getPrimary().getIdentifier()) || !token.getForeign().getIdentifier().equalsIgnoreCase(relations[i].querytoken.getForeign().getIdentifier())) continue;
            return relations[i];
        }
        return null;
    }

    DiagramRelation[] getRelations() {
        DiagramRelation[] relations = new DiagramRelation[this.getRelationCount()];
        if (relations.length > 0) {
            int j = 0;
            int count = this.desktop.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component next = this.desktop.getComponent(i);
                if (!(next instanceof DiagramRelation)) continue;
                relations[j++] = (DiagramRelation)next;
            }
        }
        return relations;
    }

    int getRelationCount() {
        return (this.desktop.getComponentCount() - this.getEntityCount()) / 2;
    }

    void removeRelation(DiagramRelation relation) {
        this.desktop.remove(relation.anchor);
        this.desktop.remove(relation);
        this.desktop.repaint();
        relation.onDestroy(this.builder);
    }

    void removeAllRelation(DiagramEntity table) {
        DiagramRelation[] relations = this.getRelations();
        for (int i = 0; i < relations.length; ++i) {
            if (relations[i].primaryEntity != table && relations[i].foreignEntity != table) continue;
            this.removeRelation(relations[i]);
        }
    }

    void setHighlight(DiagramRelation relation) {
        if (this.highlight != null) {
            this.highlight.setHighlight(false);
            if (relation.equals(this.highlight)) {
                this.highlight = null;
                return;
            }
        }
        this.highlight = relation;
        this.highlight.setHighlight(true);
        this.desktop.setPosition(relation.anchor, 0);
        this.desktop.setPosition(relation, this.getRelationCount());
    }

    void join(DiagramEntity eP, DiagramField fP, DiagramEntity eF, DiagramField fF) {
        this.temporany = null;
        this.join(eP, fP);
        this.join(eF, fF);
    }

    void join(DiagramEntity entity, DiagramField field) {
        if (this.temporany == null) {
            this.temporany = new DiagramRelation(this);
            this.temporany.primaryEntity = entity;
            this.temporany.primaryField = field;
            if (this.builder.isJoinMode()) {
                this.temporany.primaryField.setBackground(BGCOLOR_START_JOIN);
            }
        } else if (entity == this.temporany.primaryEntity) {
            this.temporany.primaryField.setBackground(BGCOLOR_DEFAULT);
            if (this.temporany.primaryField.isJoined() && this.builder.isJoinMode()) {
                this.temporany.primaryField.setBackground(BGCOLOR_JOINED);
            }
            if (field != this.temporany.primaryField) {
                this.temporany.primaryField = field;
                if (this.builder.isJoinMode()) {
                    this.temporany.primaryField.setBackground(BGCOLOR_START_JOIN);
                }
            } else {
                this.temporany = null;
            }
        } else {
            this.temporany.foreignEntity = entity;
            this.temporany.foreignField = field;
            QueryTokens.Join join = new QueryTokens.Join(this.temporany.primaryField.querytoken, "=", this.temporany.foreignField.querytoken);
            if (this.getRelation(join) == null) {
                this.temporany.primaryField.joined();
                this.temporany.foreignField.joined();
                if (this.builder.isJoinMode()) {
                    this.temporany.primaryField.setBackground(BGCOLOR_JOINED);
                    this.temporany.foreignField.setBackground(BGCOLOR_JOINED);
                }
                this.addRelation(this.temporany);
                this.temporany = null;
            } else {
                JOptionPane.showMessageDialog(this, "Join already exists: " + join, "add join", 2);
                this.temporany.foreignEntity = null;
                this.temporany.foreignField = null;
            }
        }
    }

    void doArrangeEntities() {
        Dimension full = new Dimension(10, 10);
        Dimension view = this.scroll.getVisibleRect().getSize();
        DiagramEntity[] entities = this.getEntities();
        for (int i = 0; i < entities.length; ++i) {
            Point next = new Point();
            next.x = full.width;
            next.y = full.height;
            if (next.x + entities[i].getWidth() > view.width) {
                next.x = 10;
                next.y = full.height + entities[i].getHeight() + FRAME_OFFSET;
            }
            entities[i].setLocation(next);
            full.width = next.x + entities[i].getWidth() + FRAME_OFFSET;
            full.height = next.y;
        }
        this.doResize();
    }

    void doResize() {
        this.doResizeDesktop();
        this.doResizeRelations();
    }

    void doResizeDesktop() {
        Dimension dimDesk;
        this.maxCorner.setLocation(0, 0);
        this.nextGoodPoint.setLocation(10, 10);
        DiagramEntity[] entities = this.getEntities();
        for (int i = 0; i < entities.length; ++i) {
            Point corner = new Point(entities[i].getX() + entities[i].getWidth(), entities[i].getY() + entities[i].getHeight());
            if (corner.x > this.maxCorner.x) {
                this.maxCorner.x = corner.x;
            }
            if (corner.y > this.maxCorner.y) {
                this.maxCorner.y = corner.y;
            }
            if (entities[i].getY() < this.nextGoodPoint.y) continue;
            this.nextGoodPoint.x = corner.x + FRAME_OFFSET;
            this.nextGoodPoint.y = entities[i].getY();
        }
        Dimension dimView = this.scroll.getVisibleRect().getSize();
        if (this.scroll.getBorder() != null) {
            Insets scrollInsets = this.scroll.getBorder().getBorderInsets(this.scroll);
            dimView.setSize(dimView.getWidth() - (double)scrollInsets.left - (double)scrollInsets.right, dimView.getHeight() - (double)scrollInsets.top - (double)scrollInsets.bottom);
        }
        if ((dimDesk = new Dimension(this.maxCorner.x, this.maxCorner.y)).getWidth() <= dimView.getWidth()) {
            dimDesk.width = (int)dimView.getWidth() - 20;
        }
        if (dimDesk.getHeight() <= dimView.getHeight()) {
            dimDesk.height = (int)dimView.getHeight() - 20;
        }
        this.desktop.setMinimumSize(dimDesk);
        this.desktop.setMaximumSize(dimDesk);
        this.desktop.setPreferredSize(dimDesk);
        this.scroll.validate();
    }

    void doResizeRelations() {
        DiagramRelation[] relations = this.getRelations();
        for (int i = 0; i < relations.length; ++i) {
            relations[i].doResize();
        }
    }

    void onModelChanged() {
        this.highlight = null;
        this.temporany = null;
        this.nextGoodPoint = new Point(10, 10);
        this.maxCorner = new Point(0, 0);
        this.desktop.removeAll();
    }

    void onWorkModeChanged() {
        DiagramEntity[] entities = this.getEntities();
        for (int i = 0; i < entities.length; ++i) {
            entities[i].doFlush();
        }
        this.temporany = null;
    }

    private class InternalDiagramManager
    extends DefaultDesktopManager {
        private InternalDiagramManager() {
        }

        public void closeFrame(JInternalFrame f) {
            DiagramEntity entity = (DiagramEntity)f;
            entity.onDestroy();
            super.closeFrame(f);
            if (ViewDiagram.this.temporany != null && entity == ((ViewDiagram)ViewDiagram.this).temporany.primaryEntity) {
                ViewDiagram.this.temporany = null;
            }
            ViewDiagram.this.doResizeDesktop();
        }

        public void openFrame(JInternalFrame f) {
            ViewDiagram.this.desktop.add(f);
            ViewDiagram.this.doResizeDesktop();
            DiagramEntity entity = (DiagramEntity)f;
            entity.onCreate();
        }

        public void endDraggingFrame(JComponent f) {
            super.endDraggingFrame(f);
            ViewDiagram.this.doResize();
        }
    }
}

