/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.mdi;

import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.Preferences;
import nickyb.sqleonardo.api.gui.AbstractDialogConfirm;
import nickyb.sqleonardo.ctrl.querybuilder.QueryBuilder;

public class DialogPreferences
extends AbstractDialogConfirm {
    private JCheckBox optQbAutoJoin;
    private JCheckBox optQbAutoAlias;
    private JCheckBox optQbUseQuote;
    private JCheckBox optQbUseSchema;

    public DialogPreferences() {
        super((Component)Application.window, "SQLeonardo.preferences");
        JPanel pnlQB = new JPanel(new GridLayout(0, 1));
        pnlQB.setBorder(new EmptyBorder(10, 5, 90, 5));
        this.optQbAutoJoin = new JCheckBox("auto join", Preferences.getBoolean("querybuilder.auto-join", true));
        pnlQB.add(this.optQbAutoJoin);
        this.optQbAutoAlias = new JCheckBox("auto alias", Preferences.getBoolean("querybuilder.auto-alias", true));
        pnlQB.add(this.optQbAutoAlias);
        pnlQB.add(new JSeparator());
        this.optQbUseQuote = new JCheckBox("always quote identifiers", Preferences.getBoolean("querybuilder.use-quote", true));
        pnlQB.add(this.optQbUseQuote);
        this.optQbUseSchema = new JCheckBox("use schema name in syntax definition", Preferences.getBoolean("querybuilder.use-schema", true));
        pnlQB.add(this.optQbUseSchema);
        pnlQB.add(new JSeparator());
        JTabbedPane options = new JTabbedPane();
        options.addTab("query builder", pnlQB);
        this.getContentPane().add(options);
    }

    protected void onOpen() {
        Component[] items = Application.window.menubar.getMenu(3).getMenuComponents();
        for (int i = 0; i < items.length; ++i) {
            String txt;
            if (!(items[i] instanceof JMenuItem) || (txt = ((JMenuItem)items[i]).getText()).indexOf(" - QUERY : ") == -1) continue;
            this.optQbAutoAlias.setEnabled(false);
            this.optQbAutoJoin.setEnabled(false);
            this.optQbUseQuote.setEnabled(false);
            this.optQbUseSchema.setEnabled(false);
            break;
        }
    }

    protected boolean onConfirm() {
        QueryBuilder.autoJoin = this.optQbAutoJoin.isSelected();
        QueryBuilder.autoAlias = this.optQbAutoAlias.isSelected();
        QueryBuilder.useAlwaysQuote = this.optQbUseQuote.isSelected();
        Preferences.set("querybuilder.auto-join", new Boolean(this.optQbAutoJoin.isSelected()));
        Preferences.set("querybuilder.auto-alias", new Boolean(this.optQbAutoAlias.isSelected()));
        Preferences.set("querybuilder.use-quote", new Boolean(this.optQbUseQuote.isSelected()));
        Preferences.set("querybuilder.use-schema", new Boolean(this.optQbUseSchema.isSelected()));
        return true;
    }
}

