/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart.gui;

import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.chart.gui.SerieDialog;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ReportSeriesDialog
extends JDialog {
    private int dialogResult = 0;
    private JReportFrame jReportFrame = null;
    private JButton jButtonClose;
    private JButton jButtonDeleteSerie;
    private JButton jButtonModifySerie;
    private JButton jButtonNewSerie;
    private JList jList1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelData;
    private JScrollPane jScrollPane3;

    public ReportSeriesDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initFrame();
    }

    public void initFrame() {
        DefaultListModel dlm = new DefaultListModel();
        this.jList1.setModel(dlm);
        this.jList1.updateUI();
        this.setSize(500, 400);
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReportSeriesDialog.this.jButtonCloseActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.applyI18n();
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    public ReportSeriesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initFrame();
    }

    public void updateSeriesList() {
        Vector values = new Vector();
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        dlm.removeAllElements();
        if (this.getJReportFrame() == null) {
            this.jList1.updateUI();
            return;
        }
        Enumeration var_enum = this.getJReportFrame().getReport().getVariables().elements();
        while (var_enum.hasMoreElements()) {
            JRVariable var = (JRVariable)var_enum.nextElement();
            if (!var.getName().startsWith("SERIE_")) continue;
            dlm.addElement(var);
        }
        this.jList1.updateUI();
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        this.updateSeriesList();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    private void initComponents() {
        this.jPanelData = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel2 = new JPanel();
        this.jButtonNewSerie = new JButton();
        this.jButtonModifySerie = new JButton();
        this.jButtonDeleteSerie = new JButton();
        this.jPanel3 = new JPanel();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Report Series");
        this.jPanelData.setLayout(new GridBagLayout());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ReportSeriesDialog.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jList1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelData.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(100, 151));
        this.jPanel2.setPreferredSize(new Dimension(140, 100));
        this.jButtonNewSerie.setText("New serie");
        this.jButtonNewSerie.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportSeriesDialog.this.jButtonNewSerieActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonNewSerie, gridBagConstraints);
        this.jButtonModifySerie.setEnabled(false);
        this.jButtonModifySerie.setLabel("Modify serie");
        this.jButtonModifySerie.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportSeriesDialog.this.jButtonModifySerieActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jButtonModifySerie, gridBagConstraints);
        this.jButtonDeleteSerie.setEnabled(false);
        this.jButtonDeleteSerie.setLabel("Remove serie");
        this.jButtonDeleteSerie.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportSeriesDialog.this.jButtonDeleteSerieActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jButtonDeleteSerie, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportSeriesDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanelData.add((Component)this.jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanelData, "Center");
        this.pack();
    }

    private void jButtonDeleteSerieActionPerformed(ActionEvent evt) {
        Object[] vars = this.jList1.getSelectedValues();
        for (int i = 0; i < vars.length; ++i) {
            JRVariable var = (JRVariable)vars[i];
            this.getJReportFrame().getReport().removeVariable(var);
        }
        this.updateSeriesList();
        this.getJReportFrame().getMainFrame().getValuesDialog().getValuesPanel().updateVariables();
    }

    private void jButtonModifySerieActionPerformed(ActionEvent evt) {
        SerieDialog sd = new SerieDialog((Dialog)this, true);
        sd.setJrf(this.getJReportFrame());
        JRVariable var = (JRVariable)this.jList1.getSelectedValue();
        sd.setVariable(var);
        sd.setVisible(true);
        if (sd.getDialogResult() == 0) {
            String var_name = "SERIE_";
            if (!sd.getSerieReset().equals("")) {
                var_name = var_name + "G_" + sd.getSerieReset() + "_";
            }
            var_name = var_name + sd.getSerieName();
            var.setName(var_name);
            var.setResetType("Report");
            var.setCalculation("Nothing");
            var.setClassType(sd.getSerieType());
            var.setExpression(sd.getSerieExpression());
            this.updateSeriesList();
            this.getJReportFrame().getMainFrame().getValuesDialog().getValuesPanel().updateVariables();
        }
    }

    private void jButtonNewSerieActionPerformed(ActionEvent evt) {
        SerieDialog sd = new SerieDialog((Dialog)this, true);
        sd.setJrf(this.getJReportFrame());
        sd.setVisible(true);
        if (sd.getDialogResult() == 0) {
            String var_name = "SERIE_";
            if (!sd.getSerieReset().equals("")) {
                var_name = var_name + "G_" + sd.getSerieReset() + "_";
            }
            var_name = var_name + sd.getSerieName();
            JRVariable var = new JRVariable(var_name, false);
            var.setResetType("Report");
            var.setCalculation("Nothing");
            var.setClassType(sd.getSerieType());
            var.setExpression(sd.getSerieExpression());
            this.getJReportFrame().getReport().addVariable(var);
            this.updateSeriesList();
            this.getJReportFrame().getMainFrame().getValuesDialog().getValuesPanel().updateVariables();
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (this.jList1.getSelectedIndex() >= 0) {
            this.jButtonModifySerie.setEnabled(true);
            this.jButtonDeleteSerie.setEnabled(true);
        } else {
            this.jButtonModifySerie.setEnabled(false);
            this.jButtonDeleteSerie.setEnabled(false);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setDialogResult(0);
        this.setVisible(false);
    }

    public void applyI18n() {
        this.jButtonClose.setText(I18n.getString("reportSeriesDialog.buttonClose", "Close"));
        this.jButtonNewSerie.setText(I18n.getString("reportSeriesDialog.buttonNewSerie", "New serie"));
    }
}

