/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;

public class PasswordDialog
extends JDialog {
    private String password = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JPasswordField jPasswordField;
    private int dialogResult;

    public PasswordDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(320, 144);
        Misc.centerFrame(this);
        this.applyI18n();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PasswordDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPasswordField = new JPasswordField();
        this.getContentPane().setLayout(null);
        this.setTitle("Password");
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PasswordDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Password:");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(4, 4, 250, 14);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PasswordDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonCancel);
        this.jButtonCancel.setBounds(220, 52, 70, 23);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PasswordDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonOK);
        this.jButtonOK.setBounds(138, 52, 70, 23);
        this.getContentPane().add(this.jPasswordField);
        this.jPasswordField.setBounds(4, 20, 286, 24);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.password = this.jPasswordField.getDocument().getText(0, this.jPasswordField.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("passwordDialog.buttonCancel", "Cancel"));
        this.jButtonOK.setText(I18n.getString("passwordDialog.buttonOK", "OK"));
        this.jLabel1.setText(I18n.getString("passwordDialog.label1", "Password:"));
    }
}

