/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.locale;

import it.businesslogic.ireport.gui.locale.TimeZoneWrapper;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public class TimeZoneDialog
extends JDialog {
    private int dialogResult = 2;
    private String reportTimeZoneId = null;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public TimeZoneDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public TimeZoneDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        Object[] tzids = TimeZone.getAvailableIDs();
        Arrays.sort(tzids);
        this.jComboBox1.addItem(I18n.getString("timezone.default", "Default"));
        for (int i = 0; i < tzids.length; ++i) {
            System.out.println("" + (String)tzids[i]);
            TimeZone tz = TimeZone.getTimeZone((String)tzids[i]);
            this.jComboBox1.addItem(new TimeZoneWrapper(tz));
        }
        this.jComboBox1.setSelectedIndex(0);
        Misc.centerFrame(this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TimeZoneDialog.this.jButton2ActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.applyI18n();
        this.getRootPane().setDefaultButton(this.jButton1);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getReportTimeZoneId() {
        return this.reportTimeZoneId;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Time Zone", 0, 0, new Font("Dialog", 0, 11)));
        this.jPanel2.setMinimumSize(new Dimension(350, 80));
        this.jPanel2.setPreferredSize(new Dimension(400, 50));
        this.jComboBox1.setMaximumRowCount(15);
        this.jComboBox1.setMinimumSize(new Dimension(23, 23));
        this.jComboBox1.setPreferredSize(new Dimension(27, 23));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel2.add((Component)this.jComboBox1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeZoneDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeZoneDialog.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.reportTimeZoneId = this.jComboBox1.getSelectedIndex() == 0 ? null : ((TimeZoneWrapper)this.jComboBox1.getSelectedItem()).getTimeZone().getID();
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public void setReportTimeZoneId(String reportTimeZoneId) {
        this.reportTimeZoneId = reportTimeZoneId;
        for (int i = 1; i < this.jComboBox1.getItemCount(); ++i) {
            TimeZoneWrapper tzw = (TimeZoneWrapper)this.jComboBox1.getItemAt(i);
            if (!tzw.getTimeZone().getID().equals(reportTimeZoneId)) continue;
            this.jComboBox1.setSelectedIndex(i);
            return;
        }
        if (this.jComboBox1.getItemCount() > 0) {
            this.jComboBox1.setSelectedIndex(0);
        }
    }

    public void applyI18n() {
        this.jButton1.setText(I18n.getString("timeZoneDialog.button1", "OK"));
        this.jButton2.setText(I18n.getString("timeZoneDialog.button2", "Cancel"));
        ((TitledBorder)this.jPanel1.getBorder()).setTitle(I18n.getString("timeZoneDialog.panelBorder.TimeZone", "Time Zone"));
    }
}

