/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.poi.hssf.model.Model;
import org.apache.poi.hssf.model.WorkbookRecordList;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BackupRecord;
import org.apache.poi.hssf.record.BookBoolRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CodepageRecord;
import org.apache.poi.hssf.record.CountryRecord;
import org.apache.poi.hssf.record.DSFRecord;
import org.apache.poi.hssf.record.DateWindow1904Record;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.ExtSSTRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.ExternSheetRecord;
import org.apache.poi.hssf.record.ExternSheetSubRecord;
import org.apache.poi.hssf.record.FnGroupCountRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.HideObjRecord;
import org.apache.poi.hssf.record.InterfaceEndRecord;
import org.apache.poi.hssf.record.InterfaceHdrRecord;
import org.apache.poi.hssf.record.MMSRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.PaletteRecord;
import org.apache.poi.hssf.record.PasswordRecord;
import org.apache.poi.hssf.record.PasswordRev4Record;
import org.apache.poi.hssf.record.PrecisionRecord;
import org.apache.poi.hssf.record.ProtectRecord;
import org.apache.poi.hssf.record.ProtectionRev4Record;
import org.apache.poi.hssf.record.RecalcIdRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RefreshAllRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StyleRecord;
import org.apache.poi.hssf.record.SupBookRecord;
import org.apache.poi.hssf.record.TabIdRecord;
import org.apache.poi.hssf.record.UseSelFSRecord;
import org.apache.poi.hssf.record.WindowOneRecord;
import org.apache.poi.hssf.record.WindowProtectRecord;
import org.apache.poi.hssf.record.WriteAccessRecord;
import org.apache.poi.hssf.util.SheetReferences;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class Workbook
implements Model {
    private static final int DEBUG = 1;
    private static final short CODEPAGE = 1200;
    protected WorkbookRecordList records = new WorkbookRecordList();
    protected SSTRecord sst = null;
    protected ExternSheetRecord externSheet = null;
    protected ArrayList boundsheets = new ArrayList();
    protected ArrayList formats = new ArrayList();
    protected ArrayList names = new ArrayList();
    protected int numxfs = 0;
    protected int numfonts = 0;
    private short maxformatid = (short)-1;
    private boolean uses1904datewindowing = false;
    private static POILogger log = POILogFactory.getLogger(class$org$apache$poi$hssf$model$Workbook == null ? (class$org$apache$poi$hssf$model$Workbook = Workbook.class$("org.apache.poi.hssf.model.Workbook")) : class$org$apache$poi$hssf$model$Workbook);
    static /* synthetic */ Class class$org$apache$poi$hssf$model$Workbook;

    public static Workbook createWorkbook(List recs) {
        log.log(1, (Object)"Workbook (readfile) created with reclen=", new Integer(recs.size()));
        Workbook retval = new Workbook();
        ArrayList<Record> records = new ArrayList<Record>(recs.size() / 3);
        for (int k = 0; k < recs.size(); ++k) {
            Record rec = (Record)recs.get(k);
            if (rec.getSid() == 10) {
                records.add(rec);
                log.log(1, "found workbook eof record at " + k);
                break;
            }
            switch (rec.getSid()) {
                case 133: {
                    log.log(1, "found boundsheet record at " + k);
                    retval.boundsheets.add(rec);
                    retval.records.setBspos(k);
                    break;
                }
                case 252: {
                    log.log(1, "found sst record at " + k);
                    retval.sst = (SSTRecord)rec;
                    break;
                }
                case 49: {
                    log.log(1, "found font record at " + k);
                    retval.records.setFontpos(k);
                    ++retval.numfonts;
                    break;
                }
                case 224: {
                    log.log(1, "found XF record at " + k);
                    retval.records.setXfpos(k);
                    ++retval.numxfs;
                    break;
                }
                case 317: {
                    log.log(1, "found tabid record at " + k);
                    retval.records.setTabpos(k);
                    break;
                }
                case 18: {
                    log.log(1, "found protect record at " + k);
                    retval.records.setProtpos(k);
                    break;
                }
                case 64: {
                    log.log(1, "found backup record at " + k);
                    retval.records.setBackuppos(k);
                    break;
                }
                case 23: {
                    log.log(1, "found extern sheet record at " + k);
                    retval.externSheet = (ExternSheetRecord)rec;
                    break;
                }
                case 24: {
                    log.log(1, "found name record at " + k);
                    retval.names.add(rec);
                    break;
                }
                case 430: {
                    log.log(1, "found SupBook record at " + k);
                    break;
                }
                case 1054: {
                    log.log(1, "found format record at " + k);
                    retval.formats.add(rec);
                    retval.maxformatid = retval.maxformatid >= ((FormatRecord)rec).getIndexCode() ? retval.maxformatid : ((FormatRecord)rec).getIndexCode();
                    break;
                }
                case 34: {
                    log.log(1, "found datewindow1904 record at " + k);
                    retval.uses1904datewindowing = ((DateWindow1904Record)rec).getWindowing() == 1;
                    break;
                }
                case 146: {
                    log.log(1, "found palette record at " + k);
                    retval.records.setPalettepos(k);
                }
            }
            records.add(rec);
        }
        retval.records.setRecords(records);
        log.log(1, "exit create workbook from existing file function");
        return retval;
    }

    public static Workbook createWorkbook() {
        int k;
        log.log(1, "creating new workbook from scratch");
        Workbook retval = new Workbook();
        ArrayList<Record> records = new ArrayList<Record>(30);
        ArrayList<Record> formats = new ArrayList<Record>(8);
        records.add(retval.createBOF());
        records.add(retval.createInterfaceHdr());
        records.add(retval.createMMS());
        records.add(retval.createInterfaceEnd());
        records.add(retval.createWriteAccess());
        records.add(retval.createCodepage());
        records.add(retval.createDSF());
        records.add(retval.createTabId());
        retval.records.setTabpos(records.size() - 1);
        records.add(retval.createFnGroupCount());
        records.add(retval.createWindowProtect());
        records.add(retval.createProtect());
        retval.records.setProtpos(records.size() - 1);
        records.add(retval.createPassword());
        records.add(retval.createProtectionRev4());
        records.add(retval.createPasswordRev4());
        records.add(retval.createWindowOne());
        records.add(retval.createBackup());
        retval.records.setBackuppos(records.size() - 1);
        records.add(retval.createHideObj());
        records.add(retval.createDateWindow1904());
        records.add(retval.createPrecision());
        records.add(retval.createRefreshAll());
        records.add(retval.createBookBool());
        records.add(retval.createFont());
        records.add(retval.createFont());
        records.add(retval.createFont());
        records.add(retval.createFont());
        retval.records.setFontpos(records.size() - 1);
        retval.numfonts = 4;
        for (int i = 0; i <= 7; ++i) {
            Record rec = retval.createFormat(i);
            retval.maxformatid = retval.maxformatid >= ((FormatRecord)rec).getIndexCode() ? retval.maxformatid : ((FormatRecord)rec).getIndexCode();
            formats.add(rec);
            records.add(rec);
        }
        retval.formats = formats;
        for (k = 0; k < 21; ++k) {
            records.add(retval.createExtendedFormat(k));
            ++retval.numxfs;
        }
        retval.records.setXfpos(records.size() - 1);
        for (k = 0; k < 6; ++k) {
            records.add(retval.createStyle(k));
        }
        records.add(retval.createUseSelFS());
        for (k = 0; k < 1; ++k) {
            BoundSheetRecord bsr = (BoundSheetRecord)retval.createBoundSheet(k);
            records.add(bsr);
            retval.boundsheets.add(bsr);
            retval.records.setBspos(records.size() - 1);
        }
        records.add(retval.createCountry());
        retval.sst = (SSTRecord)retval.createSST();
        records.add(retval.sst);
        records.add(retval.createExtendedSST());
        records.add(retval.createEOF());
        retval.records.setRecords(records);
        log.log(1, "exit create new workbook from scratch");
        return retval;
    }

    public NameRecord getSpecificBuiltinRecord(byte name, int sheetIndex) {
        Iterator iterator = this.names.iterator();
        while (iterator.hasNext()) {
            NameRecord record = (NameRecord)iterator.next();
            if (record.getBuiltInName() != name || record.getIndexToSheet() != sheetIndex) continue;
            return record;
        }
        return null;
    }

    public void removeBuiltinRecord(byte name, int sheetIndex) {
        NameRecord record = this.getSpecificBuiltinRecord(name, sheetIndex);
        if (record != null) {
            this.names.remove(record);
        }
    }

    public int getNumRecords() {
        return this.records.size();
    }

    public FontRecord getFontRecordAt(int idx) {
        int index = idx;
        if (index > 4) {
            --index;
        }
        if (index > this.numfonts - 1) {
            throw new ArrayIndexOutOfBoundsException("There are only " + this.numfonts + " font records, you asked for " + idx);
        }
        FontRecord retval = (FontRecord)this.records.get(this.records.getFontpos() - (this.numfonts - 1) + index);
        return retval;
    }

    public FontRecord createNewFont() {
        FontRecord rec = (FontRecord)this.createFont();
        this.records.add(this.records.getFontpos() + 1, rec);
        this.records.setFontpos(this.records.getFontpos() + 1);
        ++this.numfonts;
        return rec;
    }

    public int getNumberOfFontRecords() {
        return this.numfonts;
    }

    public void setSheetBof(int sheetnum, int pos) {
        log.log(1, (Object)"setting bof for sheetnum =", (Object)new Integer(sheetnum), (Object)" at pos=", new Integer(pos));
        this.checkSheets(sheetnum);
        ((BoundSheetRecord)this.boundsheets.get(sheetnum)).setPositionOfBof(pos);
    }

    public BackupRecord getBackupRecord() {
        return (BackupRecord)this.records.get(this.records.getBackuppos());
    }

    public void setSheetName(int sheetnum, String sheetname) {
        this.setSheetName(sheetnum, sheetname, (short)0);
    }

    public void setSheetName(int sheetnum, String sheetname, short encoding) {
        this.checkSheets(sheetnum);
        BoundSheetRecord sheet = (BoundSheetRecord)this.boundsheets.get(sheetnum);
        sheet.setSheetname(sheetname);
        sheet.setSheetnameLength((byte)sheetname.length());
        sheet.setCompressedUnicodeFlag((byte)encoding);
    }

    public void setSheetOrder(String sheetname, int pos) {
        int sheetNumber = this.getSheetIndex(sheetname);
        this.boundsheets.add(pos, this.boundsheets.remove(sheetNumber));
    }

    public String getSheetName(int sheetnum) {
        return ((BoundSheetRecord)this.boundsheets.get(sheetnum)).getSheetname();
    }

    public int getSheetIndex(String name) {
        int retval = -1;
        for (int k = 0; k < this.boundsheets.size(); ++k) {
            String sheet = this.getSheetName(k);
            if (!sheet.equalsIgnoreCase(name)) continue;
            retval = k;
            break;
        }
        return retval;
    }

    private void checkSheets(int sheetnum) {
        if (this.boundsheets.size() <= sheetnum) {
            if (this.boundsheets.size() + 1 <= sheetnum) {
                throw new RuntimeException("Sheet number out of bounds!");
            }
            BoundSheetRecord bsr = (BoundSheetRecord)this.createBoundSheet(sheetnum);
            this.records.add(this.records.getBspos() + 1, bsr);
            this.records.setBspos(this.records.getBspos() + 1);
            this.boundsheets.add(bsr);
            this.fixTabIdRecord();
        }
    }

    public void removeSheet(int sheetnum) {
        if (this.boundsheets.size() > sheetnum) {
            this.records.remove(this.records.getBspos() - (this.boundsheets.size() - 1) + sheetnum);
            this.boundsheets.remove(sheetnum);
            this.fixTabIdRecord();
        }
    }

    private void fixTabIdRecord() {
        TabIdRecord tir = (TabIdRecord)this.records.get(this.records.getTabpos());
        short[] tia = new short[this.boundsheets.size()];
        for (int k = 0; k < tia.length; k = (int)((short)(k + 1))) {
            tia[k] = k;
        }
        tir.setTabIdArray(tia);
    }

    public int getNumSheets() {
        log.log(1, (Object)"getNumSheets=", new Integer(this.boundsheets.size()));
        return this.boundsheets.size();
    }

    public int getNumExFormats() {
        log.log(1, (Object)"getXF=", new Integer(this.numxfs));
        return this.numxfs;
    }

    public ExtendedFormatRecord getExFormatAt(int index) {
        int xfptr = this.records.getXfpos() - (this.numxfs - 1);
        ExtendedFormatRecord retval = (ExtendedFormatRecord)this.records.get(xfptr += index);
        return retval;
    }

    public ExtendedFormatRecord createCellXF() {
        ExtendedFormatRecord xf = this.createExtendedFormat();
        this.records.add(this.records.getXfpos() + 1, xf);
        this.records.setXfpos(this.records.getXfpos() + 1);
        ++this.numxfs;
        return xf;
    }

    public int addSSTString(String string, boolean use16bits) {
        log.log(1, (Object)"insert to sst string='", (Object)string, (Object)"' and use16bits= ", new Boolean(use16bits));
        if (this.sst == null) {
            this.insertSST();
        }
        return this.sst.addString(string, use16bits);
    }

    public int addSSTString(String string) {
        return this.addSSTString(string, false);
    }

    public String getSSTString(int str) {
        if (this.sst == null) {
            this.insertSST();
        }
        String retval = this.sst.getString(str);
        log.log(1, (Object)"Returning SST for index=", (Object)new Integer(str), (Object)" String= ", retval);
        return retval;
    }

    public void insertSST() {
        log.log(1, "creating new SST via insertSST!");
        this.sst = (SSTRecord)this.createSST();
        this.records.add(this.records.size() - 1, this.createExtendedSST());
        this.records.add(this.records.size() - 2, this.sst);
    }

    public int serialize(int offset, byte[] data) {
        log.log(1, "Serializing Workbook with offsets");
        int pos = 0;
        SSTRecord sst = null;
        int sstPos = 0;
        for (int k = 0; k < this.records.size(); ++k) {
            Record record = this.records.get(k);
            if (record.getSid() == 449 && !((RecalcIdRecord)record).isNeeded()) continue;
            if (record instanceof SSTRecord) {
                sst = (SSTRecord)record;
                sstPos = pos;
            }
            if (record.getSid() == 255 && sst != null) {
                record = sst.createExtSSTRecord(sstPos + offset);
            }
            pos += record.serialize(pos + offset, data);
        }
        log.log(1, "Exiting serialize workbook");
        return pos;
    }

    public int getSize() {
        int retval = 0;
        SSTRecord sst = null;
        for (int k = 0; k < this.records.size(); ++k) {
            Record record = this.records.get(k);
            if (record.getSid() == 449 && !((RecalcIdRecord)record).isNeeded()) continue;
            if (record instanceof SSTRecord) {
                sst = (SSTRecord)record;
            }
            if (record.getSid() == 255 && sst != null) {
                retval += sst.calcExtSSTRecordSize();
                continue;
            }
            retval += record.getRecordSize();
        }
        return retval;
    }

    protected Record createBOF() {
        BOFRecord retval = new BOFRecord();
        retval.setVersion((short)1536);
        retval.setType((short)5);
        retval.setBuild((short)4307);
        retval.setBuildYear((short)1996);
        retval.setHistoryBitMask(65);
        retval.setRequiredVersion(6);
        return retval;
    }

    protected Record createInterfaceHdr() {
        InterfaceHdrRecord retval = new InterfaceHdrRecord();
        retval.setCodepage((short)1200);
        return retval;
    }

    protected Record createMMS() {
        MMSRecord retval = new MMSRecord();
        retval.setAddMenuCount((byte)0);
        retval.setDelMenuCount((byte)0);
        return retval;
    }

    protected Record createInterfaceEnd() {
        return new InterfaceEndRecord();
    }

    protected Record createWriteAccess() {
        WriteAccessRecord retval = new WriteAccessRecord();
        retval.setUsername(System.getProperty("user.name"));
        return retval;
    }

    protected Record createCodepage() {
        CodepageRecord retval = new CodepageRecord();
        retval.setCodepage((short)1200);
        return retval;
    }

    protected Record createDSF() {
        DSFRecord retval = new DSFRecord();
        retval.setDsf((short)0);
        return retval;
    }

    protected Record createTabId() {
        TabIdRecord retval = new TabIdRecord();
        short[] tabidarray = new short[]{0};
        retval.setTabIdArray(tabidarray);
        return retval;
    }

    protected Record createFnGroupCount() {
        FnGroupCountRecord retval = new FnGroupCountRecord();
        retval.setCount((short)14);
        return retval;
    }

    protected Record createWindowProtect() {
        WindowProtectRecord retval = new WindowProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    protected Record createProtect() {
        ProtectRecord retval = new ProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    protected Record createPassword() {
        PasswordRecord retval = new PasswordRecord();
        retval.setPassword((short)0);
        return retval;
    }

    protected Record createProtectionRev4() {
        ProtectionRev4Record retval = new ProtectionRev4Record();
        retval.setProtect(false);
        return retval;
    }

    protected Record createPasswordRev4() {
        PasswordRev4Record retval = new PasswordRev4Record();
        retval.setPassword((short)0);
        return retval;
    }

    protected Record createWindowOne() {
        WindowOneRecord retval = new WindowOneRecord();
        retval.setHorizontalHold((short)360);
        retval.setVerticalHold((short)270);
        retval.setWidth((short)14940);
        retval.setHeight((short)9150);
        retval.setOptions((short)56);
        retval.setSelectedTab((short)0);
        retval.setDisplayedTab((short)0);
        retval.setNumSelectedTabs((short)1);
        retval.setTabWidthRatio((short)600);
        return retval;
    }

    protected Record createBackup() {
        BackupRecord retval = new BackupRecord();
        retval.setBackup((short)0);
        return retval;
    }

    protected Record createHideObj() {
        HideObjRecord retval = new HideObjRecord();
        retval.setHideObj((short)0);
        return retval;
    }

    protected Record createDateWindow1904() {
        DateWindow1904Record retval = new DateWindow1904Record();
        retval.setWindowing((short)0);
        return retval;
    }

    protected Record createPrecision() {
        PrecisionRecord retval = new PrecisionRecord();
        retval.setFullPrecision(true);
        return retval;
    }

    protected Record createRefreshAll() {
        RefreshAllRecord retval = new RefreshAllRecord();
        retval.setRefreshAll(false);
        return retval;
    }

    protected Record createBookBool() {
        BookBoolRecord retval = new BookBoolRecord();
        retval.setSaveLinkValues((short)0);
        return retval;
    }

    protected Record createFont() {
        FontRecord retval = new FontRecord();
        retval.setFontHeight((short)200);
        retval.setAttributes((short)0);
        retval.setColorPaletteIndex((short)Short.MAX_VALUE);
        retval.setBoldWeight((short)400);
        retval.setFontNameLength((byte)5);
        retval.setFontName("Arial");
        return retval;
    }

    protected Record createFormat(int id) {
        FormatRecord retval = new FormatRecord();
        switch (id) {
            case 0: {
                retval.setIndexCode((short)5);
                retval.setFormatStringLength((byte)23);
                retval.setFormatString("\"$\"#,##0_);\\(\"$\"#,##0\\)");
                break;
            }
            case 1: {
                retval.setIndexCode((short)6);
                retval.setFormatStringLength((byte)28);
                retval.setFormatString("\"$\"#,##0_);[Red]\\(\"$\"#,##0\\)");
                break;
            }
            case 2: {
                retval.setIndexCode((short)7);
                retval.setFormatStringLength((byte)29);
                retval.setFormatString("\"$\"#,##0.00_);\\(\"$\"#,##0.00\\)");
                break;
            }
            case 3: {
                retval.setIndexCode((short)8);
                retval.setFormatStringLength((byte)34);
                retval.setFormatString("\"$\"#,##0.00_);[Red]\\(\"$\"#,##0.00\\)");
                break;
            }
            case 4: {
                retval.setIndexCode((short)42);
                retval.setFormatStringLength((byte)50);
                retval.setFormatString("_(\"$\"* #,##0_);_(\"$\"* \\(#,##0\\);_(\"$\"* \"-\"_);_(@_)");
                break;
            }
            case 5: {
                retval.setIndexCode((short)41);
                retval.setFormatStringLength((byte)41);
                retval.setFormatString("_(* #,##0_);_(* \\(#,##0\\);_(* \"-\"_);_(@_)");
                break;
            }
            case 6: {
                retval.setIndexCode((short)44);
                retval.setFormatStringLength((byte)58);
                retval.setFormatString("_(\"$\"* #,##0.00_);_(\"$\"* \\(#,##0.00\\);_(\"$\"* \"-\"??_);_(@_)");
                break;
            }
            case 7: {
                retval.setIndexCode((short)43);
                retval.setFormatStringLength((byte)49);
                retval.setFormatString("_(* #,##0.00_);_(* \\(#,##0.00\\);_(* \"-\"??_);_(@_)");
            }
        }
        return retval;
    }

    protected Record createExtendedFormat(int id) {
        ExtendedFormatRecord retval = new ExtendedFormatRecord();
        switch (id) {
            case 0: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)0);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 1: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 2: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 3: {
                retval.setFontIndex((short)2);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 4: {
                retval.setFontIndex((short)2);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 5: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 6: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 7: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 8: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 9: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 10: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 11: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 12: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 13: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 14: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 15: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)1);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)0);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 16: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)43);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-2048);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 17: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)41);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-2048);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 18: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)44);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-2048);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 19: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)42);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-2048);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 20: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)9);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-2048);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 21: {
                retval.setFontIndex((short)5);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)1);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)2048);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 22: {
                retval.setFontIndex((short)6);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)1);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)23552);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 23: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)49);
                retval.setCellOptions((short)1);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)23552);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 24: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)8);
                retval.setCellOptions((short)1);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)23552);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 25: {
                retval.setFontIndex((short)6);
                retval.setFormatIndex((short)8);
                retval.setCellOptions((short)1);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)23552);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
            }
        }
        return retval;
    }

    protected ExtendedFormatRecord createExtendedFormat() {
        ExtendedFormatRecord retval = new ExtendedFormatRecord();
        retval.setFontIndex((short)0);
        retval.setFormatIndex((short)0);
        retval.setCellOptions((short)1);
        retval.setAlignmentOptions((short)32);
        retval.setIndentionOptions((short)0);
        retval.setBorderOptions((short)0);
        retval.setPaletteOptions((short)0);
        retval.setAdtlPaletteOptions((short)0);
        retval.setFillPaletteOptions((short)8384);
        retval.setTopBorderPaletteIdx((short)8);
        retval.setBottomBorderPaletteIdx((short)8);
        retval.setLeftBorderPaletteIdx((short)8);
        retval.setRightBorderPaletteIdx((short)8);
        return retval;
    }

    protected Record createStyle(int id) {
        StyleRecord retval = new StyleRecord();
        switch (id) {
            case 0: {
                retval.setIndex((short)-32752);
                retval.setBuiltin((byte)3);
                retval.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 1: {
                retval.setIndex((short)-32751);
                retval.setBuiltin((byte)6);
                retval.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 2: {
                retval.setIndex((short)-32750);
                retval.setBuiltin((byte)4);
                retval.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 3: {
                retval.setIndex((short)-32749);
                retval.setBuiltin((byte)7);
                retval.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 4: {
                retval.setIndex((short)Short.MIN_VALUE);
                retval.setBuiltin((byte)0);
                retval.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 5: {
                retval.setIndex((short)-32748);
                retval.setBuiltin((byte)5);
                retval.setOutlineStyleLevel((byte)-1);
            }
        }
        return retval;
    }

    protected PaletteRecord createPalette() {
        return new PaletteRecord(146);
    }

    protected Record createUseSelFS() {
        UseSelFSRecord retval = new UseSelFSRecord();
        retval.setFlag((short)0);
        return retval;
    }

    protected Record createBoundSheet(int id) {
        BoundSheetRecord retval = new BoundSheetRecord();
        switch (id) {
            case 0: {
                retval.setPositionOfBof(0);
                retval.setOptionFlags((short)0);
                retval.setSheetnameLength((byte)6);
                retval.setCompressedUnicodeFlag((byte)0);
                retval.setSheetname("Sheet1");
                break;
            }
            case 1: {
                retval.setPositionOfBof(0);
                retval.setOptionFlags((short)0);
                retval.setSheetnameLength((byte)6);
                retval.setCompressedUnicodeFlag((byte)0);
                retval.setSheetname("Sheet2");
                break;
            }
            case 2: {
                retval.setPositionOfBof(0);
                retval.setOptionFlags((short)0);
                retval.setSheetnameLength((byte)6);
                retval.setCompressedUnicodeFlag((byte)0);
                retval.setSheetname("Sheet3");
            }
        }
        return retval;
    }

    protected Record createCountry() {
        CountryRecord retval = new CountryRecord();
        retval.setDefaultCountry((short)1);
        if (Locale.getDefault().toString().equals("ru_RU")) {
            retval.setCurrentCountry((short)7);
        } else {
            retval.setCurrentCountry((short)1);
        }
        return retval;
    }

    protected Record createSST() {
        return new SSTRecord();
    }

    protected Record createExtendedSST() {
        ExtSSTRecord retval = new ExtSSTRecord();
        retval.setNumStringsPerBucket((short)8);
        return retval;
    }

    protected Record createEOF() {
        return new EOFRecord();
    }

    public SheetReferences getSheetReferences() {
        SheetReferences refs = new SheetReferences();
        if (this.externSheet != null) {
            for (int k = 0; k < this.externSheet.getNumOfREFStructures(); ++k) {
                String sheetName = this.findSheetNameFromExternSheet((short)k);
                refs.addSheetReference(sheetName, k);
            }
        }
        return refs;
    }

    public String findSheetNameFromExternSheet(short num) {
        String result = "";
        short indexToSheet = this.externSheet.getREFRecordAt(num).getIndexToFirstSupBook();
        if (indexToSheet > -1) {
            result = this.getSheetName(indexToSheet);
        }
        return result;
    }

    public int getSheetIndexFromExternSheetIndex(int externSheetNumber) {
        if (externSheetNumber >= this.externSheet.getNumOfREFStructures()) {
            return -1;
        }
        return this.externSheet.getREFRecordAt(externSheetNumber).getIndexToFirstSupBook();
    }

    public short checkExternSheet(int sheetNumber) {
        int i = 0;
        boolean flag = false;
        short result = 0;
        if (this.externSheet == null) {
            this.externSheet = this.createExternSheet();
        }
        while (i < this.externSheet.getNumOfREFStructures() && !flag) {
            ExternSheetSubRecord record = this.externSheet.getREFRecordAt(i);
            if (record.getIndexToFirstSupBook() == sheetNumber && record.getIndexToLastSupBook() == sheetNumber) {
                flag = true;
                result = (short)i;
            }
            ++i;
        }
        if (!flag) {
            result = this.addSheetIndexToExternSheet((short)sheetNumber);
        }
        return result;
    }

    private short addSheetIndexToExternSheet(short sheetNumber) {
        ExternSheetSubRecord record = new ExternSheetSubRecord();
        record.setIndexToFirstSupBook(sheetNumber);
        record.setIndexToLastSupBook(sheetNumber);
        this.externSheet.addREFRecord(record);
        this.externSheet.setNumOfREFStructures((short)(this.externSheet.getNumOfREFStructures() + 1));
        short result = (short)(this.externSheet.getNumOfREFStructures() - 1);
        return result;
    }

    public int getNumNames() {
        int result = this.names.size();
        return result;
    }

    public NameRecord getNameRecord(int index) {
        NameRecord result = (NameRecord)this.names.get(index);
        return result;
    }

    public NameRecord createName() {
        NameRecord name = new NameRecord();
        int idx = this.findFirstRecordLocBySid((short)23);
        if (idx == -1) {
            idx = this.findFirstRecordLocBySid((short)430);
        }
        if (idx == -1) {
            idx = this.findFirstRecordLocBySid((short)140);
        }
        this.records.add(idx + this.names.size() + 1, name);
        this.names.add(name);
        return name;
    }

    public NameRecord addName(NameRecord name) {
        int idx = this.findFirstRecordLocBySid((short)23);
        if (idx == -1) {
            idx = this.findFirstRecordLocBySid((short)430);
        }
        if (idx == -1) {
            idx = this.findFirstRecordLocBySid((short)140);
        }
        this.records.add(idx + this.names.size() + 1, name);
        this.names.add(name);
        return name;
    }

    public NameRecord createBuiltInName(byte builtInName, int index) {
        if (index == -1 || index + 1 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Index is not valid [" + index + "]");
        }
        NameRecord name = new NameRecord(builtInName, (short)index);
        this.addName(name);
        return name;
    }

    public void removeName(int namenum) {
        if (this.names.size() > namenum) {
            int idx = this.findFirstRecordLocBySid((short)24);
            this.records.remove(idx + namenum);
            this.names.remove(namenum);
        }
    }

    protected ExternSheetRecord createExternSheet() {
        ExternSheetRecord externSheet = new ExternSheetRecord();
        int idx = this.findFirstRecordLocBySid((short)140);
        this.records.add(idx + 1, externSheet);
        SupBookRecord supbook = new SupBookRecord();
        supbook.setNumberOfSheets((short)this.getNumSheets());
        this.records.add(idx + 1, supbook);
        return externSheet;
    }

    public short getFormat(String format, boolean createIfNotFound) {
        Iterator iterator = this.formats.iterator();
        while (iterator.hasNext()) {
            FormatRecord r = (FormatRecord)iterator.next();
            if (!r.getFormatString().equals(format)) continue;
            return r.getIndexCode();
        }
        if (createIfNotFound) {
            return this.createFormat(format);
        }
        return -1;
    }

    public ArrayList getFormats() {
        return this.formats;
    }

    public short createFormat(String format) {
        FormatRecord rec = new FormatRecord();
        this.maxformatid = (short)(this.maxformatid >= 164 ? (int)(this.maxformatid + 1) : 164);
        rec.setIndexCode(this.maxformatid);
        rec.setFormatStringLength((byte)format.length());
        rec.setFormatString(format);
        for (int pos = 0; pos < this.records.size() && this.records.get(pos).getSid() != 1054; ++pos) {
        }
        this.formats.add(rec);
        this.records.add(pos += this.formats.size(), rec);
        return this.maxformatid;
    }

    public Record findFirstRecordBySid(short sid) {
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() != sid) continue;
            return record;
        }
        return null;
    }

    public int findFirstRecordLocBySid(short sid) {
        int index = 0;
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() == sid) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Record findNextRecordBySid(short sid, int pos) {
        int matches = 0;
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() != sid || matches++ != pos) continue;
            return record;
        }
        return null;
    }

    public List getRecords() {
        return this.records.getRecords();
    }

    public boolean isUsing1904DateWindowing() {
        return this.uses1904datewindowing;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PaletteRecord getCustomPalette() {
        int palettePos = this.records.getPalettepos();
        if (palettePos != -1) {
            Record rec = this.records.get(palettePos);
            if (!(rec instanceof PaletteRecord)) throw new RuntimeException("InternalError: Expected PaletteRecord but got a '" + rec + "'");
            return (PaletteRecord)rec;
        }
        PaletteRecord palette = this.createPalette();
        this.records.add(1, palette);
        this.records.setPalettepos(1);
        return palette;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

