/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;

public class ExpCacheDescriptor {
    private final Exp exp;
    private int[] dependentDimensionOrdinals;

    public ExpCacheDescriptor(Exp exp, Evaluator evaluator) {
        int i;
        this.exp = exp;
        ArrayList<Integer> ordinalList = new ArrayList<Integer>();
        Member[] members = evaluator.getMembers();
        for (i = 0; i < members.length; ++i) {
            Dimension dimension = members[i].getDimension();
            if (!exp.dependsOn(dimension)) continue;
            ordinalList.add(new Integer(i));
        }
        this.dependentDimensionOrdinals = new int[ordinalList.size()];
        for (i = 0; i < this.dependentDimensionOrdinals.length; ++i) {
            this.dependentDimensionOrdinals[i] = (Integer)ordinalList.get(i);
        }
    }

    public Exp getExp() {
        return this.exp;
    }

    public int[] getDependentDimensionOrdinals() {
        return this.dependentDimensionOrdinals;
    }
}

