/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.transform.TransformerException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.util.JRDateLocaleConverter;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.apache.commons.beanutils.locale.LocaleConvertUtilsBean;
import org.apache.commons.beanutils.locale.LocaleConverter;
import org.apache.xpath.CachedXPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JRXmlDataSource
implements JRRewindableDataSource {
    private Document document;
    private String selectExpression;
    private NodeList nodeList;
    private int nodeListLength;
    private Node currentNode;
    private int currentNodeIndex = -1;
    private CachedXPathAPI xpathAPI = new CachedXPathAPI();
    private LocaleConvertUtilsBean convertBean = null;
    private Locale locale = null;
    private String datePattern = null;
    private String numberPattern = null;
    private TimeZone timeZone = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;

    public JRXmlDataSource(Document document) throws JRException {
        this(document, ".");
    }

    public JRXmlDataSource(Document document, String selectExpression) throws JRException {
        this.document = document;
        this.selectExpression = selectExpression;
        this.moveFirst();
    }

    public JRXmlDataSource(InputStream in) throws JRException {
        this(in, ".");
    }

    public JRXmlDataSource(InputStream in, String selectExpression) throws JRException {
        this(JRXmlUtils.parse(new InputSource(in)), selectExpression);
    }

    public JRXmlDataSource(String uri) throws JRException {
        this(uri, ".");
    }

    public JRXmlDataSource(String uri, String selectExpression) throws JRException {
        this(JRXmlUtils.parse(uri), selectExpression);
    }

    public JRXmlDataSource(File file) throws JRException {
        this(file, ".");
    }

    public JRXmlDataSource(File file, String selectExpression) throws JRException {
        this(JRXmlUtils.parse(file), selectExpression);
    }

    public void moveFirst() throws JRException {
        if (this.document == null) {
            throw new JRException("document cannot be null");
        }
        if (this.selectExpression == null) {
            throw new JRException("selectExpression cannot be null");
        }
        try {
            this.currentNode = null;
            this.currentNodeIndex = -1;
            this.nodeListLength = 0;
            this.nodeList = this.xpathAPI.selectNodeList((Node)this.document, this.selectExpression);
            this.nodeListLength = this.nodeList.getLength();
        }
        catch (TransformerException e) {
            throw new JRException("XPath selection failed. Expression: " + this.selectExpression, e);
        }
    }

    public boolean next() {
        if (this.currentNodeIndex == this.nodeListLength - 1) {
            return false;
        }
        this.currentNode = this.nodeList.item(++this.currentNodeIndex);
        return true;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Class valueClass;
        if (this.currentNode == null) {
            return null;
        }
        String expression = jrField.getDescription();
        if (expression == null || expression.length() == 0) {
            return null;
        }
        Object value = null;
        if ((class$java$lang$Object == null ? (class$java$lang$Object = JRXmlDataSource.class$("java.lang.Object")) : class$java$lang$Object) != (valueClass = jrField.getValueClass())) {
            String text = null;
            try {
                XObject list = this.xpathAPI.eval(this.currentNode, expression);
                if (list.getType() == 4) {
                    Node node = list.nodeset().nextNode();
                    if (node != null) {
                        text = this.getText(node);
                    }
                } else {
                    text = list.str();
                }
            }
            catch (TransformerException e) {
                throw new JRException("XPath selection failed. Expression: " + expression, e);
            }
            if (text != null) {
                if ((class$java$lang$String == null ? (class$java$lang$String = JRXmlDataSource.class$("java.lang.String")) : class$java$lang$String).equals(valueClass)) {
                    value = text;
                } else if ((class$java$lang$Number == null ? (class$java$lang$Number = JRXmlDataSource.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(valueClass)) {
                    value = this.getConvertBean().convert(text.trim(), valueClass, this.locale, this.numberPattern);
                } else if ((class$java$util$Date == null ? (class$java$util$Date = JRXmlDataSource.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(valueClass)) {
                    value = this.getConvertBean().convert(text.trim(), valueClass, this.locale, this.datePattern);
                }
            }
        }
        return value;
    }

    public JRXmlDataSource subDataSource(String selectExpr) throws JRException {
        Document doc = this.subDocument();
        JRXmlDataSource subDataSource = new JRXmlDataSource(doc, selectExpr);
        subDataSource.setLocale(this.locale);
        subDataSource.setDatePattern(this.datePattern);
        subDataSource.setNumberPattern(this.numberPattern);
        subDataSource.setTimeZone(this.timeZone);
        return subDataSource;
    }

    public JRXmlDataSource subDataSource() throws JRException {
        return this.subDataSource(".");
    }

    public Document subDocument() throws JRException {
        if (this.currentNode == null) {
            throw new JRException("No node available. Iterate or rewind the data source.");
        }
        Document doc = JRXmlUtils.createDocument(this.currentNode);
        return doc;
    }

    public JRXmlDataSource dataSource(String selectExpr) throws JRException {
        JRXmlDataSource subDataSource = new JRXmlDataSource(this.document, selectExpr);
        subDataSource.setLocale(this.locale);
        subDataSource.setDatePattern(this.datePattern);
        subDataSource.setNumberPattern(this.numberPattern);
        subDataSource.setTimeZone(this.timeZone);
        return subDataSource;
    }

    public JRXmlDataSource dataSource() throws JRException {
        return this.dataSource(".");
    }

    public String getText(Node node) {
        if (!node.hasChildNodes()) {
            return node.getNodeValue();
        }
        StringBuffer result = new StringBuffer();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String value;
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() == 4) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() != 5 || (value = this.getText(subnode)) == null) continue;
            result.append(value);
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        JRXmlDataSource ds = new JRXmlDataSource(new FileInputStream("northwind.xml"), "/Northwind/Customers");
        JRDesignField field = new JRDesignField();
        field.setDescription("CustomerID");
        field.setValueClass(class$java$lang$String == null ? (class$java$lang$String = JRXmlDataSource.class$("java.lang.String")) : class$java$lang$String);
        ds.next();
        String v = (String)ds.getFieldValue(field);
        System.out.println(field.getDescription() + "=" + v);
        JRXmlDataSource subDs = ds.dataSource("/Northwind/Orders");
        JRDesignField field1 = new JRDesignField();
        field1.setDescription("OrderID");
        field1.setValueClass(class$java$lang$String == null ? (class$java$lang$String = JRXmlDataSource.class$("java.lang.String")) : class$java$lang$String);
        subDs.next();
        String v1 = (String)subDs.getFieldValue(field1);
        System.out.println(field1.getDescription() + "=" + v1);
    }

    protected LocaleConvertUtilsBean getConvertBean() {
        if (this.convertBean == null) {
            this.convertBean = new LocaleConvertUtilsBean();
            if (this.locale != null) {
                this.convertBean.setDefaultLocale(this.locale);
                this.convertBean.deregister();
            }
            this.convertBean.register((LocaleConverter)new JRDateLocaleConverter(this.timeZone), class$java$util$Date == null ? (class$java$util$Date = JRXmlDataSource.class$("java.util.Date")) : class$java$util$Date, this.locale);
        }
        return this.convertBean;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.convertBean = null;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
        this.convertBean = null;
    }

    public String getNumberPattern() {
        return this.numberPattern;
    }

    public void setNumberPattern(String numberPattern) {
        this.numberPattern = numberPattern;
        this.convertBean = null;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.convertBean = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

