/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.SubDataset;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.util.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class JRFieldDialog
extends JDialog {
    JRField tmpField = null;
    private SubDataset subDataset = null;
    private String originalName = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaDescription;
    private JTextField jTextFieldName;
    private int dialogResult;

    public JRFieldDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        this.setClassTypes();
        this.jComboBoxType.setSelectedItem("java.lang.String");
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRFieldDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void setClassTypes() {
        this.jComboBoxType.addItem("java.lang.String");
        this.jComboBoxType.addItem("java.lang.Object");
        this.jComboBoxType.addItem("java.lang.Boolean");
        this.jComboBoxType.addItem("java.lang.Byte");
        this.jComboBoxType.addItem("java.util.Date");
        this.jComboBoxType.addItem("java.sql.Timestamp");
        this.jComboBoxType.addItem("java.sql.Time");
        this.jComboBoxType.addItem("java.lang.Double");
        this.jComboBoxType.addItem("java.lang.Float");
        this.jComboBoxType.addItem("java.lang.Integer");
        this.jComboBoxType.addItem("java.io.InputStream");
        this.jComboBoxType.addItem("java.lang.Long");
        this.jComboBoxType.addItem("java.lang.Short");
        this.jComboBoxType.addItem("java.math.BigDecimal");
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxType = new JComboBox();
        this.jLabel4 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescription = new JTextArea();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify field");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRFieldDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Field name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel2.setText("Field class type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jComboBoxType.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jComboBoxType, gridBagConstraints);
        this.jLabel4.setText("Field description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setText("OK");
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFieldDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRFieldDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 80));
        this.jScrollPane1.setViewportView(this.jTextAreaDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.jRFieldDialog.notValidFieldName", "Please insert a valid field name!"), I18n.getString("messages.jRFieldDialog.notValidFieldNameCaption", "Invalid field!"), 2);
            return;
        }
        if (this.getSubDataset() != null) {
            String newName = this.jTextFieldName.getText();
            if (this.getOriginalName() == null || !this.getOriginalName().equals(newName)) {
                for (int i = 0; i < this.getSubDataset().getFields().size(); ++i) {
                    JRField f = (JRField)this.getSubDataset().getFields().get(i);
                    if (!f.getName().equals(newName)) continue;
                    JOptionPane.showMessageDialog(this, I18n.getString("messages.JRFieldDialog.DuplicatedFieldName", "A field with this name already exists!"), I18n.getString("messages.JRFieldDialog.notValidFieldNameCaption", "Invalid field!"), 2);
                    return;
                }
            }
        }
        this.tmpField = new JRField(this.jTextFieldName.getText(), "java.lang.String");
        if (this.jComboBoxType.getSelectedItem().toString().trim().length() != 0) {
            this.tmpField.setClassType(this.jComboBoxType.getSelectedItem().toString().trim());
        }
        this.tmpField.setDescription(this.jTextAreaDescription.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public JRField getField() {
        return this.tmpField;
    }

    public void setField(JRField tmpField) {
        this.originalName = tmpField.getName();
        this.jTextFieldName.setText(new String(tmpField.getName()));
        this.jComboBoxType.setSelectedItem(new String(tmpField.getClassType()));
        this.jTextAreaDescription.setText(new String(tmpField.getDescription()));
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("jRFieldDialog.buttonCancel", "Cancel"));
        this.jButtonOK.setText(I18n.getString("jRFieldDialog.buttonOK", "OK"));
        this.jLabel1.setText(I18n.getString("jRFieldDialog.label1", "Field name"));
        this.jLabel2.setText(I18n.getString("jRFieldDialog.label2", "Field class type"));
        this.jLabel4.setText(I18n.getString("jRFieldDialog.label4", "Field description"));
    }

    public SubDataset getSubDataset() {
        return this.subDataset;
    }

    public void setSubDataset(SubDataset subDataset) {
        this.subDataset = subDataset;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }
}

