/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.util.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class JRPropertyDialog
extends JDialog {
    JRProperty tmpField = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaDescription;
    private JTextField jTextFieldName;
    private int dialogResult;

    public JRPropertyDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRPropertyDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaDescription = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Add/modify property");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRPropertyDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Property name");
        this.jLabel1.setMaximumSize(new Dimension(1000, 100));
        this.jLabel1.setMinimumSize(new Dimension(100, 15));
        this.jLabel1.setPreferredSize(new Dimension(100, 15));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel4.setText("Property value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(200, 22));
        this.jScrollPane1.setPreferredSize(new Dimension(200, 67));
        this.jTextAreaDescription.setFont(new Font("Tahoma", 0, 11));
        this.jTextAreaDescription.setMinimumSize(new Dimension(0, 64));
        this.jTextAreaDescription.setPreferredSize(new Dimension(0, 64));
        this.jScrollPane1.setViewportView(this.jTextAreaDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jPanel1.setPreferredSize(new Dimension(250, 35));
        this.jPanel1.setMinimumSize(new Dimension(200, 35));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRPropertyDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRPropertyDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 320) / 2, (screenSize.height - 244) / 2, 320, 244);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("messages.jRPropertyDialog.notValidName", "Please insert a valid property name!"), I18n.getString("messages.jRPropertyDialog.notValidNameCaption", "Invalid property!"), 2);
            return;
        }
        this.tmpField = new JRProperty();
        this.tmpField.setName(this.jTextFieldName.getText().trim());
        this.tmpField.setValue(this.jTextAreaDescription.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRPropertyDialog((Frame)new JFrame(), true).setVisible(true);
    }

    public JRProperty getProperty() {
        return this.tmpField;
    }

    public void setProperty(JRProperty tmpField) {
        this.jTextFieldName.setText(new String(tmpField.getName()));
        this.jTextAreaDescription.setText(new String(tmpField.getValue()));
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
        this.jButtonCancel.setText(I18n.getString("jRPropertyDialog.buttonCancel", "Cancel"));
        this.jButtonOK.setText(I18n.getString("jRPropertyDialog.buttonOK", "OK"));
        this.jLabel1.setText(I18n.getString("jRPropertyDialog.label1", "Property name"));
        this.jLabel4.setText(I18n.getString("jRPropertyDialog.label4", "Property value"));
    }
}

