/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.api.gui;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import nickyb.sqleonardo.Preferences;

public class MaskChooser
extends JFileChooser {
    public MaskChooser(int type, int mode, boolean showAllFiles) {
        String currentDirectory = Preferences.getString("lastDirectory", System.getProperty("user.home"));
        this.setCurrentDirectory(new File(currentDirectory));
        this.setBorder(null);
        this.setDialogType(type);
        this.setFileSelectionMode(mode);
        this.setControlButtonsAreShown(false);
        this.setAcceptAllFileFilterUsed(showAllFiles);
    }

    private void fireApproveSelection() {
        if (this.getCurrentDirectory() == null) {
            return;
        }
        Preferences.set("lastDirectory", this.getCurrentDirectory().toString());
        if (this.getUI() instanceof BasicFileChooserUI) {
            ((BasicFileChooserUI)this.getUI()).getApproveSelectionAction().actionPerformed(null);
        }
    }

    public File getSelectedFile() {
        this.fireApproveSelection();
        return super.getSelectedFile();
    }

    public short getPerformType() {
        return ((AbstractFileFilter)this.getFileFilter()).getPerformType();
    }

    public static abstract class AbstractFileFilter
    extends FileFilter {
        String description;
        String[] extensions;

        public AbstractFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = extensions;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            for (int i = 0; i < this.extensions.length; ++i) {
                if (!file.getName().toLowerCase().endsWith(this.extensions[i].toLowerCase())) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }

        public abstract short getPerformType();
    }
}

