/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.grid;

import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import nickyb.sqleonardo.ctrl.grid.LogManager;

public class DataGridModel
implements TableModel {
    public static int MAX_BLOCK_RECORDS = 75;
    private Vector columns = new Vector();
    private Vector rows = new Vector();
    private Hashtable content = new Hashtable();
    private LogManager log;
    private long ridcounter = 0L;
    private int block = 1;

    public DataGridModel() {
        this.addColumn("#", 4);
        this.log = new LogManager(this);
    }

    public LogManager getLogManager() {
        return this.log;
    }

    private int getRow(int row) {
        int gap = (this.block - 1) * MAX_BLOCK_RECORDS;
        return gap < 0 ? row : row + gap;
    }

    public int getBlock() {
        return this.block;
    }

    public void setBlock(int idx) {
        this.block = idx;
    }

    public int getBlockCount() {
        return this.getFlatRowCount() / MAX_BLOCK_RECORDS + (this.getFlatRowCount() % MAX_BLOCK_RECORDS == 0 ? 0 : 1);
    }

    public void addRow(Object[] rowdata) {
        this.addRow(rowdata, false);
    }

    public void addRow(Object[] rowdata, boolean newrow) {
        Long rid = new Long(this.ridcounter++);
        this.rows.add(rid);
        this.content.put(rid, rowdata);
        if (newrow) {
            this.log.setInserted(rid);
        }
    }

    public void deleteRow(int row) {
        Long rid = (Long)this.rows.elementAt(this.getRow(row));
        this.rows.removeElement(rid);
        this.log.setDeleted(rid);
    }

    public void insertRow(int row) {
        Object[] rowdata = new Object[this.getColumnCount() - 1];
        Long rid = new Long(this.ridcounter++);
        this.rows.insertElementAt(rid, this.getRow(row));
        this.content.put(rid, rowdata);
        this.log.setInserted(rid);
    }

    public int getFlatRowCount() {
        return this.rows.size();
    }

    public int getRowCount() {
        int count = this.rows.size();
        if (count == 0) {
            return 0;
        }
        return (count -= MAX_BLOCK_RECORDS * (this.block - 1)) > MAX_BLOCK_RECORDS ? MAX_BLOCK_RECORDS : count;
    }

    public void addColumn(String text, int type) {
        this.columns.add(new Object[]{text, new Integer(type)});
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Class getColumnClass(int idx) {
        return Object.class;
    }

    public String getColumnName(int idx) {
        return ((Object[])this.columns.elementAt(idx))[0].toString();
    }

    public int getColumnIndex(String name) {
        for (int idx = 0; idx < this.columns.size(); ++idx) {
            if (!this.getColumnName(idx).equals(name)) continue;
            return idx;
        }
        return -1;
    }

    public int getColumnType(int idx) {
        return (Integer)((Object[])this.columns.elementAt(idx))[1];
    }

    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    public boolean isCellChanged(int row, int col) {
        if (col == 0) {
            return false;
        }
        Long rid = (Long)this.rows.elementAt(this.getRow(row));
        return this.log.exists(LogManager.INSERT, rid) || this.getValueAt(rid)[col - 1] instanceof Object[];
    }

    private boolean isRowChanged(int row) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.isCellChanged(row, i)) continue;
            return true;
        }
        return false;
    }

    Object[] getValueAt(Long rid) {
        return (Object[])this.content.get(rid);
    }

    public Object[] getFlatValueAt(int row) {
        Long rid = (Long)this.rows.elementAt(row);
        return this.getValueAt(rid);
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return new Long(this.getRow(row) + 1);
        }
        Long rid = (Long)this.rows.elementAt(this.getRow(row));
        Object[] rowdata = this.getValueAt(rid);
        return rowdata[col - 1] instanceof Object[] ? ((Object[])rowdata[col - 1])[0] : rowdata[col - 1];
    }

    public void resetValueAt(int row, int col) {
        if (col == 0) {
            return;
        }
        Long rid = (Long)this.rows.elementAt(this.getRow(row));
        Object[] rowdata = this.getValueAt(rid);
        if (rowdata[col - 1] instanceof Object[]) {
            this.setValueAt(((Object[])rowdata[col - 1])[1], row, col);
        }
    }

    public void setValueAt(Object aValue, int row, int col) {
        if (col == 0) {
            return;
        }
        Long rid = (Long)this.rows.elementAt(this.getRow(row));
        Object[] rowdata = this.getValueAt(rid);
        if (this.log.exists(LogManager.INSERT, rid)) {
            rowdata[col - 1] = aValue;
        } else {
            Object[] cell = new Object[]{aValue, null};
            cell[1] = rowdata[col - 1] instanceof Object[] ? ((Object[])rowdata[col - 1])[1] : rowdata[col - 1];
            if (cell[0] == null && cell[1] == null) {
                rowdata[col - 1] = null;
                cell = null;
            } else if (cell[0] != null && cell[1] != null) {
                if (cell[0].toString().equals(cell[1].toString())) {
                    rowdata[col - 1] = aValue;
                    cell = null;
                } else {
                    cell[0] = aValue;
                }
            } else {
                cell[0] = aValue;
            }
            if (cell != null) {
                rowdata[col - 1] = cell;
                this.log.setUpdated(rid);
            } else if (!this.isRowChanged(row)) {
                this.log.aborted(rid);
            }
        }
    }

    private int compare(int col, int row1, int row2) {
        Long rid1 = (Long)this.rows.elementAt(row1);
        Long rid2 = (Long)this.rows.elementAt(row2);
        Object[] rowdata1 = this.getValueAt(rid1);
        Object[] rowdata2 = this.getValueAt(rid2);
        Object value1 = rowdata1[col] instanceof Object[] ? ((Object[])rowdata1[col])[0] : rowdata1[col];
        Object value2 = rowdata2[col] instanceof Object[] ? ((Object[])rowdata2[col])[0] : rowdata2[col];
        int cmp = 0;
        if (value1 != null && value2 != null) {
            cmp = value1.toString().toLowerCase().compareTo(value2.toString().toLowerCase());
        } else if (value1 != null) {
            cmp = 1;
        } else if (value2 != null) {
            cmp = -1;
        }
        return cmp;
    }

    private void swap(int i, int j) {
        Long rid = (Long)this.rows.elementAt(i);
        this.rows.setElementAt(this.rows.elementAt(j), i);
        this.rows.setElementAt(rid, j);
    }

    private void sort(int col, int first, int last) {
        int lower = first + 1;
        int upper = last;
        this.swap(first, (first + last) / 2);
        while (lower <= upper) {
            while (this.compare(col, lower, first) < 0) {
                ++lower;
            }
            while (this.compare(col, first, upper) < 0) {
                --upper;
            }
            if (lower < upper) {
                this.swap(lower++, upper--);
                continue;
            }
            ++lower;
        }
        this.swap(upper, first);
        if (first < upper - 1) {
            this.sort(col, first, upper - 1);
        }
        if (upper + 1 < last) {
            this.sort(col, upper + 1, last);
        }
    }

    public void sort(int col) {
        if (this.getFlatRowCount() < 2) {
            return;
        }
        int max = 0;
        for (int i = 1; i < this.getFlatRowCount(); ++i) {
            if (this.compare(col - 1, max, i) >= 0) continue;
            max = i;
        }
        this.swap(this.getFlatRowCount() - 1, max);
        this.sort(col - 1, 0, this.getFlatRowCount() - 2);
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public void removeTableModelListener(TableModelListener l) {
    }
}

