/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.grid;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.api.jdbc.ConnectionHandler;
import nickyb.sqleonardo.api.jdbc._TaskSource;
import nickyb.sqleonardo.ctrl.DataGridControl;

public class TaskLoader
implements Runnable {
    private DataGridControl target;
    private _TaskSource source;
    private Statement stmt = null;
    private ResultSet rs = null;

    public TaskLoader(DataGridControl target, _TaskSource source) {
        this.target = target;
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String syntax = this.source.getSyntax().trim();
            if (this.source.getHandlerKey() != null) {
                ConnectionHandler ch = ConnectionAssistant.getHandler(this.source.getHandlerKey());
                this.stmt = ch.get().createStatement();
                this.rs = this.stmt.executeQuery(syntax);
                for (int i = 1; i <= this.getColumnCount(); ++i) {
                    String t = this.getColumnLabel(i);
                    int w = this.getColumnDisplaySize(i);
                    if (w > 50) {
                        w = 50;
                    }
                    this.target.getView().addColumn(t, this.getColumnType(i));
                }
                int row = 1;
                while (this.target.isValidThread() && this.rs.next()) {
                    Object[] rowdata = new Object[this.getColumnCount()];
                    for (int i = 1; i <= this.getColumnCount(); ++i) {
                        rowdata[i - 1] = this.rs.getString(i);
                    }
                    this.target.getView().addRow(rowdata, false);
                    this.target.refreshStatus();
                    ++row;
                }
                this.rs.close();
            }
        }
        catch (SQLException sqle) {
            Application.println(sqle, true);
        }
        finally {
            this.target.endThread();
        }
    }

    private int getColumnCount() throws SQLException {
        return this.rs.getMetaData().getColumnCount();
    }

    private int getColumnType(int index) throws SQLException {
        return this.rs.getMetaData().getColumnType(index);
    }

    private String getColumnLabel(int index) throws SQLException {
        return this.rs.getMetaData().getColumnLabel(index);
    }

    private int getColumnDisplaySize(int index) throws SQLException {
        return this.rs.getMetaData().getColumnDisplaySize(index);
    }
}

