/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.mde;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.gui.BorderLayoutPanel;
import nickyb.sqleonardo.api.gui.ListView;
import nickyb.sqleonardo.api.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.api.jdbc.ConnectionHandler;
import nickyb.sqleonardo.ctrl.mde.SideNavigator;
import nickyb.sqleonardo.ctrl.mde.UoDatasource;

public class ViewConnection
extends BorderLayoutPanel {
    private JLabel lblUrl;
    private JTextField txtUid;
    private JPasswordField txtPwd;
    private ListView lvMetaInfos;
    private StatusButton btnStatus;
    private SideNavigator navigator;

    public ViewConnection(SideNavigator navigator) {
        super(2, 3);
        this.navigator = navigator;
        this.initInformationPane();
        this.initConnectionPane();
    }

    private void initInformationPane() {
        this.lvMetaInfos = new ListView();
        this.lvMetaInfos.setHeaderVisible(false);
        this.lvMetaInfos.addColumn("property");
        this.lvMetaInfos.addColumn("value");
        this.setComponentCenter(this.lvMetaInfos);
    }

    private void initConnectionPane() {
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        JPanel pnl = new JPanel(gbl);
        pnl.setBorder(new CompoundBorder(LineBorder.createGrayLineBorder(), new EmptyBorder(2, 2, 2, 2)));
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 2, 0);
        this.lblUrl = new JLabel("<url>", 0);
        gbl.setConstraints(this.lblUrl, gbc);
        pnl.add(this.lblUrl);
        this.lblUrl.setOpaque(true);
        this.lblUrl.setBackground(Color.gray);
        this.lblUrl.setForeground(Color.white);
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        JLabel lbl = new JLabel("uid:");
        gbl.setConstraints(lbl, gbc);
        pnl.add(lbl);
        gbc.weightx = 1.0;
        this.txtUid = new JTextField();
        gbl.setConstraints(this.txtUid, gbc);
        pnl.add(this.txtUid);
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        lbl = new JLabel("pwd:");
        gbl.setConstraints(lbl, gbc);
        pnl.add(lbl);
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.txtPwd = new JPasswordField();
        gbl.setConstraints(this.txtPwd, gbc);
        pnl.add(this.txtPwd);
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        this.btnStatus = new StatusButton();
        gbl.setConstraints(this.btnStatus, gbc);
        pnl.add(this.btnStatus);
        this.setComponentNorth(pnl);
    }

    public synchronized void list(DefaultMutableTreeNode node) {
        this.lvMetaInfos.removeAllRows();
        UoDatasource uo = (UoDatasource)node.getUserObject();
        this.lblUrl.setText(uo.url);
        this.txtUid.setText(uo.uid);
        this.txtPwd.setText(uo.remember ? uo.pwd : null);
        this.txtUid.setEnabled(!uo.isConnected());
        this.txtPwd.setEnabled(!uo.isConnected());
        this.btnStatus.setSelected(uo.isConnected());
        if (uo.isConnected()) {
            ConnectionHandler ch = ConnectionAssistant.getHandler(uo.getKey());
            ArrayList al = ch.getArrayList("$connection_infos");
            Iterator i = al.iterator();
            while (i.hasNext()) {
                this.lvMetaInfos.addRow((String[])i.next());
            }
        }
    }

    private class StatusButton
    extends JToggleButton
    implements ActionListener {
        StatusButton() {
            this.addActionListener(this);
            this.setSelected(false);
        }

        public void setSelected(boolean b) {
            super.setSelected(b);
            String iconKey = b ? "icon.012" : "icon.013";
            this.setIcon(Application.resources.getIcon(iconKey));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent ae) {
            ViewConnection.this.setCursor(new Cursor(3));
            UoDatasource uoDs = (UoDatasource)ViewConnection.this.navigator.getSelectionNode().getUserObject();
            uoDs.uid = ViewConnection.this.txtUid.getText();
            uoDs.pwd = String.valueOf(ViewConnection.this.txtPwd.getPassword());
            try {
                if (this.isSelected() && !uoDs.isConnected()) {
                    uoDs.connect();
                    Application.window.connectionOpened(uoDs.getKey());
                } else if (!this.isSelected() && uoDs.isConnected()) {
                    uoDs.disconnect();
                    Application.window.connectionClosed(uoDs.getKey());
                }
                ViewConnection.this.navigator.reloadSelection();
            }
            catch (Exception e) {
                Application.println(e, true);
            }
            finally {
                this.setSelected(uoDs.isConnected());
                ViewConnection.this.setCursor(new Cursor(0));
            }
        }
    }
}

