/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.querybuilder;

import java.awt.Frame;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListIterator;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramEntity;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramField;
import nickyb.sqleonardo.ctrl.querybuilder.QueryBuilder;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;

public class DiagramLoader
extends JDialog
implements Runnable {
    static final int DEFAULT = 0;
    static final int ALL_FOREIGN_TABLES = 1;
    static final int ALL_PRIMARY_TABLES = 2;
    private JLabel message;
    private int mode;
    private boolean autoJoinRequested;
    private QueryBuilder builder;
    private QueryTokens.Table table;

    private DiagramLoader(int mode, QueryBuilder builder, QueryTokens.Table table, boolean autojoin) {
        super((Frame)SwingUtilities.getAncestorOfClass(Frame.class, builder));
        this.setModal(true);
        this.setSize(275, 55);
        this.setTitle("wait...");
        this.setResizable(false);
        this.setLocationRelativeTo(builder);
        this.setDefaultCloseOperation(0);
        this.message = new JLabel("", 0);
        this.getContentPane().add(this.message);
        this.autoJoinRequested = autojoin;
        this.builder = builder;
        this.table = table;
        this.mode = mode;
    }

    public void show() {
        new Thread(this).start();
        super.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            switch (this.mode) {
                case 1: {
                    this.addAllForeignTables();
                    return;
                }
                case 2: {
                    this.addAllPrimaryTables();
                    return;
                }
                default: {
                    this.addTable(this.table);
                    return;
                }
            }
        }
        catch (SQLException sqle) {
            System.out.println("[ DiagramLoader::run ]\n" + sqle);
            return;
        }
        finally {
            this.dispose();
        }
    }

    public static void run(int mode, QueryBuilder builder, QueryTokens.Table table, boolean autojoin) {
        new DiagramLoader(mode, builder, table, autojoin).show();
    }

    private void addTable(QueryTokens.Table table) throws SQLException {
        this.message.setText("loading: " + table.getIdentifier());
        if (QueryBuilder.autoAlias && table.getAlias() == null) {
            table.setAlias(table.getName());
            int i = 0;
            while (this.builder.diagram.getEntity(table) != null) {
                if (this.mode != 0) {
                    return;
                }
                table.setAlias(table.getName() + "_" + (char)(65 + i));
                ++i;
            }
        } else if (this.builder.diagram.getEntity(table) != null) {
            if (this.mode == 0) {
                this.hide();
                JOptionPane.showMessageDialog(this, "Table already loaded and aliasing disabled!", table.getIdentifier(), 2);
            }
            return;
        }
        DiagramEntity item = this.creatEntity(table);
        this.builder.diagram.addEntity(item);
        if (this.autoJoinRequested && QueryBuilder.autoJoin) {
            this.doAutoJoin(item);
        }
    }

    private void addTables(ResultSet rs, int rsSchemaIndex, int rsTableIndex) throws SQLException {
        ArrayList<QueryTokens.Table> list = new ArrayList<QueryTokens.Table>();
        while (rs.next()) {
            String schemaName = rs.getString(rsSchemaIndex);
            String tableName = rs.getString(rsTableIndex).trim();
            if (this.builder.getModel().getSchema() != null) {
                schemaName = null;
            }
            if (schemaName != null) {
                schemaName = schemaName.trim();
            }
            list.add(new QueryTokens.Table(schemaName, tableName));
        }
        rs.close();
        ListIterator iter = list.listIterator();
        while (iter.hasNext()) {
            this.addTable((QueryTokens.Table)iter.next());
        }
    }

    private void addAllForeignTables() throws SQLException {
        DatabaseMetaData dbmd = this.builder.getConnection().getMetaData();
        this.message.setText("reading...");
        String schema = this.builder.getModel().getSchema() == null ? this.table.getSchema() : this.builder.getModel().getSchema();
        String catalog = schema == null ? null : dbmd.getConnection().getCatalog();
        this.addTables(dbmd.getExportedKeys(catalog, schema, this.table.getName()), 6, 7);
    }

    private void addAllPrimaryTables() throws SQLException {
        DatabaseMetaData dbmd = this.builder.getConnection().getMetaData();
        this.message.setText("reading...");
        String schema = this.builder.getModel().getSchema() == null ? this.table.getSchema() : this.builder.getModel().getSchema();
        String catalog = schema == null ? null : dbmd.getConnection().getCatalog();
        this.addTables(dbmd.getImportedKeys(catalog, schema, this.table.getName()), 2, 3);
    }

    private DiagramEntity creatEntity(QueryTokens.Table table) throws SQLException {
        DiagramEntity item = new DiagramEntity(this.builder, table);
        item.setEnabled(this.builder.getConnection() != null);
        if (this.builder.getConnection() != null) {
            String catalog;
            DatabaseMetaData dbmetadata = this.builder.getConnection().getMetaData();
            Hashtable primary = this.getPrimaryKeys(dbmetadata, item);
            String name = item.querytoken.getName();
            String schema = this.builder.getModel().getSchema() == null ? item.querytoken.getSchema() : this.builder.getModel().getSchema();
            String string = catalog = schema == null ? null : dbmetadata.getConnection().getCatalog();
            if (dbmetadata.storesLowerCaseIdentifiers()) {
                name = name != null ? name.toLowerCase() : null;
                schema = schema != null ? schema.toLowerCase() : null;
                catalog = catalog != null ? catalog.toLowerCase() : null;
            } else if (dbmetadata.storesUpperCaseIdentifiers()) {
                name = name != null ? name.toUpperCase() : null;
                schema = schema != null ? schema.toUpperCase() : null;
                catalog = catalog != null ? catalog.toUpperCase() : null;
            }
            ResultSet rsColumns = dbmetadata.getColumns(catalog, schema, name, "%");
            while (rsColumns.next()) {
                String columnName = rsColumns.getString(4).trim();
                String typeName = rsColumns.getString(6);
                int size = rsColumns.getInt(7);
                int pos = rsColumns.getInt(17);
                String tip = typeName + "(" + size + ")";
                item.addField(pos, columnName, primary.get(columnName), tip);
            }
            rsColumns.close();
        }
        item.pack();
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getPrimaryKeys(DatabaseMetaData dbmetadata, DiagramEntity item) {
        Hashtable<String, String> primary = new Hashtable<String, String>();
        try {
            String catalog;
            String name = item.querytoken.getName();
            String schema = this.builder.getModel().getSchema() == null ? item.querytoken.getSchema() : this.builder.getModel().getSchema();
            String string = catalog = schema == null ? null : dbmetadata.getConnection().getCatalog();
            if (dbmetadata.storesLowerCaseIdentifiers()) {
                name = name != null ? name.toLowerCase() : null;
                schema = schema != null ? schema.toLowerCase() : null;
                catalog = catalog != null ? catalog.toLowerCase() : null;
            } else if (dbmetadata.storesUpperCaseIdentifiers()) {
                name = name != null ? name.toUpperCase() : null;
                schema = schema != null ? schema.toUpperCase() : null;
                catalog = catalog != null ? catalog.toUpperCase() : null;
            }
            ResultSet rsPK = dbmetadata.getPrimaryKeys(catalog, schema, name);
            while (rsPK.next()) {
                primary.put(rsPK.getString(4).trim(), rsPK.getString(6));
            }
            rsPK.close();
        }
        catch (SQLException sqle) {
            System.out.println("[ DiagramLoader::getPrimaryKeys ]\n" + sqle);
        }
        finally {
            return primary;
        }
    }

    private void doAutoJoin(DiagramEntity source) throws SQLException {
        if (this.builder.diagram.getEntities().length > 0) {
            String catalog;
            DatabaseMetaData dbmetadata = this.builder.getConnection().getMetaData();
            String name = source.querytoken.getName();
            String schema = this.builder.getModel().getSchema() == null ? source.querytoken.getSchema() : this.builder.getModel().getSchema();
            String string = catalog = schema == null ? null : dbmetadata.getConnection().getCatalog();
            if (dbmetadata.storesLowerCaseIdentifiers()) {
                name = name != null ? name.toLowerCase() : null;
                schema = schema != null ? schema.toLowerCase() : null;
                catalog = catalog != null ? catalog.toLowerCase() : null;
            } else if (dbmetadata.storesUpperCaseIdentifiers()) {
                name = name != null ? name.toUpperCase() : null;
                schema = schema != null ? schema.toUpperCase() : null;
                catalog = catalog != null ? catalog.toUpperCase() : null;
            }
            this.join(dbmetadata.getImportedKeys(catalog, schema, name), source, false);
            this.join(dbmetadata.getExportedKeys(catalog, schema, name), source, true);
        }
    }

    private void join(ResultSet rs, DiagramEntity source, boolean ispk) throws SQLException {
        while (rs.next()) {
            DiagramEntity itemF;
            String pkschema = rs.getString(2);
            String pktable = rs.getString(3).trim();
            String pkcolumn = rs.getString(4).trim();
            String fkschema = rs.getString(6);
            String fktable = rs.getString(7).trim();
            String fkcolumn = rs.getString(8).trim();
            String fkname = rs.getString(12);
            if (this.builder.getModel().getSchema() != null) {
                fkschema = null;
                pkschema = null;
            }
            if (pkschema != null) {
                pkschema = pkschema.trim();
            }
            if (fkschema != null) {
                fkschema = fkschema.trim();
            }
            DiagramEntity itemP = ispk ? source : this.builder.diagram.getEntity(pkschema, pktable);
            DiagramEntity diagramEntity = itemF = ispk ? this.builder.diagram.getEntity(fkschema, fktable) : source;
            if (itemP == null || itemF == null || itemP.querytoken.toString().equalsIgnoreCase(itemF.querytoken.toString())) continue;
            DiagramField fP = itemP.getField(pkcolumn, true);
            DiagramField fF = itemF.getField(fkcolumn, true);
            this.builder.diagram.join(itemP, fP, itemF, fF);
            this.builder.diagram.getRelations()[this.builder.diagram.getRelationCount() - 1].setName(fkname);
        }
        rs.close();
    }
}

