/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.querybuilder;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramEntity;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramField;
import nickyb.sqleonardo.ctrl.querybuilder.MaskJoin;
import nickyb.sqleonardo.ctrl.querybuilder.QueryBuilder;
import nickyb.sqleonardo.ctrl.querybuilder.ViewDiagram;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;

public class DiagramRelation
extends JPanel {
    QueryTokens.Join querytoken;
    DiagramEntity primaryEntity;
    DiagramField primaryField;
    DiagramEntity foreignEntity;
    DiagramField foreignField;
    Anchor anchor;
    ViewDiagram owner;
    private Point[] serie = new Point[4];

    DiagramRelation(ViewDiagram owner) {
        this.owner = owner;
        this.setLayout(null);
        this.setOpaque(false);
        this.anchor = new Anchor();
    }

    public void setName(String name) {
        super.setName(name);
        this.onPropertyChanged();
    }

    void setHighlight(boolean b) {
        this.setForeground(b ? Color.lightGray : Color.black);
        this.anchor.setBorder(new LineBorder(this.getForeground(), 1));
    }

    void setQueryToken(QueryTokens.Join token) {
        this.querytoken = token;
        this.onPropertyChanged();
    }

    void setValues(int jointype, String operator) {
        this.querytoken.setType(jointype);
        this.querytoken.getCondition().setOperator(operator);
        this.onPropertyChanged();
    }

    private void onPropertyChanged() {
        String tip = this.querytoken.getCondition().toString();
        if (this.getName() != null) {
            tip = "[ " + this.getName() + " ] " + tip;
        }
        this.anchor.setToolTipText(tip);
        switch (this.querytoken.getType()) {
            case 1: 
            case 2: {
                this.anchor.setBackground(Color.yellow);
                break;
            }
            case 3: {
                this.anchor.setBackground(Color.green);
                break;
            }
            default: {
                this.anchor.setBackground(Color.red);
            }
        }
    }

    void onCreate(QueryBuilder builder) {
        this.setQueryToken(new QueryTokens.Join(this.primaryField.querytoken, "=", this.foreignField.querytoken));
        builder.browser.addFromClause(this.querytoken);
    }

    void onDestroy(QueryBuilder builder) {
        this.primaryField.unjoined();
        this.foreignField.unjoined();
        this.primaryEntity.doFlush();
        this.foreignEntity.doFlush();
        builder.browser.removeFromClause(this.querytoken);
    }

    void doResize() {
        int yMax;
        int yMaxF;
        int yMin;
        int yMinF;
        int xMax;
        int xStart;
        int yFieldP = (int)this.primaryField.getLocationOnScreen().getY() - (int)this.primaryEntity.getLocationOnScreen().getY() + this.primaryEntity.getLocation().y;
        int yFieldF = (int)this.foreignField.getLocationOnScreen().getY() - (int)this.foreignEntity.getLocationOnScreen().getY() + this.foreignEntity.getLocation().y;
        int yStart = yFieldP + this.primaryField.getSize().height / 2;
        int yEnd = yFieldF + this.foreignField.getSize().height / 2;
        int xEnd = this.foreignEntity.getLocation().x;
        int xMin = this.primaryEntity.getLocation().x;
        if (xEnd < xMin) {
            int x = xEnd;
            xEnd = xMin;
            xMin = x;
            yStart = yFieldF + this.foreignField.getSize().height / 2;
            yEnd = yFieldP + this.primaryField.getSize().height / 2;
        }
        if ((xStart = this.primaryEntity.getLocation().x + this.primaryEntity.getSize().width) > (xMax = this.foreignEntity.getLocation().x + this.foreignEntity.getSize().width)) {
            int x = xStart;
            xStart = xMax;
            xMax = x;
        }
        if ((yMinF = this.foreignEntity.getLocation().y) < (yMin = this.primaryEntity.getLocation().y)) {
            yMin = yMinF;
        }
        if ((yMaxF = this.foreignEntity.getLocation().y + this.foreignEntity.getSize().height) > (yMax = this.primaryEntity.getLocation().y + this.primaryEntity.getSize().height)) {
            yMax = yMaxF;
        }
        Rectangle area = new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
        int y = (yStart -= area.y) > (yEnd -= area.y) ? yEnd + (yStart - yEnd) / 2 : yStart + (yEnd - yStart) / 2;
        int x = xEnd - xStart;
        x = x > this.anchor.getSize().width * 2 ? xStart - area.x + x / 2 : (area.width += 30) - 15;
        this.serie[0] = new Point(xStart - area.x, yStart);
        this.serie[1] = new Point(x, yStart);
        this.serie[2] = new Point(x, yEnd);
        this.serie[3] = new Point(xEnd - area.x, yEnd);
        this.setBounds(area);
        this.anchor.setLocation(x + area.x - this.anchor.getSize().width / 2, y + area.y - this.anchor.getSize().height / 2);
    }

    protected void paintChildren(Graphics g) {
        g.drawLine(this.serie[0].x, this.serie[0].y, this.serie[1].x, this.serie[1].y);
        g.drawLine(this.serie[1].x, this.serie[1].y, this.serie[2].x, this.serie[2].y);
        g.drawLine(this.serie[2].x, this.serie[2].y, this.serie[3].x, this.serie[3].y);
        super.paintChildren(g);
    }

    private class ActionRemove
    extends AbstractAction {
        ActionRemove() {
            super("remove");
        }

        public void actionPerformed(ActionEvent e) {
            DiagramRelation.this.owner.removeRelation(DiagramRelation.this);
        }
    }

    private class ActionEdit
    extends AbstractAction {
        ActionEdit() {
            super("edit...");
        }

        public void actionPerformed(ActionEvent e) {
            new MaskJoin(DiagramRelation.this).showDialog();
        }
    }

    private class Anchor
    extends JPanel
    implements MouseListener {
        Anchor() {
            this.addMouseListener(this);
            this.setBorder(LineBorder.createBlackLineBorder());
            this.setBackground(Color.red);
            this.setOpaque(true);
            this.setSize(10, 10);
        }

        public void mouseClicked(MouseEvent me) {
            if (SwingUtilities.isRightMouseButton(me)) {
                JPopupMenu popup = new JPopupMenu();
                popup.add(new ActionEdit());
                popup.addSeparator();
                popup.add(new ActionRemove());
                popup.show(this, me.getX(), me.getY());
            } else {
                DiagramRelation.this.owner.setHighlight(DiagramRelation.this);
            }
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }
}

