/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.querybuilder;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramEntity;
import nickyb.sqleonardo.ctrl.querybuilder.MaskReverse;
import nickyb.sqleonardo.ctrl.querybuilder.QueryBuilder;

public abstract class QueryActions {
    public static final String COPY_SYNTAX = "copy-syntax";
    public static final String REVERSE_SYNTAX = "reverse-syntax";
    public static final String ENTITIES_ARRANGE = "entities-arrange";
    public static final String ENTITIES_PACK = "entities-pack";
    public static final String ENTITIES_REMOVE = "entities-remove";
    public static final String CHANGE_WORK_MODE = "change-work-mode";

    static void init(QueryBuilder builder) {
        builder.getActionMap().put(CHANGE_WORK_MODE, new ActionChangeWorkMode(builder));
        builder.getActionMap().put(COPY_SYNTAX, new ActionCopySyntax(builder));
        builder.getActionMap().put(REVERSE_SYNTAX, new ActionReverseSyntax(builder));
        builder.getActionMap().put(ENTITIES_ARRANGE, new ActionArrangeEntities(builder));
        builder.getActionMap().put(ENTITIES_PACK, new ActionPackEntities(builder));
        builder.getActionMap().put(ENTITIES_REMOVE, new ActionRemoveEntities(builder));
    }

    static class ActionRemoveEntities
    extends AbstractQueryAction {
        ActionRemoveEntities(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", "remove entities");
        }

        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(this.builder, "do you want to continue?", "remove entites", 0, 3) == 1) {
                return;
            }
            DiagramEntity[] entities = this.builder.diagram.getEntities();
            for (int i = 0; i < entities.length; ++i) {
                entities[i].doDefaultCloseAction();
            }
        }
    }

    static class ActionPackEntities
    extends AbstractQueryAction {
        ActionPackEntities(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", "pack entities");
        }

        public void actionPerformed(ActionEvent e) {
            DiagramEntity[] entities = this.builder.diagram.getEntities();
            for (int i = 0; i < entities.length; ++i) {
                entities[i].setPack(true);
            }
        }
    }

    static class ActionArrangeEntities
    extends AbstractQueryAction {
        ActionArrangeEntities(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", "arrange entities");
        }

        public void actionPerformed(ActionEvent e) {
            this.builder.diagram.doArrangeEntities();
        }
    }

    static class ActionReverseSyntax
    extends AbstractQueryAction {
        ActionReverseSyntax(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", "reverse syntax...");
        }

        public void actionPerformed(ActionEvent e) {
            new MaskReverse(this.builder).showDialog();
        }
    }

    static class ActionCopySyntax
    extends AbstractQueryAction
    implements ClipboardOwner {
        ActionCopySyntax(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", "copy syntax");
        }

        public void actionPerformed(ActionEvent ae) {
            String value = this.builder.getModel().toString(true);
            Clipboard cb = this.builder.getToolkit().getSystemClipboard();
            StringSelection contents = new StringSelection(value);
            cb.setContents(contents, this);
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    static class ActionChangeWorkMode
    extends AbstractQueryAction {
        ActionChangeWorkMode(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", "join");
        }

        public void actionPerformed(ActionEvent ae) {
            this.builder.setJoinMode(!this.builder.isJoinMode());
        }
    }

    static abstract class AbstractQueryAction
    extends AbstractAction {
        QueryBuilder builder;

        AbstractQueryAction(QueryBuilder builder) {
            this.builder = builder;
        }
    }
}

