/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.ctrl.querybuilder;

import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import nickyb.sqleonardo.ctrl.querybuilder.BasePanel;
import nickyb.sqleonardo.ctrl.querybuilder.DiagramLoader;
import nickyb.sqleonardo.ctrl.querybuilder.QueryBuilder;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;

public class ViewObjects
extends BasePanel
implements ItemListener {
    private QueryBuilder builder;
    private JList objects;
    private JComboBox schemas;
    private JComboBox types;

    ViewObjects(QueryBuilder builder) {
        this.builder = builder;
        this.initComponents();
    }

    private void initComponents() {
        this.objects = new JList();
        this.objects.addMouseListener(new ClickHandler());
        JPanel pnlNorth = new JPanel(new GridLayout(0, 2));
        this.schemas = new JComboBox();
        pnlNorth.add(this.schemas);
        this.schemas.setToolTipText("schema filter");
        this.types = new JComboBox();
        pnlNorth.add(this.types);
        this.types.setToolTipText("type filter");
        this.setComponentNorth(pnlNorth);
        this.setComponentCenter(new JScrollPane(this.objects));
    }

    void onConnectionChanged() throws SQLException {
        this.setCursor(new Cursor(3));
        this.objects.setListData(new Vector());
        this.schemas.removeItemListener(this);
        this.types.removeItemListener(this);
        this.schemas.removeAllItems();
        this.types.removeAllItems();
        this.schemas.setEnabled(false);
        this.types.setEnabled(false);
        if (this.builder.getConnection() != null) {
            DatabaseMetaData dbmd = this.builder.getConnection().getMetaData();
            ResultSet rsTypes = dbmd.getTableTypes();
            while (rsTypes.next()) {
                String type = rsTypes.getString(1).trim();
                boolean added = false;
                for (int i = 0; !added && i < this.types.getItemCount(); ++i) {
                    added = type.equals(this.types.getItemAt(i).toString());
                }
                if (added) continue;
                this.types.addItem(type);
            }
            rsTypes.close();
            this.types.addItem("ALL");
            if (ViewObjects.jdbcUseSchema(dbmd)) {
                ResultSet rsSchemas = dbmd.getSchemas();
                while (rsSchemas.next()) {
                    this.schemas.addItem(rsSchemas.getString(1).trim());
                }
                rsSchemas.close();
            }
            this.schemas.setSelectedItem(null);
            this.types.setSelectedItem(null);
        }
        this.schemas.setEnabled(this.schemas.getItemCount() > 0);
        this.types.setEnabled(this.types.getItemCount() > 0);
        this.schemas.addItemListener(this);
        this.types.addItemListener(this);
        this.setCursor(new Cursor(0));
    }

    void onModelChanged() {
        String schema = this.builder.getModel().getSchema();
        this.schemas.setEnabled(this.schemas.isEnabled() && schema == null);
        this.schemas.setSelectedItem(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemStateChanged(ItemEvent ie) {
        Object schema = this.schemas.getSelectedItem();
        Object type = this.types.getSelectedItem();
        if (!(type == null || schema == null && this.schemas.isEnabled())) {
            this.setCursor(new Cursor(3));
            Vector<String> vObjects = new Vector<String>();
            String[] tableType = type.toString().equals("ALL") ? null : new String[]{type.toString()};
            try {
                DatabaseMetaData dbmd = this.builder.getConnection().getMetaData();
                String catalog = schema == null ? null : dbmd.getConnection().getCatalog();
                ResultSet rsTables = dbmd.getTables(catalog, schema == null ? null : schema.toString(), "%", tableType);
                if (rsTables != null) {
                    while (rsTables.next()) {
                        vObjects.addElement(rsTables.getString(3).trim());
                    }
                    rsTables.close();
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            finally {
                this.objects.setListData(vObjects);
                this.setCursor(new Cursor(0));
            }
        }
    }

    public static boolean jdbcUseSchema(DatabaseMetaData dbmd) throws SQLException {
        String term = dbmd.getSchemaTerm();
        return term != null && term.length() > 0;
    }

    private class ClickHandler
    extends MouseAdapter {
        private ClickHandler() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Object schema = ViewObjects.this.schemas.isEnabled() ? ViewObjects.this.schemas.getSelectedItem() : null;
                String table = ViewObjects.this.objects.getSelectedValue().toString();
                QueryTokens.Table token = new QueryTokens.Table(schema == null ? null : schema.toString(), table);
                DiagramLoader.run(0, ViewObjects.this.builder, token, true);
            }
        }
    }
}

