/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.mdi;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.Preferences;
import nickyb.sqleonardo.api.gui.Toolbar;
import nickyb.sqleonardo.api.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.api.jdbc.ConnectionHandler;
import nickyb.sqleonardo.api.util.Text;
import nickyb.sqleonardo.ctrl.CommandEditor;
import nickyb.sqleonardo.ctrl.cmd.DialogCommand;
import nickyb.sqleonardo.ctrl.querybuilder.QueryModel;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.SQLParser;
import nickyb.sqleonardo.mdi.ClientQueryBuilder;
import nickyb.sqleonardo.mdi.MDIActions;
import nickyb.sqleonardo.mdi.MDIClient;
import nickyb.sqleonardo.mdi._OneConnectionListener;

public class ClientCommandEditor
extends MDIClient
implements _OneConnectionListener {
    public static final String DEFAULT_TITLE = "command editor";
    private CommandEditor control = new CommandEditor();
    private JMenuItem[] m_actions;
    private String keycah;

    public ClientCommandEditor() {
        super(DEFAULT_TITLE);
        this.setComponentCenter(this.control);
        this.control.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.createToolbar();
        this.initActionsMenu();
        Application.window.addListener(this);
    }

    private void createToolbar() {
        Toolbar toolbar = new Toolbar(1);
        toolbar.add(new ActionOpen());
        toolbar.add(new ActionSave());
        toolbar.addSeparator();
        toolbar.add(this.control.getActionMap().get("start-task"));
        toolbar.add(this.control.getActionMap().get("stop-task"));
        this.setComponentEast(toolbar);
    }

    private void initActionsMenu() {
        this.m_actions = new JMenuItem[]{new JMenuItem(new ActionCommand()), new JMenuItem(new ActionClearResponse()), null, new JMenuItem(new ActionReverseSyntax())};
    }

    protected JMenuItem[] getActionsMenu() {
        return this.m_actions;
    }

    public final String getName() {
        return DEFAULT_TITLE;
    }

    public void appendCommand(String syntax) {
        this.control.append(syntax + "\n");
    }

    protected void setPreferences() {
    }

    public void onConnectionActivated(String keycah) {
        this.keycah = keycah;
        this.control.onConnectionActivated(this.keycah);
    }

    private class ActionSave
    extends MDIActions.AbstractBase {
        private ActionSave() {
            this.setIcon("icon.009");
            this.setTooltip("save");
        }

        public void actionPerformed(ActionEvent ae) {
            String currentDirectory = Preferences.getString("lastDirectory", System.getProperty("user.home"));
            JFileChooser fc = new JFileChooser(currentDirectory);
            fc.setFileSelectionMode(0);
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".sql");
                }

                public String getDescription() {
                    return "script files (*.sql)";
                }
            });
            if (fc.showSaveDialog(Application.window) == 0) {
                Preferences.set("lastDirectory", fc.getCurrentDirectory().toString());
                String filename = fc.getSelectedFile().toString();
                if (fc.getFileFilter().getDescription().endsWith("(*.sql)") && !filename.endsWith(".sql")) {
                    filename = filename + ".sql";
                }
                this.save(filename);
            }
        }

        private void save(String filename) {
            try {
                Document doc = ClientCommandEditor.this.control.getDocument();
                FileWriter out = new FileWriter(filename);
                out.write(doc.getText(0, doc.getLength()));
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (BadLocationException ble) {
                Application.println(ble, false);
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
        }
    }

    private class ActionOpen
    extends MDIActions.AbstractBase {
        private ActionOpen() {
            this.setIcon("icon.005");
            this.setTooltip("open");
        }

        public void actionPerformed(ActionEvent ae) {
            String currentDirectory = Preferences.getString("lastDirectory", System.getProperty("user.home"));
            JFileChooser fc = new JFileChooser(currentDirectory);
            fc.setFileSelectionMode(0);
            fc.setMultiSelectionEnabled(true);
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".sql");
                }

                public String getDescription() {
                    return "script files (*.sql)";
                }
            });
            if (fc.showOpenDialog(Application.window) == 0) {
                Preferences.set("lastDirectory", fc.getCurrentDirectory().toString());
                PlainDocument doc = new PlainDocument();
                for (int i = 0; i < fc.getSelectedFiles().length; ++i) {
                    String filename = fc.getSelectedFiles()[i].toString();
                    try {
                        this.load(doc, filename);
                        doc.insertString(doc.getLength(), "\n", null);
                        continue;
                    }
                    catch (BadLocationException ble) {
                        Application.println(ble, false);
                        continue;
                    }
                    catch (IOException ioe) {
                        Application.println(ioe, false);
                    }
                }
                ClientCommandEditor.this.control.setDocument(doc);
            }
        }

        private void load(PlainDocument doc, String filename) throws IOException, BadLocationException {
            int nch;
            FileReader in = new FileReader(filename);
            char[] buff = new char[4096];
            while ((nch = ((Reader)in).read(buff, 0, buff.length)) != -1) {
                doc.insertString(doc.getLength(), new String(buff, 0, nch), null);
            }
            ((Reader)in).close();
        }
    }

    private class ActionClearResponse
    extends AbstractAction {
        ActionClearResponse() {
            this.putValue("Name", "clear response");
        }

        public void actionPerformed(ActionEvent ae) {
            ClientCommandEditor.this.control.clearResponse();
        }
    }

    private class ActionReverseSyntax
    extends AbstractAction {
        ActionReverseSyntax() {
            this.putValue("Name", "reverse syntax");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientCommandEditor.this.keycah == null) {
                Application.alert("SQLeonardo", "No connection!");
                return;
            }
            String sql = ClientCommandEditor.this.control.getSelectedText();
            if (Text.isEmpty(sql)) {
                Application.alert("SQLeonardo", "Nothing selected!");
                return;
            }
            try {
                ConnectionHandler ch;
                ArrayList schemas;
                QueryModel qm = SQLParser.toQueryModel(sql);
                if (!Preferences.getBoolean("querybuilder.use-schema") && (schemas = (ArrayList)(ch = ConnectionAssistant.getHandler(ClientCommandEditor.this.keycah.toString())).getObject("$schema_names")).size() > 0) {
                    Object schema = JOptionPane.showInputDialog(Application.window, "schema:", "SQLeonardo", -1, null, schemas.toArray(), null);
                    if (schema == null) {
                        return;
                    }
                    qm.setSchema(schema.toString());
                }
                ClientQueryBuilder cqb = new ClientQueryBuilder(ClientCommandEditor.this.keycah);
                Application.window.add(cqb);
                cqb.setModel(qm);
            }
            catch (IOException e) {
                Application.println(e, true);
            }
        }
    }

    private class ActionCommand
    extends AbstractAction {
        ActionCommand() {
            this.putValue("Name", "command...");
        }

        public void actionPerformed(ActionEvent ae) {
            if (ClientCommandEditor.this.keycah != null) {
                new DialogCommand(ClientCommandEditor.this.keycah, null).show();
            } else {
                Application.alert("SQLeonardo", "No connection!");
            }
        }
    }
}

