/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.mdi;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.Preferences;
import nickyb.sqleonardo._Constants;
import nickyb.sqleonardo.api.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.api.jdbc.ConnectionHandler;
import nickyb.sqleonardo.ctrl.querybuilder.QueryModel;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryExpression;
import nickyb.sqleonardo.ctrl.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.mdi.ClientCommandEditor;
import nickyb.sqleonardo.mdi.ClientMetadataExplorer;
import nickyb.sqleonardo.mdi.ClientQueryBuilder;
import nickyb.sqleonardo.mdi.DialogAbout;
import nickyb.sqleonardo.mdi.DialogPreferences;
import nickyb.sqleonardo.mdi.DialogQuery;
import nickyb.sqleonardo.mdi.MDIClient;

public abstract class MDIActions
implements _Constants {

    public static class About
    extends AbstractBase {
        public About() {
            super("about SQLeonardo...");
        }

        public void actionPerformed(ActionEvent ae) {
            new DialogAbout().show();
        }
    }

    public static class CloseAllClients
    extends AbstractBase {
        public CloseAllClients() {
            super("close all");
        }

        public void actionPerformed(ActionEvent ae) {
            Application.window.closeAllClients();
        }
    }

    public static class TileClients
    extends AbstractBase {
        public TileClients() {
            super("tile horizontal");
        }

        public void actionPerformed(ActionEvent ae) {
            Application.window.tileClients();
        }
    }

    public static class CascadeClients
    extends AbstractBase {
        public CascadeClients() {
            super("cascade");
        }

        public void actionPerformed(ActionEvent ae) {
            Application.window.cascadeClients();
        }
    }

    public static class ShowCommandBoard
    extends AbstractShowTool {
        public ShowCommandBoard() {
            super(KeyStroke.getKeyStroke(50, 2), "icon.050");
        }

        public String getMDIClientName() {
            return "command editor";
        }

        protected MDIClient create() {
            return new ClientCommandEditor();
        }
    }

    public static class ShowMetadataExplorer
    extends AbstractShowTool {
        public ShowMetadataExplorer() {
            super(KeyStroke.getKeyStroke(49, 2), "icon.051");
        }

        public String getMDIClientName() {
            return "metadata explorer";
        }

        protected MDIClient create() {
            return new ClientMetadataExplorer();
        }
    }

    public static abstract class AbstractShowTool
    extends AbstractShow {
        public AbstractShowTool(KeyStroke ks, String iconKey) {
            this.setAccelerator(ks);
            this.setIcon(iconKey);
            this.setTooltip("show " + this.getMDIClientName());
            this.setText("show " + this.getMDIClientName());
        }

        public void actionPerformed(ActionEvent ae) {
            if (!Application.window.showClient(this.getMDIClientName())) {
                Application.window.add(this.create());
            }
        }

        protected abstract MDIClient create();
    }

    public static abstract class AbstractShow
    extends AbstractBase {
        public abstract String getMDIClientName();

        public void actionPerformed(ActionEvent ae) {
            Application.window.showClient(this.getMDIClientName());
        }
    }

    public static class ShowPreferences
    extends AbstractBase {
        public ShowPreferences() {
            super("preferences...");
            this.setIcon("icon.007");
            this.setTooltip("edit preferences");
        }

        public void actionPerformed(ActionEvent ae) {
            new DialogPreferences().show();
        }
    }

    public static class Exit
    extends AbstractBase {
        public Exit() {
            super("exit");
        }

        public void actionPerformed(ActionEvent ae) {
            Application.shutdown();
        }
    }

    public static class LoadQuery
    extends AbstractBase {
        public LoadQuery() {
            super("load query...");
        }

        private void setSchema(String schema, QueryExpression qe) {
            int i;
            if (qe == null) {
                return;
            }
            QueryTokens._Base[] tokens = qe.getQuerySpecification().getSelectList();
            for (i = 0; i < tokens.length; ++i) {
                if (!(tokens[i] instanceof QueryTokens.Column)) continue;
                ((QueryTokens.Column)tokens[i]).getTable().setSchema(schema);
            }
            tokens = qe.getQuerySpecification().getFromClause();
            for (i = 0; i < tokens.length; ++i) {
                if (tokens[i] instanceof QueryTokens.Join) {
                    ((QueryTokens.Join)tokens[i]).getPrimary().getTable().setSchema(schema);
                    ((QueryTokens.Join)tokens[i]).getForeign().getTable().setSchema(schema);
                    continue;
                }
                ((QueryTokens.Table)tokens[i]).setSchema(schema);
            }
            this.setSchema(schema, qe.getUnion());
        }

        public void actionPerformed(ActionEvent ae) {
            Object[] ret = DialogQuery.showLoad();
            if (ret[0] != null && ret[1] != null && ret[2] != null) {
                ClientQueryBuilder cqb = new ClientQueryBuilder(ret[2].toString());
                cqb.setFileName(ret[0].toString());
                QueryModel qm = (QueryModel)ret[1];
                if (Preferences.getBoolean("querybuilder.use-schema")) {
                    if (qm.getSchema() == null && ret[3] != null) {
                        int option = JOptionPane.showConfirmDialog(Application.window, "do you want to apply '" + ret[3] + "' schema on all elements?", "SQLeonardo", 1);
                        if (option == 0) {
                            this.setSchema(ret[3].toString(), qm.getQueryExpression());
                        } else if (option == 2) {
                            return;
                        }
                    }
                } else if (qm.getSchema() == null) {
                    if (ret[3] != null) {
                        qm.setSchema(ret[3].toString());
                        this.setSchema(null, qm.getQueryExpression());
                    }
                } else if (ret[3] != null) {
                    qm.setSchema(ret[3].toString());
                }
                Application.window.add(cqb);
                cqb.setModel(qm);
            }
        }
    }

    public static class NewQuery
    extends AbstractBase {
        public NewQuery() {
            super("new query");
        }

        public void actionPerformed(ActionEvent ae) {
            if (Application.window.toolbar.getConnections().length > 0) {
                Object keycah = null;
                keycah = Application.window.toolbar.getConnections().length > 1 ? JOptionPane.showInputDialog(Application.window, "use connection:", "SQLeonardo", -1, null, Application.window.toolbar.getConnections(), null) : Application.window.toolbar.getConnections()[0];
                if (keycah != null) {
                    ConnectionHandler ch;
                    ArrayList schemas;
                    QueryModel qm = new QueryModel();
                    if (!Preferences.getBoolean("querybuilder.use-schema") && (schemas = (ArrayList)(ch = ConnectionAssistant.getHandler(keycah.toString())).getObject("$schema_names")).size() > 0) {
                        Object schema = JOptionPane.showInputDialog(Application.window, "schema:", "SQLeonardo", -1, null, schemas.toArray(), null);
                        if (schema == null) {
                            return;
                        }
                        qm.setSchema(schema.toString());
                    }
                    ClientQueryBuilder cqb = new ClientQueryBuilder(keycah.toString());
                    cqb.setModel(qm);
                    Application.window.add(cqb);
                }
            } else {
                Application.alert("SQLeonardo", "No connection!");
            }
        }
    }

    public static final class Dummy
    extends AbstractAction {
        public Dummy(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent ae) {
            Application.alert("SQLeonardo", "not implemented!");
        }
    }

    public static abstract class AbstractBase
    extends AbstractAction {
        public AbstractBase() {
        }

        public AbstractBase(String text) {
            super(text);
        }

        protected void setAccelerator(KeyStroke stroke) {
            this.putValue("AcceleratorKey", stroke);
        }

        protected void setIcon(String iconkey) {
            this.putValue("SmallIcon", Application.resources.getIcon(iconkey));
        }

        protected void setText(String text) {
            this.putValue("Name", text);
        }

        protected void setTooltip(String text) {
            this.putValue("ShortDescription", text);
        }
    }
}

