/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.mdi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.border.EtchedBorder;
import nickyb.sqleonardo.Application;
import nickyb.sqleonardo.api.gui.Toolbar;
import nickyb.sqleonardo.mdi._MoreConnectionListener;

public class MDIToolbar
extends Toolbar
implements ItemListener,
_MoreConnectionListener {
    private JLabel lbl;
    private JComboBox cbx;
    private Component glue;

    public MDIToolbar() {
        super(0);
        Application.window.addListener(this);
        this.add(Application.window.getAction("action.102"));
        this.add(Application.window.getAction("action.101"));
        this.addSeparator();
        this.add(Application.window.getAction("action.100"));
        this.addSeparator();
        this.lbl = new JLabel("use connection: ");
        this.add(this.lbl);
        this.cbx = new JComboBox();
        this.add(this.cbx);
        this.addSeparator();
        this.glue = Box.createHorizontalGlue();
        this.add(this.glue);
        this.add(new MemoryBar());
        this.cbx.addItemListener(this);
        this.cbx.setVisible(false);
        this.lbl.setVisible(false);
    }

    public void onConnectionClosed(String keycah) {
        this.cbx.removeItem(keycah);
    }

    public void onConnectionOpened(String keycah) {
        this.cbx.addItem(keycah);
    }

    public void needConnection(boolean flag) {
        this.glue.setVisible(!flag);
        this.lbl.setVisible(flag);
        this.cbx.setVisible(flag);
        this.validate();
    }

    public void itemStateChanged(ItemEvent ie) {
        Application.window.connectionActivated(this.cbx.getSelectedItem() == null ? null : this.cbx.getSelectedItem().toString());
    }

    public void setActiveConnection(String keycah) {
        this.cbx.setSelectedItem(keycah);
    }

    public String[] getConnections() {
        String[] keycah = new String[this.cbx.getModel().getSize()];
        for (int i = 0; i < keycah.length; ++i) {
            keycah[i] = this.cbx.getModel().getElementAt(i).toString();
        }
        return keycah;
    }

    public String getActiveConnection() {
        return this.cbx.getSelectedIndex() == -1 ? null : this.cbx.getSelectedItem().toString();
    }

    class MemoryBar
    extends JProgressBar
    implements Runnable {
        private Thread me;

        public MemoryBar() {
            this.setBorder(new EtchedBorder(1));
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (Application.confirm("SQLeonardo", "run the garbage collector?")) {
                        System.gc();
                    }
                }
            });
            this.me = new Thread(this);
            this.me.start();
        }

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = 100;
            return dim;
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void run() {
            while (true) {
                Runtime r = Runtime.getRuntime();
                float freeMemory = r.freeMemory();
                float totalMemory = r.totalMemory();
                int allocated = (int)(totalMemory / 1024.0f);
                int used = (int)((totalMemory - freeMemory) / 1024.0f);
                this.setMaximum(allocated);
                this.setValue(used);
                String toolTip = NumberFormat.getInstance().format(used) + "K used";
                toolTip = toolTip + " / " + NumberFormat.getInstance().format(allocated) + "K allocated ";
                this.setToolTipText(toolTip);
                try {
                    if (Thread.currentThread() != this.me) continue;
                    Thread.sleep(1975L);
                    continue;
                }
                catch (InterruptedException e) {
                    Application.println(e, false);
                    continue;
                }
                break;
            }
        }
    }
}

