/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;
import rex.graphics.mdxeditor.ColorMenu;
import rex.graphics.mdxeditor.MdxEditor;
import rex.graphics.mdxeditor.RexWizard;
import rex.graphics.mdxeditor.jsp.ReadEnv;
import rex.utils.AppColors;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.LocaleOptionPane;
import rex.utils.S;

public class MdxEditorToolbar
extends JPanel
implements LanguageChangedListener {
    private MdxEditor parent;
    JLabel fontC = new JLabel(I18n.getString("label.fontC"));
    JLabel fontSizeC = new JLabel(I18n.getString("label.fontSizeC"));
    JLabel tabSizeC = new JLabel(I18n.getString("label.tabSizeC"));
    JLabel resultPosC = new JLabel(I18n.getString("label.resultPosC"));
    private JLabel runQuery;
    private JLabel runSelectedQuery;
    private JLabel showRowTotals;
    private JLabel showColumnTotals;
    public JLabel insertCodeSkeleton;
    ColorMenu foregroundMenu;
    ColorMenu backgroundMenu;
    JComboBox cbFonts;
    JComboBox cbSizes;
    JComboBox cbTabSize;
    JComboBox cbResultPosition;
    JToggleButton boldButton;
    JToggleButton italicButton;
    JToggleButton appendGeneratedMDX;
    public static String VERTICAL_SPLIT_PANE = "0";
    public static String HORIZONTAL_SPLIT_PANE = "1";
    public static String TABBED_PANE_UP = "2";
    public static String TABBED_PANE_LEFT = "3";
    public static String TABBED_PANE_RIGHT = "4";
    public static String TABBED_PANE_BOTTOM = "5";
    public static HashMap resultPositions = new HashMap(6);
    private boolean showRowTotalsOn;
    private boolean showColumnTotalsOn;
    private static ImageIcon showRowTotalsIcon;
    private static ImageIcon showColumnTotalsIcon;
    private static ImageIcon hideRowTotalsIcon;
    private static ImageIcon hideColumnTotalsIcon;
    String lastUsed = "RECENT_OPENED_FILE";
    private boolean status = true;
    Component o;
    private String[] recentURL = new String[4];
    Document document;
    DocListener documentListener;
    JMenuBar menubar = new JMenuBar();
    JMenu fileMenu = new JMenu(I18n.getString("menu.file"));
    JMenu editMenu = new JMenu(I18n.getString("menu.edit"));
    JMenu viewMenu = new JMenu(I18n.getString("menu.view"));
    JMenuItem newMenuItem = new JMenuItem(I18n.getString("menu.new"));
    JMenuItem openMenuItem = new JMenuItem(I18n.getString("menu.open"));
    JMenuItem saveMenuItem = new JMenuItem(I18n.getString("menu.save"));
    JMenuItem saveAsMenuItem = new JMenuItem(I18n.getString("menu.saveAs"));
    JMenu rflMenu = new JMenu(I18n.getString("menu.recentFileList"));
    JMenuItem exitMenuItem = new JMenuItem(I18n.getString("menu.exit"));
    JMenuItem lastUsed1MenuItem = new JMenuItem();
    JMenuItem lastUsed2MenuItem = new JMenuItem();
    JMenuItem lastUsed3MenuItem = new JMenuItem();
    JMenuItem lastUsed4MenuItem = new JMenuItem();
    JMenuItem cutMenuItem = new JMenuItem(I18n.getString("menu.cut"));
    JMenuItem copyMenuItem = new JMenuItem(I18n.getString("menu.copy"));
    JMenuItem deleteMenuItem = new JMenuItem(I18n.getString("menu.delete"));
    JMenuItem pasteMenuItem = new JMenuItem(I18n.getString("menu.paste"));
    JMenuItem selectMenuItem = new JMenuItem(I18n.getString("menu.select"));
    JMenu fontMenu = new JMenu(I18n.getString("menu.font"));
    JMenu fontNameMenu = new JMenu(I18n.getString("menu.fontName"));
    JMenu fontSizeMenu = new JMenu(I18n.getString("menu.fontSize"));
    JCheckBoxMenuItem boldMenuItem = new JCheckBoxMenuItem(I18n.getString("menu.bold"));
    JCheckBoxMenuItem italicMenuItem = new JCheckBoxMenuItem(I18n.getString("menu.italic"));
    JMenu tsMenu = new JMenu(I18n.getString("menu.tabSize"));
    JRadioButtonMenuItem tabMenuItem2 = new JRadioButtonMenuItem("2");
    JRadioButtonMenuItem tabMenuItem3 = new JRadioButtonMenuItem("3");
    JRadioButtonMenuItem tabMenuItem4 = new JRadioButtonMenuItem("4");
    ButtonGroup tabGroup = new ButtonGroup();
    ButtonGroup fontGroup = new ButtonGroup();
    ButtonGroup fontSizeGroup = new ButtonGroup();
    JMenu layoutMenu = new JMenu(I18n.getString("menu.layout"));
    JCheckBoxMenuItem srtMenuItem = new JCheckBoxMenuItem(I18n.getString("menu.showRows"));
    JCheckBoxMenuItem sctMenuItem = new JCheckBoxMenuItem(I18n.getString("menu.showCols"));
    JRadioButtonMenuItem vsMenuItem = new JRadioButtonMenuItem((String)resultPositions.get(VERTICAL_SPLIT_PANE));
    JRadioButtonMenuItem hsMenuItem = new JRadioButtonMenuItem((String)resultPositions.get(HORIZONTAL_SPLIT_PANE));
    JRadioButtonMenuItem tuMenuItem = new JRadioButtonMenuItem((String)resultPositions.get(TABBED_PANE_UP));
    JRadioButtonMenuItem tlMenuItem = new JRadioButtonMenuItem((String)resultPositions.get(TABBED_PANE_LEFT));
    JRadioButtonMenuItem trMenuItem = new JRadioButtonMenuItem((String)resultPositions.get(TABBED_PANE_RIGHT));
    JRadioButtonMenuItem tbMenuItem = new JRadioButtonMenuItem((String)resultPositions.get(TABBED_PANE_BOTTOM));
    ButtonGroup layoutGroup = new ButtonGroup();
    LocaleOptionPane localeMenu = new LocaleOptionPane();

    public MdxEditorToolbar(MdxEditor _parent) {
        JRadioButtonMenuItem menuItem;
        this.parent = _parent;
        this.runQuery = new JLabel(S.getAppIcon("runquery.gif"));
        this.runQuery.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MdxEditorToolbar.this.parent.runAllQuery();
            }
        });
        this.runQuery.setToolTipText(I18n.getString("toolTip.runAll"));
        this.runSelectedQuery = new JLabel(S.getAppIcon("runselectedquery.gif"));
        this.runSelectedQuery.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MdxEditorToolbar.this.parent.runSelectedQuery();
            }
        });
        this.runSelectedQuery.setToolTipText(I18n.getString("toolTip.runSelected"));
        this.runSelectedQuery.setOpaque(false);
        this.insertCodeSkeleton = new JLabel(S.getAppIcon("insertCodeSkeleton.gif"));
        this.insertCodeSkeleton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MdxEditorToolbar.this.parent.insertCodeSkeleton();
            }
        });
        this.insertCodeSkeleton.setToolTipText(I18n.getString("toolTip.insertCode"));
        this.insertCodeSkeleton.setOpaque(false);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        this.cbFonts = new JComboBox<String>(fontNames);
        this.cbFonts.setMaximumSize(this.cbFonts.getPreferredSize());
        this.cbFonts.setEditable(false);
        this.cbFonts.setSelectedItem("Courier New");
        this.cbFonts.setRequestFocusEnabled(false);
        this.cbFonts.setBackground(Color.white);
        this.cbFonts.addActionListener(new cbFontsListener());
        String[] fontSizes = new String[13];
        for (int i = 0; i < fontSizes.length; ++i) {
            fontSizes[i] = Integer.toString(i + 7);
        }
        this.cbSizes = new JComboBox<String>(fontSizes);
        this.cbSizes.setMaximumSize(this.cbSizes.getPreferredSize());
        this.cbSizes.setEditable(false);
        this.cbSizes.setSelectedItem(Integer.toString(13));
        this.cbSizes.setRequestFocusEnabled(false);
        this.cbSizes.setBackground(Color.white);
        this.cbSizes.addActionListener(new cbSizesListener());
        final String[] tabSizes = new String[3];
        for (int i = 0; i < tabSizes.length; ++i) {
            tabSizes[i] = Integer.toString(i + 2);
        }
        this.cbTabSize = new JComboBox<String>(tabSizes);
        this.cbTabSize.setMaximumSize(this.cbTabSize.getPreferredSize());
        this.cbTabSize.setEditable(false);
        this.cbTabSize.setSelectedItem(Integer.toString(3));
        this.cbTabSize.setRequestFocusEnabled(false);
        this.cbTabSize.setBackground(Color.white);
        this.cbTabSize.addActionListener(new cbTabSizeListener());
        this.boldButton = new JToggleButton(S.getAppIcon("bold.gif"));
        this.boldButton.addItemListener(new BoldListener());
        this.boldButton.setMargin(new Insets(0, 0, 0, 0));
        this.boldButton.setOpaque(false);
        this.italicButton = new JToggleButton(S.getAppIcon("italic.gif"));
        this.italicButton.addItemListener(new ItalicListener());
        this.italicButton.setMargin(new Insets(0, 0, 0, 0));
        this.italicButton.setOpaque(false);
        this.appendGeneratedMDX = new JToggleButton(S.getAppIcon("appendGeneratedMDX.gif"));
        this.appendGeneratedMDX.setMargin(new Insets(0, 0, 0, 0));
        this.appendGeneratedMDX.setOpaque(false);
        this.cbResultPosition = new JComboBox<Object>(resultPositions.values().toArray());
        this.cbResultPosition.setMaximumSize(this.cbResultPosition.getPreferredSize());
        this.cbResultPosition.setEditable(false);
        this.cbResultPosition.setRequestFocusEnabled(false);
        this.cbResultPosition.setBackground(Color.white);
        cbResultPositionListener resultPositionListener = new cbResultPositionListener();
        this.cbResultPosition.addActionListener(resultPositionListener);
        this.showColumnTotalsOn = false;
        this.showRowTotalsOn = false;
        this.showColumnTotals = new JLabel(showColumnTotalsIcon);
        this.showColumnTotals.setToolTipText(I18n.getString("toolTip.showColumnTotals"));
        this.showColumnTotals.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MdxEditorToolbar.this.showColumnTotalsOn = !MdxEditorToolbar.this.showColumnTotalsOn;
                if (MdxEditorToolbar.this.showColumnTotalsOn) {
                    MdxEditorToolbar.this.showColumnTotals.setIcon(hideColumnTotalsIcon);
                } else {
                    MdxEditorToolbar.this.showColumnTotals.setIcon(showColumnTotalsIcon);
                }
                MdxEditorToolbar.this.parent.setShowColumnTotalsOn(MdxEditorToolbar.this.showColumnTotalsOn);
                MdxEditorToolbar.this.sctMenuItem.setSelected(MdxEditorToolbar.this.showColumnTotalsOn);
            }
        });
        this.showColumnTotals.setBorder(AppColors.TOOLBAR_LABEL_BORDER);
        this.showRowTotals = new JLabel(showRowTotalsIcon);
        this.showRowTotals.setToolTipText(I18n.getString("toolTip.showRowTotals"));
        this.showRowTotals.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MdxEditorToolbar.this.showRowTotalsOn = !MdxEditorToolbar.this.showRowTotalsOn;
                if (MdxEditorToolbar.this.showRowTotalsOn) {
                    MdxEditorToolbar.this.showRowTotals.setIcon(hideRowTotalsIcon);
                } else {
                    MdxEditorToolbar.this.showRowTotals.setIcon(showRowTotalsIcon);
                }
                MdxEditorToolbar.this.parent.setShowRowTotalsOn(MdxEditorToolbar.this.showRowTotalsOn);
                MdxEditorToolbar.this.srtMenuItem.setSelected(MdxEditorToolbar.this.showRowTotalsOn);
            }
        });
        this.showRowTotals.setBorder(AppColors.TOOLBAR_LABEL_BORDER);
        this.setLayout(new GridLayout(2, 1));
        JPanel toolbarPanel = new JPanel();
        toolbarPanel.setLayout(new BoxLayout(toolbarPanel, 0));
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.insertCodeSkeleton);
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.runQuery);
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.runSelectedQuery);
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.fontC);
        toolbarPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        toolbarPanel.add(this.cbFonts);
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.fontSizeC);
        toolbarPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        toolbarPanel.add(this.cbSizes);
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.tabSizeC);
        toolbarPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        toolbarPanel.add(this.cbTabSize);
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.boldButton);
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.italicButton);
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.appendGeneratedMDX);
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.showColumnTotals);
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.showRowTotals);
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.cbResultPosition);
        toolbarPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        toolbarPanel.add(this.resultPosC);
        toolbarPanel.add(this.cbResultPosition);
        this.documentListener = new DocListener();
        this.parent.textArea.getDocument().addDocumentListener(this.documentListener);
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                ((MdxEditorToolbar)MdxEditorToolbar.this).parent.textArea.getDocument().removeDocumentListener(MdxEditorToolbar.this.documentListener);
                if (!MdxEditorToolbar.this.status) {
                    int confirm = JOptionPane.showConfirmDialog(null, I18n.getString("msgText.wantToSave"));
                    if (confirm == 0) {
                        if (MdxEditorToolbar.this.getSaveName().trim().length() == 0) {
                            MdxEditorToolbar.this.saveAs();
                        } else {
                            MdxEditorToolbar.this.saveFile(new File(MdxEditorToolbar.this.getSaveName()));
                            ((MdxEditorToolbar)MdxEditorToolbar.this).parent.textArea.setText("");
                            MdxEditorToolbar.this.setSaveName("");
                        }
                    } else if (confirm == 1) {
                        ((MdxEditorToolbar)MdxEditorToolbar.this).parent.textArea.setText("");
                        MdxEditorToolbar.this.setSaveName("");
                        MdxEditorToolbar.this.status = true;
                    } else if (confirm == 2 || confirm == -1) {
                        return;
                    }
                } else {
                    ((MdxEditorToolbar)MdxEditorToolbar.this).parent.textArea.setText("");
                    MdxEditorToolbar.this.setSaveName("");
                }
                ((MdxEditorToolbar)MdxEditorToolbar.this).parent.textArea.getDocument().addDocumentListener(MdxEditorToolbar.this.documentListener);
            }
        });
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                ((MdxEditorToolbar)MdxEditorToolbar.this).parent.textArea.getDocument().removeDocumentListener(MdxEditorToolbar.this.documentListener);
                if (!MdxEditorToolbar.this.status) {
                    int confirm = JOptionPane.showConfirmDialog(null, I18n.getString("msgText.wantToSave"));
                    if (confirm == 0) {
                        if (MdxEditorToolbar.this.getSaveName().trim().length() == 0) {
                            MdxEditorToolbar.this.saveAs();
                        } else {
                            MdxEditorToolbar.this.saveFile(new File(MdxEditorToolbar.this.getSaveName()));
                        }
                    } else if (confirm == 2 || confirm == -1) {
                        return;
                    }
                }
                JFileChooser jfc = new JFileChooser();
                try {
                    jfc.setFileSelectionMode(0);
                    jfc.setFileFilter(new FileFilter(){

                        public boolean accept(File pathname) {
                            return pathname.getName().toLowerCase().endsWith(".mdx") || pathname.isDirectory();
                        }

                        public String getDescription() {
                            return "MDX files (*.mdx)";
                        }
                    });
                    jfc.setCurrentDirectory(new File(ReadEnv.getEnvVars().getProperty("USERPROFILE")));
                    jfc.setSelectedFile(new File(MdxEditorToolbar.this.getSaveName()));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage());
                }
                if (jfc.showOpenDialog(null) == 0) {
                    try {
                        MdxEditorToolbar.this.openFile(new File(jfc.getSelectedFile().getAbsolutePath()), false);
                        MdxEditorToolbar.this.setLastUsed(jfc.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, e.getMessage());
                    }
                }
                ((MdxEditorToolbar)MdxEditorToolbar.this).parent.textArea.getDocument().addDocumentListener(MdxEditorToolbar.this.documentListener);
            }
        });
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                if (MdxEditorToolbar.this.getSaveName().trim().length() == 0) {
                    MdxEditorToolbar.this.saveAs();
                } else {
                    MdxEditorToolbar.this.saveFile(new File(MdxEditorToolbar.this.getSaveName()));
                }
            }
        });
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                if (!MdxEditorToolbar.this.status) {
                    int confirm = JOptionPane.showConfirmDialog(null, I18n.getString("msgText.wantToSave"));
                    if (confirm == 0) {
                        if (MdxEditorToolbar.this.getSaveName().trim().length() == 0) {
                            MdxEditorToolbar.this.saveAs();
                        } else {
                            MdxEditorToolbar.this.saveFile(new File(MdxEditorToolbar.this.getSaveName()));
                        }
                    } else if (confirm == 1 || confirm == 2 || confirm == -1) {
                        return;
                    }
                }
                for (Container comp = MdxEditorToolbar.this.parent; comp != null; comp = comp.getParent()) {
                    System.out.println("" + comp.getClass());
                    if (comp.getClass() != RexWizard.class) continue;
                    ((JDialog)comp).setVisible(false);
                    ((JDialog)comp).dispose();
                    return;
                }
                System.exit(0);
            }
        });
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                ((MdxEditorToolbar)MdxEditorToolbar.this).parent.textArea.cut();
            }
        });
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                ((MdxEditorToolbar)MdxEditorToolbar.this).parent.textArea.copy();
            }
        });
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                ((MdxEditorToolbar)MdxEditorToolbar.this).parent.textArea.paste();
            }
        });
        this.selectMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.selectMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                ((MdxEditorToolbar)MdxEditorToolbar.this).parent.textArea.selectAll();
            }
        });
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                ((MdxEditorToolbar)MdxEditorToolbar.this).parent.textArea.replaceSelection("");
            }
        });
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                MdxEditorToolbar.this.saveAs();
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.fileMenu.add(this.openMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveMenuItem);
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.localeMenu);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.rflMenu);
        this.lastUsed1MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MdxEditorToolbar.this.openFromRFL(0);
            }
        });
        this.rflMenu.add(this.lastUsed1MenuItem);
        this.lastUsed2MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MdxEditorToolbar.this.openFromRFL(1);
            }
        });
        this.rflMenu.add(this.lastUsed2MenuItem);
        this.lastUsed3MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MdxEditorToolbar.this.openFromRFL(2);
            }
        });
        this.rflMenu.add(this.lastUsed3MenuItem);
        this.lastUsed4MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MdxEditorToolbar.this.openFromRFL(0);
            }
        });
        this.rflMenu.add(this.lastUsed4MenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenuItem);
        this.editMenu.add(this.cutMenuItem);
        this.editMenu.add(this.copyMenuItem);
        this.editMenu.add(this.deleteMenuItem);
        this.editMenu.add(this.pasteMenuItem);
        this.editMenu.addSeparator();
        this.editMenu.add(this.selectMenuItem);
        this.viewMenu.add(this.fontMenu);
        this.fontMenu.add(this.fontNameMenu);
        for (int fontCount = 0; fontCount < fontNames.length; ++fontCount) {
            menuItem = new JRadioButtonMenuItem(fontNames[fontCount]);
            this.fontGroup.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent h) {
                    MdxEditorToolbar.this.parent.setFontName(menuItem.getText());
                    MdxEditorToolbar.this.cbFonts.setSelectedItem(menuItem.getText());
                }
            });
            this.fontNameMenu.add(menuItem);
        }
        this.fontMenu.add(this.fontSizeMenu);
        for (int fontSizeCount = 0; fontSizeCount < fontSizes.length; ++fontSizeCount) {
            menuItem = new JRadioButtonMenuItem(fontSizes[fontSizeCount]);
            this.fontSizeGroup.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent h) {
                    try {
                        MdxEditorToolbar.this.parent.setFontSize(Integer.parseInt(menuItem.getText()));
                        MdxEditorToolbar.this.cbSizes.setSelectedItem(menuItem.getText());
                    }
                    catch (NumberFormatException ex) {
                        return;
                    }
                }
            });
            this.fontSizeMenu.add(menuItem);
        }
        this.fontMenu.add(this.boldMenuItem);
        this.boldMenuItem.addItemListener(new BoldListener());
        this.fontMenu.add(this.italicMenuItem);
        this.italicMenuItem.addItemListener(new ItalicListener());
        this.viewMenu.add(this.tsMenu);
        this.tabGroup.add(this.tabMenuItem2);
        this.tabGroup.add(this.tabMenuItem3);
        this.tabGroup.add(this.tabMenuItem4);
        this.tabMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                try {
                    MdxEditorToolbar.this.cbTabSize.setSelectedItem(tabSizes[0]);
                }
                catch (NumberFormatException ex) {
                    return;
                }
                MdxEditorToolbar.this.parent.setTabSize(Integer.valueOf(tabSizes[0]));
            }
        });
        this.tabMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                try {
                    MdxEditorToolbar.this.cbTabSize.setSelectedItem(tabSizes[1]);
                }
                catch (NumberFormatException ex) {
                    return;
                }
                MdxEditorToolbar.this.parent.setTabSize(Integer.valueOf(tabSizes[1]));
            }
        });
        this.tabMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                try {
                    MdxEditorToolbar.this.cbTabSize.setSelectedItem(tabSizes[2]);
                }
                catch (NumberFormatException ex) {
                    return;
                }
                MdxEditorToolbar.this.parent.setTabSize(Integer.valueOf(tabSizes[2]));
            }
        });
        this.tsMenu.add(this.tabMenuItem2);
        this.tsMenu.add(this.tabMenuItem3);
        this.tsMenu.add(this.tabMenuItem4);
        this.foregroundMenu = new ColorMenu(I18n.getString("menu.foregroundColor"));
        this.foregroundMenu.addActionListener(new ForegroundListener());
        this.viewMenu.add(this.foregroundMenu);
        this.backgroundMenu = new ColorMenu(I18n.getString("menu.backgroundColor"));
        this.backgroundMenu.addActionListener(new BackgroundListener());
        this.viewMenu.add(this.backgroundMenu);
        this.viewMenu.add(this.layoutMenu);
        this.vsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                MdxEditorToolbar.this.parent.setSplitPaneView(0);
                MdxEditorToolbar.this.cbResultPosition.setSelectedItem(resultPositions.get(VERTICAL_SPLIT_PANE));
            }
        });
        this.hsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                MdxEditorToolbar.this.parent.setSplitPaneView(1);
                MdxEditorToolbar.this.cbResultPosition.setSelectedItem(resultPositions.get(HORIZONTAL_SPLIT_PANE));
            }
        });
        this.tuMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                MdxEditorToolbar.this.parent.setTabbedPaneView(1);
                MdxEditorToolbar.this.cbResultPosition.setSelectedItem(resultPositions.get(TABBED_PANE_UP));
            }
        });
        this.tlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                MdxEditorToolbar.this.parent.setTabbedPaneView(2);
                MdxEditorToolbar.this.cbResultPosition.setSelectedItem(resultPositions.get(TABBED_PANE_LEFT));
            }
        });
        this.trMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                MdxEditorToolbar.this.parent.setTabbedPaneView(4);
                MdxEditorToolbar.this.cbResultPosition.setSelectedItem(resultPositions.get(TABBED_PANE_RIGHT));
            }
        });
        this.tbMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                MdxEditorToolbar.this.parent.setTabbedPaneView(3);
                MdxEditorToolbar.this.cbResultPosition.setSelectedItem(resultPositions.get(TABBED_PANE_BOTTOM));
            }
        });
        this.layoutGroup.add(this.vsMenuItem);
        this.layoutGroup.add(this.hsMenuItem);
        this.layoutGroup.add(this.tuMenuItem);
        this.layoutGroup.add(this.tlMenuItem);
        this.layoutGroup.add(this.trMenuItem);
        this.layoutGroup.add(this.tbMenuItem);
        this.layoutMenu.add(this.vsMenuItem);
        this.layoutMenu.add(this.hsMenuItem);
        this.layoutMenu.add(this.tuMenuItem);
        this.layoutMenu.add(this.tlMenuItem);
        this.layoutMenu.add(this.trMenuItem);
        this.layoutMenu.add(this.tbMenuItem);
        this.viewMenu.addSeparator();
        this.srtMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                MdxEditorToolbar.this.showRowTotalsOn = !MdxEditorToolbar.this.showRowTotalsOn;
                if (MdxEditorToolbar.this.showRowTotalsOn) {
                    MdxEditorToolbar.this.showRowTotals.setIcon(hideRowTotalsIcon);
                } else {
                    MdxEditorToolbar.this.showRowTotals.setIcon(showRowTotalsIcon);
                }
                MdxEditorToolbar.this.parent.setShowRowTotalsOn(MdxEditorToolbar.this.showRowTotalsOn);
            }
        });
        this.sctMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent h) {
                MdxEditorToolbar.this.showColumnTotalsOn = !MdxEditorToolbar.this.showColumnTotalsOn;
                if (MdxEditorToolbar.this.showColumnTotalsOn) {
                    MdxEditorToolbar.this.showColumnTotals.setIcon(hideColumnTotalsIcon);
                } else {
                    MdxEditorToolbar.this.showColumnTotals.setIcon(showColumnTotalsIcon);
                }
                MdxEditorToolbar.this.parent.setShowColumnTotalsOn(MdxEditorToolbar.this.showColumnTotalsOn);
            }
        });
        this.viewMenu.add(this.srtMenuItem);
        this.viewMenu.add(this.sctMenuItem);
        this.menubar.add(this.fileMenu);
        this.menubar.add(this.editMenu);
        this.menubar.add(this.viewMenu);
        this.add(this.menubar);
        this.add(toolbarPanel);
        this.setBorder(AppColors.TOOLBAR_BORDER);
        this.setOpaque(false);
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
    }

    public void setLocaleEnabled(boolean b) {
        this.localeMenu.setEnabled(b);
    }

    public Locale getCurrentLocale() {
        return this.localeMenu.getCurrentLocale();
    }

    public void setCurrentLocale(Locale locale) {
        this.localeMenu.setCurrentLocale(locale);
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
        this.setCurrentLocale(evt.getLocale());
    }

    public void applyI18n() {
        this.fileMenu.setText(I18n.getString("menu.file"));
        this.editMenu.setText(I18n.getString("menu.edit"));
        this.viewMenu.setText(I18n.getString("menu.view"));
        this.newMenuItem.setText(I18n.getString("menu.new"));
        this.openMenuItem.setText(I18n.getString("menu.open"));
        this.saveMenuItem.setText(I18n.getString("menu.save"));
        this.saveAsMenuItem.setText(I18n.getString("menu.saveAs"));
        this.rflMenu.setText(I18n.getString("menu.recentFileList"));
        this.exitMenuItem.setText(I18n.getString("menu.exit"));
        this.cutMenuItem.setText(I18n.getString("menu.cut"));
        this.copyMenuItem.setText(I18n.getString("menu.copy"));
        this.deleteMenuItem.setText(I18n.getString("menu.delete"));
        this.pasteMenuItem.setText(I18n.getString("menu.paste"));
        this.selectMenuItem.setText(I18n.getString("menu.select"));
        this.fontMenu.setText(I18n.getString("menu.font"));
        this.fontNameMenu.setText(I18n.getString("menu.fontName"));
        this.fontSizeMenu.setText(I18n.getString("menu.fontSize"));
        this.boldMenuItem.setText(I18n.getString("menu.bold"));
        this.italicMenuItem.setText(I18n.getString("menu.italic"));
        this.tsMenu.setText(I18n.getString("menu.tabSize"));
        this.layoutMenu.setText(I18n.getString("menu.layout"));
        this.srtMenuItem.setText(I18n.getString("menu.showRows"));
        this.sctMenuItem.setText(I18n.getString("menu.showCols"));
        this.runQuery.setToolTipText(I18n.getString("toolTip.runAll"));
        this.runSelectedQuery.setToolTipText(I18n.getString("toolTip.runSelected"));
        this.showColumnTotals.setToolTipText(I18n.getString("toolTip.showColumnTotals"));
        this.showRowTotals.setToolTipText(I18n.getString("toolTip.showRowTotals"));
        this.insertCodeSkeleton.setToolTipText(I18n.getString("toolTip.insertCode"));
        this.fontC.setText(I18n.getString("label.fontC"));
        this.fontSizeC.setText(I18n.getString("label.fontSizeC"));
        this.tabSizeC.setText(I18n.getString("label.tabSizeC"));
        this.resultPosC.setText(I18n.getString("label.resultPosC"));
        if (this.foregroundMenu instanceof ColorMenu) {
            this.foregroundMenu.setText(I18n.getString("menu.foregroundColor"));
            this.backgroundMenu.setText(I18n.getString("menu.backgroundColor"));
        }
        resultPositions.put(VERTICAL_SPLIT_PANE, I18n.getString("panel.vertSplit"));
        resultPositions.put(HORIZONTAL_SPLIT_PANE, I18n.getString("panel.horzSplit"));
        resultPositions.put(TABBED_PANE_UP, I18n.getString("panel.tabUp"));
        resultPositions.put(TABBED_PANE_LEFT, I18n.getString("panel.tabLeft"));
        resultPositions.put(TABBED_PANE_RIGHT, I18n.getString("panel.tabRight"));
        resultPositions.put(TABBED_PANE_BOTTOM, I18n.getString("panel.tabBottom"));
        if (this.cbResultPosition instanceof JComboBox) {
            this.cbResultPosition.removeAllItems();
            this.cbResultPosition.addItem(I18n.getString("panel.vertSplit"));
            this.cbResultPosition.addItem(I18n.getString("panel.horzSplit"));
            this.cbResultPosition.addItem(I18n.getString("panel.tabUp"));
            this.cbResultPosition.addItem(I18n.getString("panel.tabLeft"));
            this.cbResultPosition.addItem(I18n.getString("panel.tabRight"));
            this.cbResultPosition.addItem(I18n.getString("panel.tabBottom"));
        }
        this.vsMenuItem.setText(I18n.getString("panel.vertSplit"));
        this.hsMenuItem.setText(I18n.getString("panel.horzSplit"));
        this.tuMenuItem.setText(I18n.getString("panel.tabUp"));
        this.tlMenuItem.setText(I18n.getString("panel.tabLeft"));
        this.trMenuItem.setText(I18n.getString("panel.tabRight"));
        this.tbMenuItem.setText(I18n.getString("panel.tabBottom"));
    }

    public void setRecentURL(String[] recentURL) {
        this.recentURL = recentURL;
        this.updateLastUsedMenu();
    }

    public String[] getRecentURL() {
        return this.recentURL;
    }

    public void setSave(boolean bool) {
        this.status = bool;
    }

    private void setLastUsed(String name) {
        int i;
        int match = 4;
        String luName = null;
        String propname = null;
        for (i = 1; i <= 4; ++i) {
            propname = this.lastUsed + i;
            luName = this.recentURL[i - 1];
            if (luName == null || !luName.equals(name)) continue;
            match = i;
            break;
        }
        for (i = match - 1; i > 0; --i) {
            if (this.recentURL[i - 1] == null) continue;
            this.recentURL[i] = this.recentURL[i - 1];
        }
        this.recentURL[0] = name;
        this.updateLastUsedMenu();
    }

    private void updateLastUsedMenu() {
        if (this.recentURL[0].trim().length() > 0) {
            this.lastUsed1MenuItem.setVisible(true);
        } else {
            this.lastUsed1MenuItem.setVisible(false);
        }
        if (this.recentURL[1].trim().length() > 0) {
            this.lastUsed2MenuItem.setVisible(true);
        } else {
            this.lastUsed2MenuItem.setVisible(false);
        }
        if (this.recentURL[2].trim().length() > 0) {
            this.lastUsed3MenuItem.setVisible(true);
        } else {
            this.lastUsed3MenuItem.setVisible(false);
        }
        if (this.recentURL[3].trim().length() > 0) {
            this.lastUsed4MenuItem.setVisible(true);
        } else {
            this.lastUsed4MenuItem.setVisible(false);
        }
        this.lastUsed1MenuItem.setText(this.recentURL[0]);
        this.lastUsed2MenuItem.setText(this.recentURL[1]);
        this.lastUsed3MenuItem.setText(this.recentURL[2]);
        this.lastUsed4MenuItem.setText(this.recentURL[3]);
        this.parent.setRecentURL(this.recentURL);
    }

    private void openFile(File file, boolean newFile) {
        if (!newFile) {
            if (!file.exists()) {
                JOptionPane.showMessageDialog(this, file.getAbsolutePath() + I18n.getString("msgText.fileNotFound"), I18n.getString("msgTitle.alert"), 2);
                return;
            }
            if (!file.canWrite()) {
                JOptionPane.showMessageDialog(this, file.getAbsolutePath() + I18n.getString("msgText.fileLocked"), I18n.getString("msgTitle.alert"), 2);
                return;
            }
            try {
                BufferedReader in = new BufferedReader(new FileReader(file));
                String str = "";
                String fullStr = "";
                while ((str = in.readLine()) != null) {
                    fullStr = fullStr.concat(str) + "\n";
                }
                this.setSaveName(file.getAbsolutePath());
                in.close();
                this.parent.textArea.setText(fullStr);
                this.status = true;
            }
            catch (Exception ex) {
                System.out.println("Exception  : Mdx file is invalid." + ex.getMessage());
                ex.printStackTrace();
            }
            catch (Error err) {
                System.out.println("Error : Mdx file is invalid." + err.getMessage());
            }
        }
    }

    private void saveFile(File file) {
        try {
            int confirm;
            if (file.getName().indexOf(".") == -1) {
                file = new File(file.getAbsolutePath().concat(".mdx"));
            }
            if (file.exists() && (confirm = JOptionPane.showConfirmDialog(this.parent, "File Already Exists. Want to override?")) == 1) {
                return;
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(this.parent.textArea.getText());
            this.setSaveName(file.getAbsolutePath());
            this.setLastUsed(file.getAbsolutePath());
            out.close();
            this.status = true;
        }
        catch (Exception ex) {
            System.out.println("Exception  : Mdx file is invalid." + ex.getMessage());
            ex.printStackTrace();
        }
        catch (Error err) {
            System.out.println("Error : Mdx file is invalid." + err.getMessage());
        }
    }

    private void saveAs() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(2);
        try {
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".mdx") || pathname.isDirectory();
                }

                public String getDescription() {
                    return "MDX files (*.mdx)";
                }
            });
            chooser.setCurrentDirectory(new File(ReadEnv.getEnvVars().getProperty("USERPROFILE")));
            chooser.setSelectedFile(new File(this.getSaveName()));
        }
        catch (Exception exception) {
            S.reportError(exception);
        }
        try {
            int returnVal = chooser.showSaveDialog(null);
            if (returnVal == 0) {
                this.saveFile(new File(chooser.getSelectedFile().getAbsolutePath()));
            }
        }
        catch (Exception exception) {
            S.reportError(exception);
        }
    }

    private void setSaveName(String mdxName) {
        this.parent.setFileName(mdxName);
    }

    public String getSaveName() {
        String temp = this.parent.getFileName();
        if (temp.trim().length() == 0) {
            return "";
        }
        return this.parent.getFileName();
    }

    public void openFromRFL(int index) {
        try {
            if (!this.status) {
                int confirm = JOptionPane.showConfirmDialog(null, I18n.getString("msgText.wantToSave"));
                if (confirm == 0) {
                    if (this.getSaveName().trim().length() == 0) {
                        this.saveAs();
                    } else {
                        this.saveFile(new File(this.getSaveName()));
                    }
                } else if (confirm == 2 || confirm == -1) {
                    return;
                }
            }
            this.openFile(new File(this.recentURL[index]), false);
            this.setLastUsed(this.recentURL[index]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean getShowRowTotalsOn() {
        return this.showRowTotalsOn;
    }

    protected boolean getShowColumnTotalsOn() {
        return this.showColumnTotalsOn;
    }

    protected boolean getAppendGeneratedMDX() {
        return this.appendGeneratedMDX.isSelected();
    }

    public void paintComponent(Graphics g) {
        S.paintBackgroundHorizontal(g, this);
        super.paintComponent(g);
    }

    public void setcbFont(String fontName) {
        this.cbFonts.setSelectedItem(fontName);
        Enumeration<AbstractButton> fontElements = this.fontGroup.getElements();
        while (fontElements.hasMoreElements()) {
            JRadioButtonMenuItem tempItem = (JRadioButtonMenuItem)fontElements.nextElement();
            if (!fontName.equalsIgnoreCase(tempItem.getText())) continue;
            tempItem.setSelected(true);
        }
    }

    public void setcbSize(int size) {
        this.cbSizes.setSelectedItem(Integer.toString(size));
        try {
            Enumeration<AbstractButton> fontElements = this.fontSizeGroup.getElements();
            while (fontElements.hasMoreElements()) {
                JRadioButtonMenuItem tempItem = (JRadioButtonMenuItem)fontElements.nextElement();
                if (!String.valueOf(size).equalsIgnoreCase(tempItem.getText())) continue;
                tempItem.setSelected(true);
            }
        }
        catch (NumberFormatException ex) {
            return;
        }
    }

    public void setBold(boolean isBold) {
        this.boldButton.setSelected(isBold);
        this.boldMenuItem.setSelected(isBold);
    }

    public void setItalic(boolean isItalic) {
        this.italicButton.setSelected(isItalic);
        this.italicMenuItem.setSelected(isItalic);
    }

    public void setTabSize(int tabSize) {
        this.cbTabSize.setSelectedItem(Integer.toString(tabSize));
        if (tabSize == 2) {
            this.tabMenuItem2.setSelected(true);
        } else if (tabSize == 3) {
            this.tabMenuItem3.setSelected(true);
        } else if (tabSize == 4) {
            this.tabMenuItem4.setSelected(true);
        }
    }

    public void setcbResultPosition(String key) {
        this.cbResultPosition.setSelectedItem((String)resultPositions.get(key));
        if (key.equalsIgnoreCase(I18n.getString("panel.vertSplit"))) {
            this.vsMenuItem.setSelected(true);
        } else if (key.equalsIgnoreCase(I18n.getString("panel.horzSplit"))) {
            this.hsMenuItem.setSelected(true);
        } else if (key.equalsIgnoreCase(I18n.getString("panel.tabUp"))) {
            this.tuMenuItem.setSelected(true);
        } else if (key.equalsIgnoreCase(I18n.getString("panel.tabLeft"))) {
            this.tlMenuItem.setSelected(true);
        } else if (key.equalsIgnoreCase(I18n.getString("panel.tabRight"))) {
            this.trMenuItem.setSelected(true);
        } else if (key.equalsIgnoreCase(I18n.getString("panel.tabBottom"))) {
            this.tbMenuItem.setSelected(true);
        }
    }

    static {
        resultPositions.put(VERTICAL_SPLIT_PANE, I18n.getString("panel.vertSplit"));
        resultPositions.put(HORIZONTAL_SPLIT_PANE, I18n.getString("panel.horzSplit"));
        resultPositions.put(TABBED_PANE_UP, I18n.getString("panel.tabUp"));
        resultPositions.put(TABBED_PANE_LEFT, I18n.getString("panel.tabLeft"));
        resultPositions.put(TABBED_PANE_RIGHT, I18n.getString("panel.tabRight"));
        resultPositions.put(TABBED_PANE_BOTTOM, I18n.getString("panel.tabBottom"));
        showRowTotalsIcon = S.getAppIcon("toolbox_show_row_totals.gif");
        hideRowTotalsIcon = S.getAppIcon("toolbox_hide_row_totals.gif");
        showColumnTotalsIcon = S.getAppIcon("toolbox_show_column_totals.gif");
        hideColumnTotalsIcon = S.getAppIcon("toolbox_hide_column_totals.gif");
    }

    class DocListener
    implements DocumentListener {
        DocListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            MdxEditorToolbar.this.status = false;
        }

        public void insertUpdate(DocumentEvent e) {
            MdxEditorToolbar.this.status = false;
        }

        public void removeUpdate(DocumentEvent e) {
            MdxEditorToolbar.this.status = false;
        }
    }

    class BackgroundListener
    implements ActionListener {
        BackgroundListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ColorMenu m = (ColorMenu)e.getSource();
            MdxEditorToolbar.this.parent.setBackgroundColor(m.getColor());
        }
    }

    class ForegroundListener
    implements ActionListener {
        ForegroundListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ColorMenu m = (ColorMenu)e.getSource();
            MdxEditorToolbar.this.parent.setForegroundColor(m.getColor());
        }
    }

    class cbResultPositionListener
    implements ActionListener {
        cbResultPositionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (MdxEditorToolbar.this.cbResultPosition.getItemCount() < 6) {
                return;
            }
            if (MdxEditorToolbar.this.cbResultPosition.getSelectedItem().toString().equals(I18n.getString("panel.vertSplit"))) {
                MdxEditorToolbar.this.parent.setSplitPaneView(0);
                MdxEditorToolbar.this.vsMenuItem.setSelected(true);
            } else if (MdxEditorToolbar.this.cbResultPosition.getSelectedItem().toString().equals(I18n.getString("panel.horzSplit"))) {
                MdxEditorToolbar.this.parent.setSplitPaneView(1);
                MdxEditorToolbar.this.hsMenuItem.setSelected(true);
            } else if (MdxEditorToolbar.this.cbResultPosition.getSelectedItem().toString().equals(I18n.getString("panel.tabUp"))) {
                MdxEditorToolbar.this.parent.setTabbedPaneView(1);
                MdxEditorToolbar.this.tuMenuItem.setSelected(true);
            } else if (MdxEditorToolbar.this.cbResultPosition.getSelectedItem().toString().equals(I18n.getString("panel.tabLeft"))) {
                MdxEditorToolbar.this.parent.setTabbedPaneView(2);
                MdxEditorToolbar.this.tlMenuItem.setSelected(true);
            } else if (MdxEditorToolbar.this.cbResultPosition.getSelectedItem().toString().equals(I18n.getString("panel.tabRight"))) {
                MdxEditorToolbar.this.parent.setTabbedPaneView(4);
                MdxEditorToolbar.this.trMenuItem.setSelected(true);
            } else if (MdxEditorToolbar.this.cbResultPosition.getSelectedItem().toString().equals(I18n.getString("panel.tabBottom"))) {
                MdxEditorToolbar.this.parent.setTabbedPaneView(3);
                MdxEditorToolbar.this.tbMenuItem.setSelected(true);
            }
        }
    }

    class cbTabSizeListener
    implements ActionListener {
        cbTabSizeListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int tabSize = 0;
            try {
                tabSize = Integer.parseInt(MdxEditorToolbar.this.cbTabSize.getSelectedItem().toString());
            }
            catch (NumberFormatException ex) {
                return;
            }
            MdxEditorToolbar.this.parent.setTabSize(tabSize);
            if (tabSize == 2) {
                MdxEditorToolbar.this.tabMenuItem2.setSelected(true);
            } else if (tabSize == 3) {
                MdxEditorToolbar.this.tabMenuItem3.setSelected(true);
            } else if (tabSize == 4) {
                MdxEditorToolbar.this.tabMenuItem4.setSelected(true);
            }
        }
    }

    class cbSizesListener
    implements ActionListener {
        cbSizesListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int fontSize = 0;
            try {
                fontSize = Integer.parseInt(MdxEditorToolbar.this.cbSizes.getSelectedItem().toString());
                Enumeration<AbstractButton> fontElements = MdxEditorToolbar.this.fontSizeGroup.getElements();
                while (fontElements.hasMoreElements()) {
                    JRadioButtonMenuItem tempItem = (JRadioButtonMenuItem)fontElements.nextElement();
                    if (!String.valueOf(fontSize).equalsIgnoreCase(tempItem.getText())) continue;
                    tempItem.setSelected(true);
                }
            }
            catch (NumberFormatException ex) {
                return;
            }
            MdxEditorToolbar.this.parent.setFontSize(fontSize);
        }
    }

    class cbFontsListener
    implements ActionListener {
        cbFontsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String fontName = MdxEditorToolbar.this.cbFonts.getSelectedItem().toString();
            MdxEditorToolbar.this.parent.setFontName(fontName);
            Enumeration<AbstractButton> fontElements = MdxEditorToolbar.this.fontGroup.getElements();
            while (fontElements.hasMoreElements()) {
                JRadioButtonMenuItem tempItem = (JRadioButtonMenuItem)fontElements.nextElement();
                if (!fontName.equalsIgnoreCase(tempItem.getText())) continue;
                tempItem.setSelected(true);
            }
        }
    }

    class ItalicListener
    implements ItemListener {
        ItalicListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            int state = e.getStateChange();
            if (state == 1) {
                MdxEditorToolbar.this.parent.setTextToItalic(true);
                MdxEditorToolbar.this.italicButton.setSelected(true);
                MdxEditorToolbar.this.italicMenuItem.setSelected(true);
            } else {
                MdxEditorToolbar.this.parent.setTextToItalic(false);
                MdxEditorToolbar.this.italicButton.setSelected(false);
                MdxEditorToolbar.this.italicMenuItem.setSelected(false);
            }
        }
    }

    class BoldListener
    implements ItemListener {
        BoldListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            int state = e.getStateChange();
            if (state == 1) {
                MdxEditorToolbar.this.parent.setTextToBold(true);
                MdxEditorToolbar.this.boldButton.setSelected(true);
                MdxEditorToolbar.this.boldMenuItem.setSelected(true);
            } else {
                MdxEditorToolbar.this.parent.setTextToBold(false);
                MdxEditorToolbar.this.boldButton.setSelected(false);
                MdxEditorToolbar.this.boldMenuItem.setSelected(false);
            }
        }
    }
}

