/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class FieldNode {
    private Properties attributes = new Properties();
    private Vector children = new Vector();
    private String name = "";
    private String value = null;
    private int childIndex = 0;
    private boolean consumed = false;

    public FieldNode(String name) {
        this.name = name;
    }

    public Properties getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Properties attributes) {
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(String def) {
        if (this.value == null || this.value.length() == 0) {
            return def;
        }
        return this.value;
    }

    public boolean getValueAsBoolean() {
        return this.value != null && this.value.trim().equalsIgnoreCase("true");
    }

    public int getValueAsInteger() {
        try {
            return Integer.parseInt(this.value + "");
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    public FieldNode getChild(String childName, boolean noNull) {
        FieldNode cn;
        Enumeration enum_children = this.children.elements();
        while (enum_children.hasMoreElements()) {
            cn = (FieldNode)enum_children.nextElement();
            if (!cn.getName().equals(childName)) continue;
            return cn;
        }
        if (noNull) {
            cn = new FieldNode(childName);
            this.children.add(cn);
            return cn;
        }
        return null;
    }

    public Vector getChilddren(String childName) {
        Vector<FieldNode> result = new Vector<FieldNode>();
        Enumeration enum_children = this.children.elements();
        while (enum_children.hasMoreElements()) {
            FieldNode cn = (FieldNode)enum_children.nextElement();
            if (!cn.getName().equals(childName)) continue;
            result.add(cn);
        }
        return result;
    }

    public FieldNode getChild(String childName) {
        return this.getChild(childName, true);
    }

    public FieldNode getNextChild() {
        if (this.getChildren().size() == 0) {
            return new FieldNode("Unnamed");
        }
        if (this.childIndex < 0) {
            this.childIndex = 0;
        }
        return (FieldNode)this.getChildren().elementAt(this.childIndex);
    }

    public String getAttribute(String attrName) {
        return this.attributes.getProperty(attrName);
    }

    public String getAttribute(String attrName, String def) {
        return this.attributes.getProperty(attrName, def);
    }

    public boolean getAttributeAsBoolean(String attrName) {
        String val = this.attributes.getProperty(attrName);
        return val != null && val.trim().equalsIgnoreCase("true");
    }

    public int getAttributeAsInteger(String attrName) {
        try {
            String val = this.attributes.getProperty(attrName);
            return Integer.parseInt(val + "");
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public Vector getChildren() {
        return this.children;
    }

    public void setChildren(Vector children) {
        this.children = children;
    }

    public boolean next(String xmlPath) {
        if (xmlPath.startsWith("/")) {
            xmlPath = xmlPath.substring(1);
        }
        if (xmlPath.indexOf("/") < 0) {
            if (!this.consumed) {
                this.consumed = true;
                return true;
            }
            return false;
        }
        xmlPath = xmlPath.substring(xmlPath.indexOf("/"));
        if (this.childIndex == 0 && this.getChildren().size() == 0) {
            if (!this.consumed) {
                this.consumed = true;
                return true;
            }
            return false;
        }
        if (!this.getNextChild().next(xmlPath)) {
            ++this.childIndex;
            if (this.childIndex < this.getChildren().size()) {
                return this.getNextChild().next(xmlPath);
            }
        } else {
            return true;
        }
        return false;
    }

    public String getChildsPath(String xmlPath) {
        if (xmlPath.indexOf("/") == xmlPath.lastIndexOf("/")) {
            return "";
        }
        xmlPath = xmlPath.substring(xmlPath.indexOf("/") + 1);
        return this.getNextChild().getName() + "(" + this.childIndex + ")::" + this.getNextChild().getChildsPath(xmlPath);
    }
}

