/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.data.olap.CustomHTTPAuthenticator;
import it.businesslogic.ireport.gui.PasswordDialog;
import it.businesslogic.ireport.util.Misc;
import java.net.Authenticator;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;

public class JRXMLADataSourceConnection
extends IReportConnection {
    private String url;
    private String username;
    private String password = null;
    private boolean savePassword;
    private String datasource;
    private String catalog;
    private String cube;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDescription() {
        return "XMLA Datasource";
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", Misc.nvl(this.getUrl(), ""));
        map.put("datasource", Misc.nvl(this.getDatasource(), ""));
        map.put("catalog", Misc.nvl(this.getCatalog(), ""));
        map.put("cube", Misc.nvl(this.getCube(), ""));
        map.put("Username", Misc.nvl(this.getUsername(), ""));
        if (this.isSavePassword()) {
            map.put("Password", Misc.nvl(this.getPassword(), ""));
        } else {
            map.put("Password", "");
        }
        map.put("SavePassword", "" + this.isSavePassword());
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setUrl((String)map.get("url"));
        this.setDatasource((String)map.get("datasource"));
        this.setCatalog((String)map.get("catalog"));
        this.setCube((String)map.get("cube"));
        this.setUsername((String)map.get("Username"));
        this.setSavePassword(("" + map.get("SavePassword")).equals("true"));
        if (this.isSavePassword()) {
            this.setPassword(Misc.nvl((String)map.get("Password"), ""));
        }
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public boolean isJRDataSource() {
        return false;
    }

    public Map getSpecialParameters(Map map) throws JRException {
        map.put("XMLA_DATA_URL", this.getUrl());
        map.put("XMLA_DATA_DATASOURCE", this.getDatasource());
        map.put("XMLA_DATA_CATALOG", this.getCatalog());
        map.put("XMLA_URL", this.getUrl());
        map.put("XMLA_DATASOURCE", this.getDatasource());
        map.put("XMLA_CATALOG", this.getCatalog());
        if (this.username != null && this.username.length() > 0) {
            String tmpPassword = this.getPassword();
            Authenticator.setDefault(new CustomHTTPAuthenticator(this.username, tmpPassword));
            map.put("XMLA_USER", this.getUsername());
            map.put("XMLA_PASSWORD", tmpPassword);
        }
        return map;
    }

    public Map disposeSpecialParameters(Map map) {
        return map;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        if (this.isSavePassword()) {
            return this.password;
        }
        try {
            return PasswordDialog.askPassword();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }
}

