/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.recorder.MessageRecorder;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

public class AggStar {
    private static final Logger LOGGER = Logger.getLogger((Class)AggStar.class);
    private static final MondrianResource mres = MondrianResource.instance();
    private final RolapStar star;
    private final FactTable aggTable;
    private final BitKey bitKey;
    private final BitKey fkBitKey;
    private final BitKey measureBitKey;
    private final Table.Column[] columns;
    private static final Logger JOIN_CONDITION_LOGGER = Logger.getLogger((Class)Table.JoinCondition.class);

    static Logger getLogger() {
        return LOGGER;
    }

    public static AggStar makeAggStar(RolapStar star, JdbcSchema.Table dbTable, MessageRecorder msgRecorder) {
        JdbcSchema.Table.Column.Usage usage;
        AggStar aggStar = new AggStar(star, dbTable);
        FactTable aggStarFactTable = aggStar.getFactTable();
        Iterator it = dbTable.getColumnUsages(16);
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            aggStarFactTable.loadFactCount(usage);
        }
        it = dbTable.getColumnUsages(4);
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            aggStarFactTable.loadMeasure(usage);
        }
        it = dbTable.getColumnUsages(2);
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            aggStarFactTable.loadForeignKey(usage);
        }
        it = dbTable.getColumnUsages(8);
        while (it.hasNext()) {
            usage = (JdbcSchema.Table.Column.Usage)it.next();
            aggStarFactTable.loadLevel(usage);
        }
        return aggStar;
    }

    AggStar(RolapStar star, JdbcSchema.Table aggTable) {
        this.star = star;
        this.bitKey = BitKey.Factory.makeBitKey(star.getColumnCount());
        this.fkBitKey = this.bitKey.emptyCopy();
        this.measureBitKey = this.bitKey.emptyCopy();
        this.aggTable = new FactTable(aggTable);
        this.columns = new Table.Column[star.getColumnCount()];
    }

    public FactTable getFactTable() {
        return this.aggTable;
    }

    public int getSize() {
        return MondrianProperties.instance().ChooseAggregateByVolume.get() ? this.getFactTable().getVolume() : this.getFactTable().getNumberOfRows();
    }

    public boolean superSetMatch(BitKey bitKey) {
        return this.getBitKey().isSuperSetOf(bitKey);
    }

    public boolean select(BitKey fkBK, BitKey measureBK) {
        return this.getFKBitKey().equals(fkBK) && this.getMeasureBitKey().isSuperSetOf(measureBK);
    }

    public RolapStar getStar() {
        return this.star;
    }

    public boolean hasMeasures() {
        return this.getFactTable().hasMeasures();
    }

    public boolean hasLevels() {
        return this.getFactTable().hasLevels();
    }

    public boolean hasForeignKeys() {
        return this.getFactTable().hasChildren();
    }

    public BitKey getBitKey() {
        return this.bitKey;
    }

    public BitKey getFKBitKey() {
        return this.fkBitKey;
    }

    public BitKey getMeasureBitKey() {
        return this.measureBitKey;
    }

    private SqlQuery getSqlQuery() {
        return this.getStar().getSqlQuery();
    }

    public Connection getJdbcConnection() {
        return this.getStar().getJdbcConnection();
    }

    public FactTable.Measure lookupMeasure(int bitPos) {
        Table.Column column = this.lookupColumn(bitPos);
        return column instanceof FactTable.Measure ? (FactTable.Measure)column : null;
    }

    public Table.Level lookupLevel(int bitPos) {
        Table.Column column = this.lookupColumn(bitPos);
        return column instanceof Table.Level ? (Table.Level)column : null;
    }

    public Table.Column lookupColumn(int bitPos) {
        return this.columns[bitPos];
    }

    private void addColumn(Table.Column column) {
        this.columns[column.getBitPosition()] = column;
    }

    public String toString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw, "");
        pw.flush();
        return sw.toString();
    }

    public void print(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println("AggStar:");
        String subprefix = prefix + "  ";
        pw.print(subprefix);
        pw.print(" bk=");
        pw.println(this.bitKey);
        pw.print(subprefix);
        pw.print("fbk=");
        pw.println(this.fkBitKey);
        pw.print(subprefix);
        pw.print("mbk=");
        pw.println(this.measureBitKey);
        pw.print(subprefix);
        pw.print("has foreign key=");
        pw.println(this.aggTable.hasChildren());
        this.aggTable.print(pw, subprefix);
    }

    public class DimTable
    extends Table {
        private final Table parent;
        private final Table.JoinCondition joinCondition;

        DimTable(Table parent, String name, MondrianDef.Relation relation, Table.JoinCondition joinCondition) {
            super(name, relation);
            this.parent = parent;
            this.joinCondition = joinCondition;
        }

        public Table getParent() {
            return this.parent;
        }

        public boolean hasParent() {
            return true;
        }

        public boolean hasJoinCondition() {
            return true;
        }

        public Table.JoinCondition getJoinCondition() {
            return this.joinCondition;
        }

        public void addColumnsToList(List list) {
            list.addAll(this.levels);
            Iterator it = this.getChildren();
            while (it.hasNext()) {
                DimTable dimTable = (DimTable)it.next();
                dimTable.addColumnsToList(list);
            }
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Table:");
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.println(this.getName());
            if (this.getRelation() != null) {
                pw.print(subprefix);
                pw.print("relation=");
                pw.println((Object)this.getRelation());
            }
            pw.print(subprefix);
            pw.println("Levels:");
            Iterator it = this.getLevels();
            while (it.hasNext()) {
                Table.Level level = (Table.Level)it.next();
                level.print(pw, subsubprefix);
                pw.println();
            }
            this.joinCondition.print(pw, subprefix);
            it = this.getChildren();
            while (it.hasNext()) {
                DimTable child = (DimTable)it.next();
                child.print(pw, subprefix);
            }
        }
    }

    public class FactTable
    extends Table {
        private Table.Column factCountColumn;
        private final List measures;
        private final int totalColumnSize;
        private int numberOfRows;

        FactTable(JdbcSchema.Table aggTable) {
            this(aggTable.getName(), aggTable.table, aggTable.getTotalColumnSize(), aggTable.getNumberOfRows());
        }

        FactTable(String name, MondrianDef.Relation relation, int totalColumnSize, int numberOfRows) {
            super(name, relation);
            this.totalColumnSize = totalColumnSize;
            this.measures = new ArrayList();
            this.numberOfRows = numberOfRows;
        }

        public Table getParent() {
            return null;
        }

        public boolean hasParent() {
            return false;
        }

        public boolean hasJoinCondition() {
            return false;
        }

        public Table.JoinCondition getJoinCondition() {
            return null;
        }

        public int getVolume() {
            return this.getTotalColumnSize() * this.getNumberOfRows();
        }

        public int getTotalColumnSize() {
            return this.totalColumnSize;
        }

        public int getNumberOfRows() {
            if (this.numberOfRows == -1) {
                this.makeNumberOfRows();
            }
            return this.numberOfRows;
        }

        void setNumberOfRows(int numberOfRows) {
            this.numberOfRows = numberOfRows;
        }

        public Iterator getMeasures() {
            return this.measures.iterator();
        }

        public boolean hasMeasures() {
            return !this.measures.isEmpty();
        }

        public Iterator getColumns() {
            ArrayList list = new ArrayList();
            list.addAll(this.measures);
            list.addAll(this.levels);
            Iterator it = this.getChildren();
            while (it.hasNext()) {
                DimTable dimTable = (DimTable)it.next();
                dimTable.addColumnsToList(list);
            }
            return list.iterator();
        }

        private void loadForeignKey(JdbcSchema.Table.Column.Usage usage) {
            if (usage.rTable != null) {
                DimTable child = this.convertTable(usage.rTable, usage.rightJoinConditionColumnName);
                this.addTable(child);
            } else {
                JdbcSchema.Table.Column column = usage.getColumn();
                String name = column.getName();
                String symbolicName = usage.getSymbolicName();
                if (symbolicName == null) {
                    symbolicName = name;
                }
                MondrianDef.Column expression = new MondrianDef.Column(this.getName(), name);
                boolean isNumeric = column.isNumeric();
                RolapStar.Column rColumn = usage.rColumn;
                if (rColumn == null) {
                    String msg = "loadForeignKey: for column " + name + ", rColumn == null";
                    AggStar.getLogger().warn((Object)msg);
                } else {
                    int bitPosition = rColumn.getBitPosition();
                    Table.ForeignKey c = new Table.ForeignKey(symbolicName, expression, isNumeric, bitPosition);
                }
            }
        }

        private void loadMeasure(JdbcSchema.Table.Column.Usage usage) {
            String name = usage.getColumn().getName();
            String symbolicName = usage.getSymbolicName();
            if (symbolicName == null) {
                symbolicName = name;
            }
            boolean isNumeric = usage.getColumn().isNumeric();
            RolapAggregator aggregator = usage.getAggregator();
            MondrianDef.Expression expression = null;
            expression = usage.getColumn().hasUsage(2) && !aggregator.isDistinct() ? this.factCountColumn.getExpression() : new MondrianDef.Column(this.getName(), name);
            int bitPosition = usage.rMeasure.getBitPosition();
            Measure aggMeasure = new Measure(symbolicName, expression, isNumeric, bitPosition, aggregator);
            this.measures.add(aggMeasure);
        }

        private void loadFactCount(JdbcSchema.Table.Column.Usage usage) {
            Table.Column aggColumn;
            String name = usage.getColumn().getName();
            String symbolicName = usage.getSymbolicName();
            if (symbolicName == null) {
                symbolicName = name;
            }
            MondrianDef.Column expression = new MondrianDef.Column(this.getName(), name);
            boolean isNumeric = usage.getColumn().isNumeric();
            int bitPosition = -1;
            this.factCountColumn = aggColumn = new Table.Column(symbolicName, expression, isNumeric, bitPosition);
        }

        private void loadLevel(JdbcSchema.Table.Column.Usage usage) {
            String name = usage.getSymbolicName();
            MondrianDef.Column expression = new MondrianDef.Column(this.getName(), usage.levelColumnName);
            boolean isNumeric = usage.getColumn().isNumeric();
            int bitPosition = usage.rColumn.getBitPosition();
            Table.Level level = new Table.Level(name, expression, isNumeric, bitPosition);
            this.addLevel(level);
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Table:");
            String subprefix = prefix + "  ";
            String subsubprefix = subprefix + "  ";
            pw.print(subprefix);
            pw.print("name=");
            pw.println(this.getName());
            if (this.getRelation() != null) {
                pw.print(subprefix);
                pw.print("relation=");
                pw.println((Object)this.getRelation());
            }
            pw.print(subprefix);
            pw.print("numberofrows=");
            pw.println(this.getNumberOfRows());
            pw.print(subprefix);
            pw.println("FactCount:");
            this.factCountColumn.print(pw, subsubprefix);
            pw.println();
            pw.print(subprefix);
            pw.println("Measures:");
            Iterator it = this.getMeasures();
            while (it.hasNext()) {
                Table.Column column = (Table.Column)it.next();
                column.print(pw, subsubprefix);
                pw.println();
            }
            pw.print(subprefix);
            pw.println("Levels:");
            it = this.getLevels();
            while (it.hasNext()) {
                Table.Level level = (Table.Level)it.next();
                level.print(pw, subsubprefix);
                pw.println();
            }
            it = this.getChildren();
            while (it.hasNext()) {
                DimTable child = (DimTable)it.next();
                child.print(pw, subprefix);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeNumberOfRows() {
            SqlQuery query = this.getSqlQuery();
            query.addSelect("count(*)");
            query.addFrom(this.getRelation(), this.getName(), false);
            Connection conn = this.getJdbcConnection();
            try {
                ResultSet rs = null;
                try {
                    rs = RolapUtil.executeQuery(conn, query.toString(), "AggStar.FactTable.makeNumberOfRows");
                    if (rs.next()) {
                        this.numberOfRows = rs.getInt(1);
                    } else {
                        String msg = mres.SqlQueryFailed.str("AggStar.FactTable.makeNumberOfRows", query.toString());
                        AggStar.getLogger().warn((Object)msg);
                        this.numberOfRows = Integer.MAX_VALUE / this.getTotalColumnSize();
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException ex) {
                AggStar.getLogger().error((Object)ex);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }

        public class Measure
        extends Table.Column {
            private final RolapAggregator aggregator;

            private Measure(String name, MondrianDef.Expression expression, boolean isNumeric, int bitPosition, RolapAggregator aggregator) {
                super(name, expression, isNumeric, bitPosition);
                this.aggregator = aggregator;
                AggStar.this.measureBitKey.setByPos(bitPosition);
            }

            public RolapAggregator getAggregator() {
                return this.aggregator;
            }

            public String getExpression(SqlQuery query) {
                String expr = this.getExpression().getExpression(query);
                RolapAggregator agg = this.getAggregator();
                return agg.isDistinct() ? expr : this.getAggregator().getExpression(expr);
            }
        }
    }

    public abstract class Table {
        private final String name;
        private final MondrianDef.Relation relation;
        protected final List levels;
        protected List children;

        Table(String name, MondrianDef.Relation relation) {
            this.name = name;
            this.relation = relation;
            this.levels = new ArrayList();
            this.children = Collections.EMPTY_LIST;
        }

        public String getName() {
            return this.name;
        }

        public abstract boolean hasParent();

        public abstract Table getParent();

        public abstract boolean hasJoinCondition();

        public abstract JoinCondition getJoinCondition();

        public MondrianDef.Relation getRelation() {
            return this.relation;
        }

        protected AggStar getAggStar() {
            return AggStar.this;
        }

        protected SqlQuery getSqlQuery() {
            return this.getAggStar().getSqlQuery();
        }

        public Connection getJdbcConnection() {
            return this.getAggStar().getJdbcConnection();
        }

        protected void addLevel(Level level) {
            this.levels.add(level);
        }

        public Iterator getLevels() {
            return this.levels.iterator();
        }

        public boolean hasLevels() {
            return !this.levels.isEmpty();
        }

        protected void addTable(DimTable child) {
            if (this.children == Collections.EMPTY_LIST) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }

        public Iterator getChildren() {
            return this.children.iterator();
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        protected DimTable convertTable(RolapStar.Table rTable, String rightJoinConditionColumnName) {
            String tableName = rTable.getAlias();
            MondrianDef.Relation relation = rTable.getRelation();
            RolapStar.Condition rjoinCondition = rTable.getCondition();
            MondrianDef.Expression rleft = rjoinCondition.getLeft();
            MondrianDef.Expression rright = rjoinCondition.getRight();
            MondrianDef.Column left = null;
            if (rightJoinConditionColumnName != null) {
                left = new MondrianDef.Column(this.getName(), rightJoinConditionColumnName);
            } else if (rleft instanceof MondrianDef.Column) {
                MondrianDef.Column rcolumn = (MondrianDef.Column)rleft;
                left = new MondrianDef.Column(this.getName(), rcolumn.name);
            } else {
                String msg = mres.BadRolapStarLeftJoinCondition.str("AggStar.Table", ((Object)((Object)rleft)).getClass().getName(), left.toString());
                AggStar.getLogger().warn((Object)msg);
            }
            JoinCondition joinCondition = new JoinCondition(left, rright);
            DimTable dimTable = new DimTable(this, tableName, relation, joinCondition);
            dimTable.convertColumns(rTable);
            dimTable.convertChildren(rTable);
            return dimTable;
        }

        protected void convertColumns(RolapStar.Table rTable) {
            Iterator it = rTable.getColumns();
            while (it.hasNext()) {
                RolapStar.Column column = (RolapStar.Column)it.next();
                String name = column.getName();
                MondrianDef.Expression expression = column.getExpression();
                boolean isNumeric = column.isNumeric();
                int bitPosition = column.getBitPosition();
                Level level = new Level(name, expression, isNumeric, bitPosition);
                this.addLevel(level);
            }
        }

        protected void convertChildren(RolapStar.Table rTable) {
            Iterator it = rTable.getChildren();
            while (it.hasNext()) {
                RolapStar.Table rTableChild = (RolapStar.Table)it.next();
                DimTable dimChild = this.convertTable(rTableChild, null);
                this.addTable(dimChild);
            }
        }

        public void addToFrom(SqlQuery query, boolean failIfExists, boolean joinToParent) {
            query.addFrom(this.relation, this.name, failIfExists);
            if (joinToParent) {
                if (this.hasParent()) {
                    this.getParent().addToFrom(query, failIfExists, joinToParent);
                }
                if (this.hasJoinCondition()) {
                    query.addWhere(this.getJoinCondition().toString(query));
                }
            }
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public abstract void print(PrintWriter var1, String var2);

        final class Level
        extends Column {
            private Level(String name, MondrianDef.Expression expression, boolean isNumeric, int bitPosition) {
                super(name, expression, isNumeric, bitPosition);
                AggStar.this.fkBitKey.setByPos(bitPosition);
            }
        }

        final class ForeignKey
        extends Column {
            private ForeignKey(String name, MondrianDef.Expression expression, boolean isNumeric, int bitPosition) {
                super(name, expression, isNumeric, bitPosition);
                AggStar.this.fkBitKey.setByPos(bitPosition);
            }
        }

        public class Column {
            private final String name;
            private final MondrianDef.Expression expression;
            private final boolean isNumeric;
            private final Column nameColumn;
            private final int bitPosition;

            protected Column(String name, MondrianDef.Expression expression, boolean isNumeric, int bitPosition) {
                this.name = name;
                this.expression = expression;
                this.isNumeric = isNumeric;
                this.bitPosition = bitPosition;
                this.nameColumn = null;
                if (bitPosition >= 0) {
                    AggStar.this.bitKey.setByPos(bitPosition);
                    AggStar.this.addColumn(this);
                }
            }

            public String getName() {
                return this.name;
            }

            public Table getTable() {
                return Table.this;
            }

            public int getBitPosition() {
                return this.bitPosition;
            }

            public boolean isNumeric() {
                return this.isNumeric;
            }

            public SqlQuery getSqlQuery() {
                return this.getTable().getAggStar().getSqlQuery();
            }

            public MondrianDef.Expression getExpression() {
                return this.expression;
            }

            public String getExpression(SqlQuery query) {
                return this.getExpression().getExpression(query);
            }

            public String toString() {
                StringWriter sw = new StringWriter(256);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void print(PrintWriter pw, String prefix) {
                SqlQuery sqlQuery = this.getSqlQuery();
                pw.print(prefix);
                pw.print(this.getName());
                pw.print(" (");
                pw.print(this.getBitPosition());
                pw.print("): ");
                pw.print(this.getExpression(sqlQuery));
            }
        }

        public class JoinCondition {
            private final MondrianDef.Expression left;
            private final MondrianDef.Expression right;

            private JoinCondition(MondrianDef.Expression left, MondrianDef.Expression right) {
                if (!(left instanceof MondrianDef.Column)) {
                    JOIN_CONDITION_LOGGER.debug((Object)("JoinCondition.left NOT Column: " + ((Object)((Object)left)).getClass().getName()));
                }
                this.left = left;
                this.right = right;
            }

            public Table getTable() {
                return Table.this;
            }

            String toString(SqlQuery query) {
                StringBuffer buf = new StringBuffer(64);
                buf.append(this.left.getExpression(query));
                buf.append(" = ");
                buf.append(this.right.getExpression(query));
                return buf.toString();
            }

            public String toString() {
                StringWriter sw = new StringWriter(128);
                PrintWriter pw = new PrintWriter(sw);
                this.print(pw, "");
                pw.flush();
                return sw.toString();
            }

            public void print(PrintWriter pw, String prefix) {
                SqlQuery sqlQueuy = this.getTable().getSqlQuery();
                pw.print(prefix);
                pw.println("JoinCondition:");
                String subprefix = prefix + "  ";
                pw.print(subprefix);
                pw.print("left=");
                pw.println(this.left.getExpression(sqlQueuy));
                pw.print(subprefix);
                pw.print("right=");
                pw.println(this.right.getExpression(sqlQueuy));
            }
        }
    }
}

