/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.springframework.core.CollectionFactory;

public class CustomCollectionEditor
extends PropertyEditorSupport {
    private final Class collectionType;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$SortedSet;

    public CustomCollectionEditor(Class collectionType) {
        if (collectionType == null) {
            throw new IllegalArgumentException("Collection type is required");
        }
        if (!(class$java$util$Collection == null ? (class$java$util$Collection = CustomCollectionEditor.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("Collection type [" + collectionType.getName() + "] does not implement [java.util.Collection]");
        }
        this.collectionType = collectionType;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object value) {
        if (this.collectionType.isInstance(value) && !this.alwaysCreateNewCollection()) {
            super.setValue(value);
        } else if (value instanceof Collection) {
            Collection source = (Collection)value;
            Collection target = this.createCollection(this.collectionType, source.size());
            Iterator it = source.iterator();
            while (it.hasNext()) {
                target.add(this.convertElement(it.next()));
            }
            super.setValue(target);
        } else if (value != null && value.getClass().isArray()) {
            int length = Array.getLength(value);
            Collection target = this.createCollection(this.collectionType, length);
            for (int i = 0; i < length; ++i) {
                target.add(this.convertElement(Array.get(value, i)));
            }
            super.setValue(target);
        } else {
            Collection target = this.createCollection(this.collectionType, 1);
            target.add(this.convertElement(value));
            super.setValue(target);
        }
    }

    protected Collection createCollection(Class collectionType, int initialCapacity) {
        if (!collectionType.isInterface()) {
            try {
                return (Collection)collectionType.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Could not instantiate collection class [" + collectionType.getName() + "]: " + ex.getMessage());
            }
        }
        if ((class$java$util$List == null ? (class$java$util$List = CustomCollectionEditor.class$("java.util.List")) : class$java$util$List).equals(collectionType)) {
            return new ArrayList(initialCapacity);
        }
        if ((class$java$util$SortedSet == null ? (class$java$util$SortedSet = CustomCollectionEditor.class$("java.util.SortedSet")) : class$java$util$SortedSet).equals(collectionType)) {
            return new TreeSet();
        }
        return CollectionFactory.createLinkedSetIfPossible(initialCapacity);
    }

    protected boolean alwaysCreateNewCollection() {
        return false;
    }

    protected Object convertElement(Object element) {
        return element;
    }

    public String getAsText() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

