/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.design;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.base.JRBaseCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.collections.SequencedHashMap;

public class JRDesignCrosstab
extends JRDesignElement
implements JRCrosstab {
    private static final long serialVersionUID = 10200L;
    protected List parametersList;
    protected Map parametersMap;
    protected Map variablesList;
    protected JRExpression parametersMapExpression;
    protected JRDesignCrosstabDataset dataset;
    protected List rowGroups;
    protected List columnGroups;
    protected List measures;
    protected Map rowGroupsMap;
    protected Map columnGroupsMap;
    protected Map measuresMap;
    protected int columnBreakOffset = 10;
    protected boolean repeatColumnHeaders = true;
    protected boolean repeatRowHeaders = true;
    protected List cellsList;
    protected Map cellsMap;
    protected JRDesignCrosstabCell[][] crossCells;
    protected JRDesignCellContents whenNoDataCell;
    protected JRDesignCellContents headerCell;
    private PropertyChangeListener measureClassChangeListener = new MeasureClassChangeListener();
    private static final Object[] BUILT_IN_PARAMETERS = new Object[]{"REPORT_PARAMETERS_MAP", class$java$util$Map == null ? (class$java$util$Map = JRDesignCrosstab.class$("java.util.Map")) : class$java$util$Map, "REPORT_LOCALE", class$java$util$Locale == null ? (class$java$util$Locale = JRDesignCrosstab.class$("java.util.Locale")) : class$java$util$Locale, "REPORT_RESOURCE_BUNDLE", class$java$util$ResourceBundle == null ? (class$java$util$ResourceBundle = JRDesignCrosstab.class$("java.util.ResourceBundle")) : class$java$util$ResourceBundle, "REPORT_TIME_ZONE", class$java$util$TimeZone == null ? (class$java$util$TimeZone = JRDesignCrosstab.class$("java.util.TimeZone")) : class$java$util$TimeZone, "REPORT_FORMAT_FACTORY", class$net$sf$jasperreports$engine$util$FormatFactory == null ? (class$net$sf$jasperreports$engine$util$FormatFactory = JRDesignCrosstab.class$("net.sf.jasperreports.engine.util.FormatFactory")) : class$net$sf$jasperreports$engine$util$FormatFactory, "REPORT_CLASS_LOADER", class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = JRDesignCrosstab.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, "REPORT_URL_HANDLER_FACTORY", class$java$net$URLStreamHandlerFactory == null ? (class$java$net$URLStreamHandlerFactory = JRDesignCrosstab.class$("java.net.URLStreamHandlerFactory")) : class$java$net$URLStreamHandlerFactory};
    private static final Object[] BUILT_IN_VARIABLES = new Object[]{"ROW_COUNT", class$java$lang$Integer == null ? (class$java$lang$Integer = JRDesignCrosstab.class$("java.lang.Integer")) : class$java$lang$Integer, "COLUMN_COUNT", class$java$lang$Integer == null ? (class$java$lang$Integer = JRDesignCrosstab.class$("java.lang.Integer")) : class$java$lang$Integer};
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$ResourceBundle;
    static /* synthetic */ Class class$java$util$TimeZone;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$util$FormatFactory;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$net$URLStreamHandlerFactory;
    static /* synthetic */ Class class$java$lang$Integer;

    public JRDesignCrosstab(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
        this.parametersList = new ArrayList();
        this.parametersMap = new HashMap();
        this.rowGroupsMap = new HashMap();
        this.rowGroups = new ArrayList();
        this.columnGroupsMap = new HashMap();
        this.columnGroups = new ArrayList();
        this.measuresMap = new HashMap();
        this.measures = new ArrayList();
        this.cellsMap = new HashMap();
        this.cellsList = new ArrayList();
        this.addBuiltinParameters();
        this.variablesList = new SequencedHashMap();
        this.addBuiltinVariables();
        this.dataset = new JRDesignCrosstabDataset();
    }

    private void addBuiltinParameters() {
        for (int i = 0; i < BUILT_IN_PARAMETERS.length; ++i) {
            JRDesignCrosstabParameter parameter = new JRDesignCrosstabParameter();
            parameter.setName((String)BUILT_IN_PARAMETERS[i++]);
            parameter.setValueClass((Class)BUILT_IN_PARAMETERS[i]);
            parameter.setSystemDefined(true);
            try {
                this.addParameter(parameter);
                continue;
            }
            catch (JRException jRException) {
                // empty catch block
            }
        }
    }

    private void addBuiltinVariables() {
        for (int i = 0; i < BUILT_IN_VARIABLES.length; ++i) {
            JRDesignVariable variable = new JRDesignVariable();
            variable.setName((String)BUILT_IN_VARIABLES[i]);
            variable.setValueClass((Class)BUILT_IN_VARIABLES[++i]);
            variable.setCalculation((byte)8);
            variable.setSystemDefined(true);
            this.addVariable(variable);
        }
    }

    public JRDesignCrosstab() {
        this(null);
    }

    public int getId() {
        return 0;
    }

    public JRCrosstabDataset getDataset() {
        return this.dataset;
    }

    public JRDesignCrosstabDataset getDesignDataset() {
        return this.dataset;
    }

    public JRCrosstabRowGroup[] getRowGroups() {
        JRCrosstabRowGroup[] groups = new JRCrosstabRowGroup[this.rowGroups.size()];
        this.rowGroups.toArray(groups);
        return groups;
    }

    public JRCrosstabColumnGroup[] getColumnGroups() {
        JRCrosstabColumnGroup[] groups = new JRCrosstabColumnGroup[this.columnGroups.size()];
        this.columnGroups.toArray(groups);
        return groups;
    }

    public JRCrosstabMeasure[] getMeasures() {
        JRCrosstabMeasure[] measureArray = new JRCrosstabMeasure[this.measures.size()];
        this.measures.toArray(measureArray);
        return measureArray;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getCrosstab(this);
    }

    public void writeXml(JRXmlWriter writer) throws IOException {
        writer.writeCrosstab(this);
    }

    public void setDataset(JRDesignCrosstabDataset dataset) {
        this.dataset = dataset;
    }

    public void addRowGroup(JRDesignCrosstabRowGroup group) throws JRException {
        String groupName = group.getName();
        if (this.rowGroupsMap.containsKey(groupName) || this.columnGroupsMap.containsKey(groupName) || this.measuresMap.containsKey(groupName)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.rowGroupsMap.put(groupName, new Integer(this.rowGroups.size()));
        this.rowGroups.add(group);
        this.addRowGroupVars(group);
    }

    protected void addRowGroupVars(JRDesignCrosstabRowGroup rowGroup) {
        this.addVariable(rowGroup.getVariable());
        Iterator measureIt = this.measures.iterator();
        while (measureIt.hasNext()) {
            JRCrosstabMeasure measure = (JRCrosstabMeasure)measureIt.next();
            this.addTotalVar(measure, rowGroup, null);
            Iterator colIt = this.columnGroups.iterator();
            while (colIt.hasNext()) {
                JRCrosstabColumnGroup colGroup = (JRCrosstabColumnGroup)colIt.next();
                this.addTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public void addColumnGroup(JRDesignCrosstabColumnGroup group) throws JRException {
        String groupName = group.getName();
        if (this.rowGroupsMap.containsKey(groupName) || this.columnGroupsMap.containsKey(groupName) || this.measuresMap.containsKey(groupName)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        this.columnGroupsMap.put(groupName, new Integer(this.columnGroups.size()));
        this.columnGroups.add(group);
        this.addColGroupVars(group);
    }

    protected void addColGroupVars(JRDesignCrosstabColumnGroup colGroup) {
        this.addVariable(colGroup.getVariable());
        Iterator measureIt = this.measures.iterator();
        while (measureIt.hasNext()) {
            JRCrosstabMeasure measure = (JRCrosstabMeasure)measureIt.next();
            this.addTotalVar(measure, null, colGroup);
            Iterator rowIt = this.rowGroups.iterator();
            while (rowIt.hasNext()) {
                JRCrosstabRowGroup rowGroup = (JRCrosstabRowGroup)rowIt.next();
                this.addTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public void addMeasure(JRDesignCrosstabMeasure measure) throws JRException {
        String measureName = measure.getName();
        if (this.rowGroupsMap.containsKey(measureName) || this.columnGroupsMap.containsKey(measureName) || this.measuresMap.containsKey(measureName)) {
            throw new JRException("A group or measure having the same name already exists in the crosstab.");
        }
        measure.addPropertyChangeListener("valueClassName", this.measureClassChangeListener);
        this.measuresMap.put(measureName, new Integer(this.measures.size()));
        this.measures.add(measure);
        this.addMeasureVars(measure);
    }

    protected void addMeasureVars(JRDesignCrosstabMeasure measure) {
        this.addVariable(measure.getVariable());
        Iterator colIt = this.columnGroups.iterator();
        while (colIt.hasNext()) {
            JRCrosstabColumnGroup colGroup = (JRCrosstabColumnGroup)colIt.next();
            this.addTotalVar(measure, null, colGroup);
        }
        Iterator rowIt = this.rowGroups.iterator();
        while (rowIt.hasNext()) {
            JRCrosstabRowGroup rowGroup = (JRCrosstabRowGroup)rowIt.next();
            this.addTotalVar(measure, rowGroup, null);
            Iterator colIt2 = this.columnGroups.iterator();
            while (colIt2.hasNext()) {
                JRCrosstabColumnGroup colGroup = (JRCrosstabColumnGroup)colIt2.next();
                this.addTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    protected void addTotalVar(JRCrosstabMeasure measure, JRCrosstabRowGroup rowGroup, JRCrosstabColumnGroup colGroup) {
        JRDesignVariable var = new JRDesignVariable();
        var.setCalculation((byte)8);
        var.setSystemDefined(true);
        var.setName(JRDesignCrosstab.getTotalVariableName(measure, rowGroup, colGroup));
        var.setValueClassName(measure.getValueClassName());
        this.addVariable(var);
    }

    protected void removeTotalVar(JRCrosstabMeasure measure, JRCrosstabRowGroup rowGroup, JRCrosstabColumnGroup colGroup) {
        String varName = JRDesignCrosstab.getTotalVariableName(measure, rowGroup, colGroup);
        this.removeVariable(varName);
    }

    public static String getTotalVariableName(JRCrosstabMeasure measure, JRCrosstabRowGroup rowGroup, JRCrosstabColumnGroup colGroup) {
        StringBuffer name = new StringBuffer();
        name.append(measure.getName());
        if (rowGroup != null) {
            name.append('_');
            name.append(rowGroup.getName());
        }
        if (colGroup != null) {
            name.append('_');
            name.append(colGroup.getName());
        }
        name.append("_ALL");
        return name.toString();
    }

    public JRCrosstabRowGroup removeRowGroup(String groupName) {
        JRCrosstabRowGroup removed = null;
        Integer idx = (Integer)this.rowGroupsMap.remove(groupName);
        if (idx != null) {
            removed = (JRCrosstabRowGroup)this.rowGroups.remove(idx);
            Iterator it = this.rowGroups.listIterator(idx);
            while (it.hasNext()) {
                JRCrosstabRowGroup group = (JRCrosstabRowGroup)it.next();
                this.rowGroupsMap.put(group.getName(), new Integer(it.previousIndex()));
            }
            it = this.cellsList.iterator();
            while (it.hasNext()) {
                JRCrosstabCell cell = (JRCrosstabCell)it.next();
                String rowTotalGroup = cell.getRowTotalGroup();
                if (rowTotalGroup == null || !rowTotalGroup.equals(groupName)) continue;
                it.remove();
                this.cellsMap.remove(new Pair(rowTotalGroup, cell.getColumnTotalGroup()));
            }
            this.removeRowGroupVars(removed);
        }
        return removed;
    }

    protected void removeRowGroupVars(JRCrosstabRowGroup rowGroup) {
        this.removeVariable(rowGroup.getVariable());
        Iterator measureIt = this.measures.iterator();
        while (measureIt.hasNext()) {
            JRCrosstabMeasure measure = (JRCrosstabMeasure)measureIt.next();
            this.removeTotalVar(measure, rowGroup, null);
            Iterator colIt = this.columnGroups.iterator();
            while (colIt.hasNext()) {
                JRCrosstabColumnGroup colGroup = (JRCrosstabColumnGroup)colIt.next();
                this.removeTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public JRCrosstabRowGroup removeRowGroup(JRCrosstabRowGroup group) {
        return this.removeRowGroup(group.getName());
    }

    public JRCrosstabColumnGroup removeColumnGroup(String groupName) {
        JRCrosstabColumnGroup removed = null;
        Integer idx = (Integer)this.columnGroupsMap.remove(groupName);
        if (idx != null) {
            removed = (JRCrosstabColumnGroup)this.columnGroups.remove(idx);
            Iterator it = this.columnGroups.listIterator(idx);
            while (it.hasNext()) {
                JRCrosstabColumnGroup group = (JRCrosstabColumnGroup)it.next();
                this.columnGroupsMap.put(group.getName(), new Integer(it.previousIndex()));
            }
            it = this.cellsList.iterator();
            while (it.hasNext()) {
                JRCrosstabCell cell = (JRCrosstabCell)it.next();
                String columnTotalGroup = cell.getColumnTotalGroup();
                if (columnTotalGroup == null || !columnTotalGroup.equals(groupName)) continue;
                it.remove();
                this.cellsMap.remove(new Pair(cell.getRowTotalGroup(), columnTotalGroup));
            }
            this.removeColGroupVars(removed);
        }
        return removed;
    }

    protected void removeColGroupVars(JRCrosstabColumnGroup colGroup) {
        this.removeVariable(colGroup.getVariable());
        Iterator measureIt = this.measures.iterator();
        while (measureIt.hasNext()) {
            JRCrosstabMeasure measure = (JRCrosstabMeasure)measureIt.next();
            this.removeTotalVar(measure, null, colGroup);
            Iterator rowIt = this.rowGroups.iterator();
            while (rowIt.hasNext()) {
                JRCrosstabRowGroup rowGroup = (JRCrosstabRowGroup)rowIt.next();
                this.removeTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public JRCrosstabColumnGroup removeColumnGroup(JRCrosstabColumnGroup group) {
        return this.removeColumnGroup(group.getName());
    }

    public JRCrosstabMeasure removeMeasure(String measureName) {
        JRDesignCrosstabMeasure removed = null;
        Integer idx = (Integer)this.measuresMap.remove(measureName);
        if (idx != null) {
            removed = (JRDesignCrosstabMeasure)this.measures.remove(idx);
            ListIterator it = this.measures.listIterator(idx);
            while (it.hasNext()) {
                JRCrosstabMeasure group = (JRCrosstabMeasure)it.next();
                this.measuresMap.put(group.getName(), new Integer(it.previousIndex()));
            }
            this.removeMeasureVars(removed);
            removed.removePropertyChangeListener("valueClassName", this.measureClassChangeListener);
        }
        return removed;
    }

    protected void removeMeasureVars(JRDesignCrosstabMeasure measure) {
        this.removeVariable(measure.getVariable());
        Iterator colIt = this.columnGroups.iterator();
        while (colIt.hasNext()) {
            JRCrosstabColumnGroup colGroup = (JRCrosstabColumnGroup)colIt.next();
            this.removeTotalVar(measure, null, colGroup);
        }
        Iterator rowIt = this.rowGroups.iterator();
        while (rowIt.hasNext()) {
            JRCrosstabRowGroup rowGroup = (JRCrosstabRowGroup)rowIt.next();
            this.removeTotalVar(measure, rowGroup, null);
            Iterator colIt2 = this.columnGroups.iterator();
            while (colIt2.hasNext()) {
                JRCrosstabColumnGroup colGroup = (JRCrosstabColumnGroup)colIt2.next();
                this.removeTotalVar(measure, rowGroup, colGroup);
            }
        }
    }

    public JRCrosstabMeasure removeMeasure(JRCrosstabMeasure measure) {
        return this.removeMeasure(measure.getName());
    }

    public boolean isRepeatColumnHeaders() {
        return this.repeatColumnHeaders;
    }

    public void setRepeatColumnHeaders(boolean repeatColumnHeaders) {
        this.repeatColumnHeaders = repeatColumnHeaders;
    }

    public boolean isRepeatRowHeaders() {
        return this.repeatRowHeaders;
    }

    public void setRepeatRowHeaders(boolean repeatRowHeaders) {
        this.repeatRowHeaders = repeatRowHeaders;
    }

    public JRCrosstabCell[][] getCells() {
        return this.crossCells;
    }

    public List getCellsList() {
        return this.cellsList;
    }

    public void addCell(JRDesignCrosstabCell cell) throws JRException {
        String rowTotalGroup = cell.getRowTotalGroup();
        if (rowTotalGroup != null && !this.rowGroupsMap.containsKey(rowTotalGroup)) {
            throw new JRException("Row group " + rowTotalGroup + " does not exist.");
        }
        String columnTotalGroup = cell.getColumnTotalGroup();
        if (columnTotalGroup != null && !this.columnGroupsMap.containsKey(columnTotalGroup)) {
            throw new JRException("Row group " + columnTotalGroup + " does not exist.");
        }
        Pair cellKey = new Pair(rowTotalGroup, columnTotalGroup);
        if (this.cellsMap.containsKey(cellKey)) {
            throw new JRException("Duplicate cell in crosstab.");
        }
        this.cellsMap.put(cellKey, cell);
        this.cellsList.add(cell);
    }

    public JRCrosstabCell removeCell(String rowTotalGroup, String columnTotalGroup) {
        Pair cellKey = new Pair(rowTotalGroup, columnTotalGroup);
        JRCrosstabCell cell = (JRCrosstabCell)this.cellsMap.remove(cellKey);
        if (cell != null) {
            this.cellsList.remove(cell);
        }
        return cell;
    }

    public JRCrosstabCell removeCell(JRCrosstabCell cell) {
        Pair cellKey = new Pair(cell.getRowTotalGroup(), cell.getColumnTotalGroup());
        JRCrosstabCell removedCell = (JRCrosstabCell)this.cellsMap.remove(cellKey);
        if (removedCell != null) {
            this.cellsList.remove(removedCell);
        }
        return removedCell;
    }

    public JRCrosstabParameter[] getParameters() {
        JRCrosstabParameter[] parameters = new JRCrosstabParameter[this.parametersList.size()];
        this.parametersList.toArray(parameters);
        return parameters;
    }

    public List getParametersList() {
        return this.parametersList;
    }

    public Map getParametersMap() {
        return this.parametersMap;
    }

    public JRExpression getParametersMapExpression() {
        return this.parametersMapExpression;
    }

    public void addParameter(JRCrosstabParameter parameter) throws JRException {
        if (this.parametersMap.containsKey(parameter.getName()) && this.parametersMap.containsKey(parameter.getName())) {
            throw new JRException("Duplicate declaration of parameter : " + parameter.getName());
        }
        this.parametersMap.put(parameter.getName(), parameter);
        this.parametersList.add(parameter);
    }

    public JRCrosstabParameter removeParameter(String parameterName) {
        JRCrosstabParameter param = (JRCrosstabParameter)this.parametersMap.remove(parameterName);
        if (param != null) {
            this.parametersList.remove(param);
        }
        return param;
    }

    public JRCrosstabParameter removeParameter(JRCrosstabParameter parameter) {
        return this.removeParameter(parameter.getName());
    }

    public void setParametersMapExpression(JRExpression expression) {
        this.parametersMapExpression = expression;
    }

    public Map getVariablesMap() {
        JRVariable[] variables = this.getVariables();
        HashMap<String, JRVariable> variablesMap = new HashMap<String, JRVariable>();
        for (int i = 0; i < variables.length; ++i) {
            variablesMap.put(variables[i].getName(), variables[i]);
        }
        return variablesMap;
    }

    public JRVariable[] getVariables() {
        JRVariable[] variables = new JRVariable[this.variablesList.size()];
        this.variablesList.values().toArray(variables);
        return variables;
    }

    public int getColumnBreakOffset() {
        return this.columnBreakOffset;
    }

    public void setColumnBreakOffset(int columnBreakOffset) {
        this.columnBreakOffset = columnBreakOffset;
    }

    public void preprocess() {
        this.setGroupVariablesClass(this.rowGroups);
        this.setGroupVariablesClass(this.columnGroups);
        this.calculateSizes();
    }

    protected void setGroupVariablesClass(List groups) {
        Iterator it = groups.iterator();
        while (it.hasNext()) {
            JRExpression expression;
            JRDesignCrosstabGroup group = (JRDesignCrosstabGroup)it.next();
            JRCrosstabBucket bucket = group.getBucket();
            if (bucket == null || (expression = bucket.getExpression()) == null) continue;
            group.designVariable.setValueClassName(expression.getValueClassName());
        }
    }

    protected void calculateSizes() {
        this.setWhenNoDataCellSize();
        this.createCellMatrix();
        int rowHeadersWidth = this.calculateRowHeadersSizes();
        int colHeadersHeight = this.calculateColumnHeadersSizes();
        if (this.headerCell != null) {
            this.headerCell.setWidth(rowHeadersWidth);
            this.headerCell.setHeight(colHeadersHeight);
        }
    }

    protected void setWhenNoDataCellSize() {
        if (this.whenNoDataCell != null) {
            this.whenNoDataCell.setWidth(this.getWidth());
            this.whenNoDataCell.setHeight(this.getHeight());
        }
    }

    protected void createCellMatrix() {
        this.crossCells = new JRDesignCrosstabCell[this.rowGroups.size() + 1][this.columnGroups.size() + 1];
        Iterator it = this.cellsList.iterator();
        while (it.hasNext()) {
            int columnGroupIndex;
            String columnTotalGroup;
            int rowGroupIndex;
            JRDesignCrosstabCell crosstabCell = (JRDesignCrosstabCell)it.next();
            JRDesignCellContents contents = (JRDesignCellContents)crosstabCell.getContents();
            String rowTotalGroup = crosstabCell.getRowTotalGroup();
            rowGroupIndex = rowTotalGroup == null ? (rowGroupIndex = this.rowGroups.size()) : (Integer)this.rowGroupsMap.get(rowTotalGroup);
            Integer cellWidth = crosstabCell.getWidth();
            if (cellWidth != null) {
                contents.setWidth(cellWidth);
            }
            columnGroupIndex = (columnTotalGroup = crosstabCell.getColumnTotalGroup()) == null ? (columnGroupIndex = this.columnGroups.size()) : (Integer)this.columnGroupsMap.get(columnTotalGroup);
            Integer cellHeight = crosstabCell.getHeight();
            if (cellHeight != null) {
                contents.setHeight(cellHeight);
            }
            this.crossCells[rowGroupIndex][columnGroupIndex] = crosstabCell;
        }
        this.inheritCells();
    }

    protected JRDesignCrosstabRowGroup getRowGroup(int rowGroupIndex) {
        return (JRDesignCrosstabRowGroup)this.rowGroups.get(rowGroupIndex);
    }

    protected JRDesignCrosstabColumnGroup getColumnGroup(int columnGroupIndex) {
        return (JRDesignCrosstabColumnGroup)this.columnGroups.get(columnGroupIndex);
    }

    protected void inheritCells() {
        for (int i = this.rowGroups.size(); i >= 0; --i) {
            for (int j = this.columnGroups.size(); j >= 0; --j) {
                boolean used;
                boolean bl = used = !(i != this.rowGroups.size() && !this.getRowGroup(i).hasTotal() || j != this.columnGroups.size() && !this.getColumnGroup(j).hasTotal());
                if (used) {
                    if (this.crossCells[i][j] == null) {
                        this.inheritCell(i, j);
                        if (this.crossCells[i][j] != null) continue;
                        this.crossCells[i][j] = this.emptyCell(i, j);
                        this.inheritCellSize(i, j);
                        continue;
                    }
                    this.inheritCellSize(i, j);
                    continue;
                }
                this.crossCells[i][j] = null;
            }
        }
    }

    private JRDesignCrosstabCell emptyCell(int i, int j) {
        JRDesignCrosstabCell emptyCell = new JRDesignCrosstabCell();
        if (i < this.rowGroups.size()) {
            emptyCell.setRowTotalGroup(((JRCrosstabRowGroup)this.rowGroups.get(i)).getName());
        }
        if (j < this.columnGroups.size()) {
            emptyCell.setColumnTotalGroup(((JRCrosstabColumnGroup)this.columnGroups.get(j)).getName());
        }
        return emptyCell;
    }

    protected void inheritCellSize(int i, int j) {
        JRDesignCellContents contents;
        block6: {
            block7: {
                JRDesignCrosstabCell cell = this.crossCells[i][j];
                contents = (JRDesignCellContents)cell.getContents();
                if (contents.getWidth() != Integer.MIN_VALUE) break block6;
                if (i >= this.rowGroups.size()) break block7;
                JRDesignCrosstabCell rowCell = this.crossCells[this.rowGroups.size()][j];
                if (rowCell == null) break block6;
                contents.setWidth(rowCell.getContents().getWidth());
                break block6;
            }
            for (int k = j + 1; k <= this.columnGroups.size(); ++k) {
                if (this.crossCells[i][k] == null) continue;
                contents.setWidth(this.crossCells[i][k].getContents().getWidth());
                break;
            }
        }
        if (contents.getHeight() == Integer.MIN_VALUE) {
            if (j < this.columnGroups.size()) {
                JRDesignCrosstabCell colCell = this.crossCells[i][this.columnGroups.size()];
                if (colCell != null) {
                    contents.setHeight(colCell.getContents().getHeight());
                }
            } else {
                for (int k = i + 1; k <= this.rowGroups.size(); ++k) {
                    if (this.crossCells[k][j] == null) continue;
                    contents.setHeight(this.crossCells[k][j].getContents().getHeight());
                }
            }
        }
    }

    protected void inheritCell(int i, int j) {
        JRDesignCellContents contents;
        JRDesignCrosstabCell cell;
        int k;
        JRDesignCrosstabCell inheritedCell = null;
        if (j < this.columnGroups.size()) {
            JRDesignCrosstabCell colCell = this.crossCells[this.rowGroups.size()][j];
            JRDesignCellContents colContents = colCell == null ? null : (JRDesignCellContents)colCell.getContents();
            for (k = j + 1; inheritedCell == null && k <= this.columnGroups.size(); ++k) {
                cell = this.crossCells[i][k];
                if (cell == null) continue;
                contents = (JRDesignCellContents)cell.getContents();
                if (colContents != null && contents.getWidth() != colContents.getWidth()) continue;
                inheritedCell = cell;
            }
        }
        if (inheritedCell == null && i < this.rowGroups.size()) {
            JRDesignCrosstabCell rowCell = this.crossCells[i][this.columnGroups.size()];
            JRDesignCellContents rowContents = rowCell == null ? null : (JRDesignCellContents)rowCell.getContents();
            for (k = i + 1; inheritedCell == null && k <= this.rowGroups.size(); ++k) {
                cell = this.crossCells[k][j];
                if (cell == null) continue;
                contents = (JRDesignCellContents)cell.getContents();
                if (rowContents != null && contents.getHeight() != rowContents.getHeight()) continue;
                inheritedCell = cell;
            }
        }
        this.crossCells[i][j] = inheritedCell;
    }

    protected int calculateRowHeadersSizes() {
        int widthSum = 0;
        int heightSum = 0;
        for (int i = this.rowGroups.size() - 1; i >= 0; --i) {
            JRDesignCrosstabRowGroup group = (JRDesignCrosstabRowGroup)this.rowGroups.get(i);
            widthSum += group.getWidth();
            JRDesignCrosstabCell cell = this.crossCells[i + 1][this.columnGroups.size()];
            if (cell != null) {
                heightSum += cell.getContents().getHeight();
            }
            JRDesignCellContents header = (JRDesignCellContents)group.getHeader();
            header.setHeight(heightSum);
            header.setWidth(group.getWidth());
            if (!group.hasTotal()) continue;
            JRDesignCellContents totalHeader = (JRDesignCellContents)group.getTotalHeader();
            totalHeader.setWidth(widthSum);
            JRDesignCrosstabCell totalCell = this.crossCells[i][this.columnGroups.size()];
            if (totalCell == null) continue;
            totalHeader.setHeight(totalCell.getContents().getHeight());
        }
        return widthSum;
    }

    protected int calculateColumnHeadersSizes() {
        int heightSum = 0;
        int widthSum = 0;
        for (int i = this.columnGroups.size() - 1; i >= 0; --i) {
            JRDesignCrosstabColumnGroup group = (JRDesignCrosstabColumnGroup)this.columnGroups.get(i);
            heightSum += group.getHeight();
            JRDesignCrosstabCell cell = this.crossCells[this.rowGroups.size()][i + 1];
            if (cell != null) {
                widthSum += cell.getContents().getWidth();
            }
            JRDesignCellContents header = (JRDesignCellContents)group.getHeader();
            header.setHeight(group.getHeight());
            header.setWidth(widthSum);
            if (!group.hasTotal()) continue;
            JRDesignCellContents totalHeader = (JRDesignCellContents)group.getTotalHeader();
            totalHeader.setHeight(heightSum);
            JRDesignCrosstabCell totalCell = this.crossCells[this.rowGroups.size()][i];
            if (totalCell == null) continue;
            totalHeader.setWidth(totalCell.getContents().getWidth());
        }
        return heightSum;
    }

    public JRCellContents getWhenNoDataCell() {
        return this.whenNoDataCell;
    }

    public void setWhenNoDataCell(JRDesignCellContents whenNoDataCell) {
        this.whenNoDataCell = whenNoDataCell;
    }

    public JRElement getElementByKey(String elementKey) {
        return JRBaseCrosstab.getElementByKey(this, elementKey);
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public JRCellContents getHeaderCell() {
        return this.headerCell;
    }

    public void setHeaderCell(JRDesignCellContents headerCell) {
        this.headerCell = headerCell;
    }

    protected void measureClassChanged(JRDesignCrosstabMeasure measure, String valueClassName) {
        Iterator colIt = this.columnGroups.iterator();
        while (colIt.hasNext()) {
            JRCrosstabColumnGroup colGroup = (JRCrosstabColumnGroup)colIt.next();
            this.setTotalVarClass(measure, null, colGroup, valueClassName);
        }
        Iterator rowIt = this.rowGroups.iterator();
        while (rowIt.hasNext()) {
            JRCrosstabRowGroup rowGroup = (JRCrosstabRowGroup)rowIt.next();
            this.setTotalVarClass(measure, rowGroup, null, valueClassName);
            Iterator colIt2 = this.columnGroups.iterator();
            while (colIt2.hasNext()) {
                JRCrosstabColumnGroup colGroup = (JRCrosstabColumnGroup)colIt2.next();
                this.setTotalVarClass(measure, rowGroup, colGroup, valueClassName);
            }
        }
    }

    protected void setTotalVarClass(JRCrosstabMeasure measure, JRCrosstabRowGroup rowGroup, JRCrosstabColumnGroup colGroup, String valueClassName) {
        JRDesignVariable variable = this.getVariable(JRDesignCrosstab.getTotalVariableName(measure, rowGroup, colGroup));
        variable.setValueClassName(valueClassName);
    }

    private void addVariable(JRVariable variable) {
        this.variablesList.put(variable.getName(), variable);
    }

    private void removeVariable(JRVariable variable) {
        this.removeVariable(variable.getName());
    }

    private void removeVariable(String varName) {
        this.variablesList.remove(varName);
    }

    private JRDesignVariable getVariable(String varName) {
        return (JRDesignVariable)this.variablesList.get(varName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Pair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Object o1;
        final Object o2;

        Pair(Object o1, Object o2) {
            this.o1 = o1;
            this.o2 = o2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof Pair)) {
                return false;
            }
            Pair p = (Pair)o;
            return (p.o1 == null ? this.o1 == null : this.o1 != null && p.o1.equals(this.o1)) && (p.o2 == null ? this.o2 == null : this.o2 != null && p.o2.equals(this.o2));
        }

        public int hashCode() {
            int hash = this.o1 == null ? 0 : this.o1.hashCode();
            hash *= 31;
            return hash += this.o2 == null ? 0 : this.o2.hashCode();
        }
    }

    private class MeasureClassChangeListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 10200L;

        private MeasureClassChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JRDesignCrosstab.this.measureClassChanged((JRDesignCrosstabMeasure)evt.getSource(), (String)evt.getNewValue());
        }
    }
}

